/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.mservice;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.Gauger;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.pigeon.PigeonConsumerManager;
import kd.bos.pigeon.core.data.PigeonMessageDTO;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.StoreDbConfigFactory;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.pigeon.dispatch.mservice.DispatchTaskDTOWrapper;
import kd.bos.pigeon.dispatch.mservice.HashQueue;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.KDThreadPoolFactory;
import kd.bos.resource.balancer.ResourceBalanceErrorCode;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolEnum;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

class TaskHandlerThread
extends Thread {
    private static final Log LOGGER = LogFactory.getLog(TaskHandlerThread.class);
    private static final String maxPoolCount = System.getProperty("mq.consumer.maxpoolsize", "32");
    private static final ThreadPool originThreadPool = ThreadPools.newCachedThreadPool((String)"MqConsumer", (int)5, (int)Integer.parseInt(maxPoolCount));
    private static final KDThreadPoolExecutor multiTenantThreadPool = KDThreadPoolFactory.getOrCreate((String)KDThreadPoolEnum.MQ.getResourceName(), (int)5, (int)Integer.parseInt(maxPoolCount));
    private static final AtomicInteger receivedMessageSize = new AtomicInteger(0);
    private final String threadName;
    private final String bizType;
    private final HashQueue<String, DispatchTaskDTOWrapper> taskQueue;
    private final AtomicInteger activeThreadCount;

    public TaskHandlerThread(String bizType, HashQueue<String, DispatchTaskDTOWrapper> taskQueue) {
        super("TaskHandlerThread_" + bizType);
        this.threadName = "TaskHandlerThread_" + bizType;
        this.bizType = bizType;
        this.taskQueue = taskQueue;
        this.activeThreadCount = new AtomicInteger(0);
    }

    @Override
    public void run() {
        HashSet<String> waitQueueSet = new HashSet<String>();
        while (true) {
            DispatchTaskDTOWrapper taskDTOWrapper = null;
            try {
                Runnable runnable;
                taskDTOWrapper = this.taskQueue.take();
                String queueName = taskDTOWrapper.getTaskDTO().getQueueName();
                AtomicInteger concurrency = PigeonConsumerManager.getConcurrency((String)queueName);
                if (concurrency == null) {
                    LOGGER.info("queueName={} lose concurrency", (Object)queueName);
                    DispatchTaskDTOWrapper finalTaskDTOWrapper = taskDTOWrapper;
                    runnable = () -> {
                        try {
                            this.returnSchedule(finalTaskDTOWrapper);
                        }
                        catch (Exception e) {
                            LOGGER.error("returnScheduleError", (Throwable)e);
                        }
                    };
                    if (Configs.isPigeonResourceBalanceEnable()) {
                        multiTenantThreadPool.execute(runnable);
                        continue;
                    }
                    originThreadPool.execute(runnable);
                    continue;
                }
                if (concurrency.get() < 1) {
                    this.taskQueue.addFirst(queueName, taskDTOWrapper);
                    this.taskQueue.moveMatchToEnd(queueName, (Predicate<DispatchTaskDTOWrapper>)((Predicate)wrapper -> Objects.equals(queueName, wrapper.getTaskDTO().getQueueName())));
                    if (waitQueueSet.contains(queueName)) {
                        LockSupport.parkNanos(50000000L);
                        continue;
                    }
                    waitQueueSet.add(queueName);
                    continue;
                }
                waitQueueSet.remove(queueName);
                concurrency.decrementAndGet();
                PigeonRequestContextUtil.createDbRequestContext((String)taskDTOWrapper.getTenantId(), (String)taskDTOWrapper.getAccountId());
                DispatchTaskDTOWrapper innerTaskDTOWrapper = taskDTOWrapper;
                try {
                    runnable = () -> {
                        try {
                            this.activeThreadCount.incrementAndGet();
                            DispatchTaskDTO<?> taskDTO = innerTaskDTOWrapper.getTaskDTO();
                            PigeonConsumerManager.innerHandleDelivery((String)this.bizType, (String)queueName, (PigeonMessageDTO)((PigeonMessageDTO)taskDTO.getT()));
                        }
                        catch (Exception e) {
                            LOGGER.error("handleMessageError", (Throwable)e);
                        }
                        finally {
                            concurrency.incrementAndGet();
                            PigeonConsumerManager.getWaiting((String)queueName).incrementAndGet();
                            this.activeThreadCount.decrementAndGet();
                        }
                    };
                    receivedMessageSize.incrementAndGet();
                    if (Configs.isPigeonResourceBalanceEnable()) {
                        multiTenantThreadPool.execute(runnable);
                        continue;
                    }
                    originThreadPool.execute(runnable);
                }
                catch (Throwable t) {
                    KDException kdException;
                    if (t instanceof KDException && (kdException = (KDException)t).getErrorCode() == ResourceBalanceErrorCode.rejectedException && taskDTOWrapper != null) {
                        this.returnSchedule(taskDTOWrapper);
                    }
                    concurrency.incrementAndGet();
                    PigeonConsumerManager.getWaiting((String)queueName).incrementAndGet();
                }
                continue;
            }
            catch (Throwable t) {
                LOGGER.error("TaskHandlerThread run error", t);
                continue;
            }
            break;
        }
    }

    private void returnSchedule(DispatchTaskDTOWrapper taskDTOWrapper) {
        PigeonRequestContextUtil.createDbRequestContext((String)taskDTOWrapper.getTenantId(), (String)taskDTOWrapper.getAccountId());
        IStoreDbConfig storeDbConfig = StoreDbConfigFactory.getDbConfigByBizType((String)this.bizType);
        QueueMessageEntity messageEntity = QueueMessageEntityHelper.query((IStoreDbConfig)storeDbConfig, (long)taskDTOWrapper.getTaskDTO().getId());
        int reConsumeTime = messageEntity.getReConsumeTime();
        String updateStatus = MessageStatus.READY.getDesc();
        if (reConsumeTime > 0) {
            updateStatus = MessageStatus.RETRY.getDesc();
        }
        QueueMessageEntityHelper.update((IStoreDbConfig)storeDbConfig, (long)taskDTOWrapper.getTaskDTO().getId(), (String)updateStatus, (String[])new String[]{MessageStatus.RECEIVED.getDesc()});
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount.get();
    }

    static {
        MetricSystem.gauge((String)"kd.metrics.mq.pigeon.received.message.size", () -> {
            Gauger metricsObj = new Gauger();
            metricsObj.setValueSupplier(() -> receivedMessageSize.getAndSet(0));
            return metricsObj;
        });
    }
}

