/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.tranformation.route;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.pigeon.dispatch.support.DispatchActivate;
import kd.bos.pigeon.dispatch.tranformation.route.DispatchRoute;

public class DispatchRouteFactory {
    private static final String defaultRoute = "appId";
    private static final Map<String, DispatchRoute> bizType2dispatchRouteMap = new HashMap<String, DispatchRoute>();

    public static DispatchRoute getDispatchRoute(String bizType) {
        DispatchRoute dispatchRoute = bizType2dispatchRouteMap.get(bizType);
        if (dispatchRoute == null) {
            dispatchRoute = bizType2dispatchRouteMap.get("pigeon");
        }
        return dispatchRoute;
    }

    static {
        for (DispatchRoute tempDispatchRoute : ServiceLoader.load(DispatchRoute.class)) {
            DispatchActivate tempDispatchActivate = tempDispatchRoute.getClass().getDeclaredAnnotation(DispatchActivate.class);
            if (tempDispatchActivate == null) continue;
            String tempBizType = tempDispatchActivate.bizType();
            if (tempBizType.equals("pigeon")) {
                if (!tempDispatchRoute.name().equals(defaultRoute)) continue;
                bizType2dispatchRouteMap.putIfAbsent(tempBizType, tempDispatchRoute);
                continue;
            }
            bizType2dispatchRouteMap.putIfAbsent(tempBizType, tempDispatchRoute);
        }
    }
}

