/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock;

import java.util.Map;
import kd.bos.dlock.DLockFactory;
import kd.bos.dlock.DLockInfo;
import kd.bos.dlock.DLockUtil;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public interface DLock
extends AutoCloseable {
    public void lock();

    public boolean tryLock();

    public boolean tryLock(long var1);

    public void unlock();

    @Override
    @SdkInternal
    public void close();

    @SdkInternal
    public DLock fastMode();

    @SdkInternal
    public DLock stableMode();

    public static DLock create(String key) {
        return DLock.create(key, null);
    }

    public static DLock create(String key, String desc) {
        return DLockFactory.createDLock(key, desc, false);
    }

    public static DLock createReentrant(String key) {
        return DLock.createReentrant(key, null);
    }

    public static DLock createReentrant(String key, String desc) {
        return DLockFactory.createDLock(key, desc, true);
    }

    @SdkInternal
    public static Map<String, DLockInfo> getAllLockInfo() {
        return DLockFactory.getAllLockInfo();
    }

    @SdkInternal
    public static DLockInfo getLockInfo(String key) {
        return DLockFactory.getLockInfo(key);
    }

    @SdkInternal
    public static void forceUnlock(String ... keys) {
        DLockFactory.forceUnlock(keys);
    }

    @SdkInternal
    public static void forceClear(String ... keys) {
        DLockFactory.forceClear(keys);
    }

    @SdkInternal
    public static boolean isInstanceAlive(String instance) throws KDException {
        return DLockUtil.isInstanceAlive(instance);
    }
}

