/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock;

import java.util.HashMap;
import java.util.Map;
import kd.bos.api.Probe;
import kd.bos.dlock.CrossCluster;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.dlock.DLockKeys;
import kd.bos.dlock.DLockManager;
import kd.bos.dlock.DLockMode;
import kd.bos.dlock.DLockType;
import kd.bos.dlock.DLockUtil;
import kd.bos.dlock.config.DLockConfig;
import kd.bos.dlock.curator.CuratorLockManager;
import kd.bos.dlock.redis.RedisLockManager;
import kd.bos.exception.KDExceptionKit;

public final class DLockFactory {
    public static final String DLOCK_PREFIX = "/__dlock__";
    public static final String DLOCK_PREFIX2 = "/dlock/";
    private static volatile CuratorLockManager clocker;
    private static volatile RedisLockManager rlocker;

    public static String getRootPath(boolean zk) {
        if (zk) {
            return DLockUtil.getZKLockRootPath(DLockConfig.isdLockVersion2());
        }
        return DLockUtil.getRedisLockRootPath(DLockConfig.isdLockVersion2());
    }

    private static DLockManager getDLockerManager() {
        return DLockFactory.getDLockerManager(DLockConfig.getDLockType());
    }

    public static DLockManager getDLockerManager(DLockType dlockType) {
        if (dlockType == DLockType.redis) {
            DLockFactory.lazyInitRLocker();
            return rlocker;
        }
        DLockFactory.lazyInitCLocker();
        return clocker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lazyInitRLocker() {
        if (rlocker != null) {
            return;
        }
        Class<DLockFactory> clazz = DLockFactory.class;
        synchronized (DLockFactory.class) {
            if (rlocker == null) {
                String rootPath = CrossCluster.getClusterNameForPath() != null ? DLockFactory.getRootPath(false) : (DLockConfig.isdLockVersion2() ? DLOCK_PREFIX2 : DLOCK_PREFIX);
                String url = DLockUtil.getRedisUrl();
                rlocker = new RedisLockManager(url.trim(), rootPath);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lazyInitCLocker() {
        if (clocker != null) {
            return;
        }
        Class<DLockFactory> clazz = DLockFactory.class;
        synchronized (DLockFactory.class) {
            if (clocker == null) {
                String zookeeper = DLockUtil.getZookeeperUrl();
                String rootPath = DLockFactory.getRootPath(true);
                try {
                    DLockMode mode = Boolean.getBoolean("DLock.performance") ? DLockMode.performance : DLockMode.stability;
                    clocker = new CuratorLockManager(zookeeper, rootPath, mode);
                }
                catch (Exception e) {
                    throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static DLock createDLock(String lockPath, String lockDesc, boolean reentrant) {
        Probe.touch((String)"dlock");
        DLockKeys.checkAvailable(lockPath);
        lockPath = DLockKeys.maskStoreKey(lockPath);
        return DLockFactory.getDLockerManager().createLock(lockPath, lockDesc, reentrant);
    }

    static Map<String, DLockInfo> getAllLockInfo() {
        Map<String, DLockInfo> map = DLockFactory.getDLockerManager().getAllLockInfo();
        if (!map.isEmpty()) {
            HashMap<String, DLockInfo> ret = new HashMap<String, DLockInfo>(map.size());
            for (Map.Entry<String, DLockInfo> entry : map.entrySet()) {
                DLockInfo lock = entry.getValue();
                String key = DLockKeys.unmaskStoreKey(entry.getKey());
                lock.setKey(key);
                ret.put(key, lock);
            }
            map = ret;
        }
        return map;
    }

    static DLockInfo getLockInfo(String key) {
        String storeKey = DLockKeys.maskStoreKey(key);
        DLockInfo ret = DLockFactory.getDLockerManager().getLockInfo(storeKey);
        if (ret != null) {
            ret.setKey(key);
        }
        return ret;
    }

    static void forceUnlock(String ... keys) {
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = DLockKeys.maskStoreKey(keys[i]);
        }
        DLockFactory.getDLockerManager().forceUnlock(keys);
    }

    static void forceClear(String ... keys) {
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = DLockKeys.maskStoreKey(keys[i]);
        }
        DLockFactory.getDLockerManager().forceClear(keys);
    }
}

