/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.config;

import kd.bos.dlock.DLockType;
import kd.bos.util.ConfigurationUtil;

public class DLockConfig {
    public static final String DLOCK_STORE_ZOOKEEPER = "DLock.zookeeper";
    public static final String DLOCK_STORE_ZOOKEEPERS = "DLock.zookeepers";
    public static final String DLOCK_PERFORMANCE = "DLock.performance";
    private static final String DLOCK_TYPE = "DLock.type";
    private static DLockType dlockType = DLockType.zookeeper;
    public static final String REDIS_CACHE_URL_KEY = "redis.serversForCache";
    public static final String REDIS_DLOCK_URL_KEY = "DLock.redis";
    public static final String REDIS_DLOCK_URLS_KEY = "DLock.redises";
    private static final String DLOCK_VERSION2 = "DLock.version2";
    private static final String DLOCK_CLEAN_ENABLE = "DLock.clean.enable";
    private static final String DLOCK_CLEAN_CRON = "DLock.clean.cron";
    private static final String DLOCK_USE_REDIS_ACQUIRED = "DLock.useRedisAcquired";
    private static final String DLOCK_EXPIRE_TIMEOUT = "DLock.expireTimeout";
    private static final String DLOCK_ACQUIRED_TIMEOUT = "DLock.acquiredTimeoutMillis";
    private static final String DLOCK_LOCK_MAXIMUM = "DLock.lockMaximum";
    private static final String DLOCK_LOCK_MAXIMUM_ENABLE = "DLock.lockMaximum.enable";
    private static final String DLOCK_DESC_WITH_THREAD = "dlock.monitor.descWithThread";
    private static final String DLOCK_ACQUIRE_RETRY_TIMES = "DLock.acquireRetryTimes";
    private static boolean dLockVersion2 = true;
    private static boolean dLockCleanEnable = true;
    private static String dLockCleanCron = "0 0 5 5,10,15,20,25 * ?";
    private static boolean useRedisAcquired = true;
    private static int expireTimeout = 14400;
    private static long acquiredTimeoutMillis = 30000L;
    private static boolean lockMaxLimitEnable = true;
    private static int lockMaximum = 500;
    private static boolean descWithThread = false;
    private static int acquireRetryTimes = 3;

    public static DLockType getDLockType() {
        return dlockType;
    }

    public static boolean isdLockVersion2() {
        return dLockVersion2;
    }

    public static boolean dLockCleanEnable() {
        return dLockCleanEnable;
    }

    public static String getCleanCron() {
        return dLockCleanCron;
    }

    public static boolean useRedisAcquired() {
        return useRedisAcquired;
    }

    public static int getExpireTimeout() {
        return expireTimeout * 1000;
    }

    public static long getAcquiredTimeoutMillis() {
        return acquiredTimeoutMillis;
    }

    public static int getLockMaximum() {
        return lockMaximum;
    }

    public static boolean isLockMaximumEnable() {
        return lockMaxLimitEnable;
    }

    public static boolean isDescWithThread() {
        return descWithThread;
    }

    public static int getAcquireRetryTimes() {
        return acquireRetryTimes;
    }

    static {
        ConfigurationUtil.observeString((String)DLOCK_TYPE, (String)dlockType.name(), v -> {
            try {
                dlockType = DLockType.valueOf(v);
            }
            catch (Exception e) {
                dlockType = DLockType.zookeeper;
            }
        });
        ConfigurationUtil.observeBoolean((String)DLOCK_VERSION2, (boolean)dLockVersion2, v -> {
            dLockVersion2 = v;
        });
        ConfigurationUtil.observeBoolean((String)DLOCK_CLEAN_ENABLE, (boolean)dLockCleanEnable, v -> {
            dLockCleanEnable = v;
        });
        ConfigurationUtil.observeString((String)DLOCK_CLEAN_CRON, (String)dLockCleanCron, v -> {
            dLockCleanCron = v;
        });
        ConfigurationUtil.observeBoolean((String)DLOCK_USE_REDIS_ACQUIRED, (boolean)useRedisAcquired, v -> {
            useRedisAcquired = v;
        });
        ConfigurationUtil.observeInteger((String)DLOCK_EXPIRE_TIMEOUT, (int)expireTimeout, v -> {
            expireTimeout = v;
        });
        ConfigurationUtil.observeLong((String)DLOCK_ACQUIRED_TIMEOUT, (long)acquiredTimeoutMillis, v -> {
            acquiredTimeoutMillis = v;
        });
        ConfigurationUtil.observeInteger((String)DLOCK_LOCK_MAXIMUM, (int)lockMaximum, v -> {
            lockMaximum = v;
        });
        ConfigurationUtil.observeBoolean((String)DLOCK_DESC_WITH_THREAD, (boolean)descWithThread, v -> {
            descWithThread = v;
        });
        ConfigurationUtil.observeBoolean((String)DLOCK_LOCK_MAXIMUM_ENABLE, (boolean)lockMaxLimitEnable, v -> {
            lockMaxLimitEnable = v;
        });
        ConfigurationUtil.observeInteger((String)DLOCK_ACQUIRE_RETRY_TIMES, (int)acquireRetryTimes, v -> {
            acquireRetryTimes = v;
        });
    }
}

