/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.curator;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.bundle.Resources;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.dlock.AbstractDLock;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.dlock.DLockManager;
import kd.bos.dlock.DLockMode;
import kd.bos.dlock.DLockUtil;
import kd.bos.dlock.config.DLockConfig;
import kd.bos.dlock.curator.InterProcessMutexPerformance;
import kd.bos.dlock.curator.InterProcessMutexStability;
import kd.bos.dlock.curator.ZookeeperClientSplit;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.KDExceptionKit;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.DisCardUtil;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundVersionable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorLockManager
implements DLockManager {
    private static final Logger log = LoggerFactory.getLogger(CuratorLockManager.class);
    private static final String TRACER_NAME = "DLock";
    private static final String AUDIT_NAME = "dlock_cost";
    private static final String LEASE_PARENT = "leases";
    private static final String LOCK_PARENT = "locks";
    private static final String LOCK_ACQUIRED = "acquired";
    private static final String REDIS_URL = InterProcessMutexStability.REDIS_URL;
    private static final DLockInfoItem no_lockinfo_with_lockkey = new DLockInfoItem(null, true);
    private static final DLockInfoItem no_lockinfo_without_lockkey = new DLockInfoItem(null, false);
    private static final ThreadLocal<Map<String, ReentrantDLock>> thReentrantDLock = ThreadLocal.withInitial(() -> new HashMap());
    private DLockMode defaultMode;
    private ZookeeperClientSplit zkClient;
    private String connectString;
    private final String rootPath;
    private static volatile Map<String, AtomicInteger> keySizeMap = new ConcurrentHashMap<String, AtomicInteger>();

    public CuratorLockManager(String connectString, String rootPath, DLockMode defaultMode) throws KDException {
        this.connectString = connectString;
        this.rootPath = rootPath == null ? "" : rootPath.trim();
        this.defaultMode = defaultMode;
        this.start();
    }

    private void start() throws KDException {
        this.zkClient = new ZookeeperClientSplit(this.connectString);
    }

    private String getFullPath(String lockPath) {
        return DLockUtil.getFullPath(this.rootPath, lockPath.trim());
    }

    @Override
    public DLock createLock(final String lockPath, final String lockDesc, final boolean reentrant) {
        ReentrantDLock rlock;
        final CuratorFramework client = this.zkClient.getBalanceClient(lockPath);
        final String fullPath = this.getFullPath(lockPath);
        if (reentrant && (rlock = thReentrantDLock.get().get(fullPath)) != null) {
            return rlock.lock;
        }
        final AtomicInteger count = keySizeMap.computeIfAbsent(fullPath, k -> new AtomicInteger(0));
        this.incrementLockCount(count);
        AbstractDLock lock = new AbstractDLock(){
            private static final String TRACER_ACQUIRE_NAME = "acquire";
            private static final String TRACER_PATH_TAG_NAME = "path";
            private boolean acquired = false;
            private boolean lockOccurException = false;
            private boolean calledUnlock = false;
            private DLockMode lockMode = CuratorLockManager.access$200(CuratorLockManager.this);
            private InterProcessLock mutex;

            @Override
            public String[] getLockAccountIds() {
                GetChildrenBuilder getChildren = client.getChildren();
                try {
                    String path = CuratorLockManager.this.rootPath.substring(0, CuratorLockManager.this.rootPath.lastIndexOf(47));
                    List accountIds = (List)getChildren.forPath(path);
                    if (!accountIds.isEmpty()) {
                        Set<String> ret = DLockConfig.isdLockVersion2() ? accountIds.stream().collect(Collectors.toSet()) : this.getPrefixAccountIds("__dlock__", accountIds);
                        if (ret.isEmpty()) {
                            return empty_strings;
                        }
                        return ret.toArray(new String[ret.size()]);
                    }
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                }
                return empty_strings;
            }

            private Set<String> getPrefixAccountIds(String prefix, List<String> accountIds) {
                TreeSet<String> ret = new TreeSet<String>();
                for (String key : accountIds) {
                    if (!key.startsWith(prefix)) continue;
                    ret.add(key.substring(prefix.length()));
                }
                return ret;
            }

            private InterProcessLock getMutex(boolean ensureCreate) {
                block4: {
                    block5: {
                        if (this.mutex != null) break block4;
                        if (!ensureCreate) break block5;
                        switch (this.lockMode) {
                            case performance: {
                                this.mutex = new InterProcessMutexPerformance(client, fullPath, lockDesc);
                                break block4;
                            }
                            case stability: {
                                this.mutex = new InterProcessMutexStability(client, fullPath, lockDesc);
                                break block4;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupproted mode: " + (Object)((Object)this.lockMode));
                            }
                        }
                    }
                    throw new IllegalStateException(Resources.getString((String)"bos-dlock", (String)"CuratorLockManager_0", (Object[])new Object[0]));
                }
                return this.mutex;
            }

            @Override
            public void lock() {
                try {
                    CuratorLockManager.this.validateLockCount(fullPath, count, client);
                    log.info("acquire lock " + lockPath + "...");
                    if (reentrant) {
                        ReentrantDLock rd = (ReentrantDLock)((Map)thReentrantDLock.get()).get(fullPath);
                        if (rd.ref <= 0) {
                            this.tryAcquire();
                        }
                        rd.incRef();
                    } else {
                        this.tryAcquire();
                    }
                    log.info("acquired lock " + lockPath);
                }
                catch (Exception e) {
                    log.error("acquire lock failed: " + fullPath, (Throwable)e);
                    this.lockOccurException = true;
                    CuratorLockManager.this.decrementLockCount(fullPath);
                    throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                }
            }

            private void tryAcquire() throws Exception {
                try (TraceSpan ts = Tracer.create((String)CuratorLockManager.TRACER_NAME, (String)TRACER_ACQUIRE_NAME);
                     MemSpanTrace mst = MemSpanTrace.create((String)CuratorLockManager.TRACER_NAME, (String)TRACER_ACQUIRE_NAME);
                     Auditable audit = Audit.audit((String)CuratorLockManager.AUDIT_NAME, (Object[])new Object[]{lockPath});){
                    mst.addTag(TRACER_PATH_TAG_NAME, lockPath);
                    ts.addTag(TRACER_PATH_TAG_NAME, lockPath);
                    this.getMutex(true).acquire();
                    this.acquired = true;
                }
            }

            @Override
            public boolean tryLock(long timeoutMillis) {
                try {
                    CuratorLockManager.this.validateLockCount(fullPath, count, client);
                    log.info("acquire lock " + lockPath + "...");
                    if (reentrant) {
                        ReentrantDLock rd = (ReentrantDLock)((Map)thReentrantDLock.get()).get(fullPath);
                        if (rd.ref > 0) {
                            rd.incRef();
                            log.info("acquired lock " + lockPath);
                            return true;
                        }
                        if (this.getMutex(true).acquire(timeoutMillis, TimeUnit.MILLISECONDS)) {
                            this.acquired = true;
                            rd.incRef();
                            log.info("acquired lock " + lockPath);
                            return true;
                        }
                    } else if (this.getMutex(true).acquire(timeoutMillis, TimeUnit.MILLISECONDS)) {
                        this.acquired = true;
                        log.info("acquired lock " + lockPath);
                        return true;
                    }
                }
                catch (Exception e) {
                    log.error("acquire lock failed: " + fullPath, (Throwable)e);
                    this.lockOccurException = true;
                    CuratorLockManager.this.decrementLockCount(fullPath);
                    throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                }
                return false;
            }

            @Override
            public boolean tryLock() {
                return this.tryLock(1L);
            }

            @Override
            public void unlock() {
                if (!this.lockOccurException && !this.calledUnlock) {
                    CuratorLockManager.this.decrementLockCount(fullPath);
                }
                this.calledUnlock = true;
                if (!this.acquired) {
                    return;
                }
                RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
                RequestTimeoutContext.set(null);
                try {
                    log.info("release lock " + lockPath + "...");
                    if (reentrant) {
                        ReentrantDLock rd = (ReentrantDLock)((Map)thReentrantDLock.get()).get(fullPath);
                        if (rd == null) {
                            throw new IllegalStateException(Resources.getString((String)"bos-dlock", (String)"CuratorLockManager_1", (Object[])new Object[0]));
                        }
                        rd.decRef();
                        if (rd.canRelease()) {
                            this.getMutex(false).release();
                            this.mutex = null;
                            this.acquired = false;
                            ((Map)thReentrantDLock.get()).remove(fullPath);
                            CuratorLockManager.this.tryClear(client, fullPath);
                        }
                    } else {
                        this.getMutex(false).release();
                        this.mutex = null;
                        this.acquired = false;
                        CuratorLockManager.this.tryClear(client, fullPath);
                    }
                }
                catch (Exception e) {
                    log.error("unlock failed: " + fullPath, (Throwable)e);
                    throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                }
                finally {
                    RequestTimeoutContext.set((RequestTimeoutContext)requestTimeoutContext);
                }
            }

            @Override
            public void close() {
                this.unlock();
            }

            @Override
            public DLock fastMode() {
                this.lockMode = DLockMode.performance;
                return this;
            }

            @Override
            public DLock stableMode() {
                this.lockMode = DLockMode.stability;
                return this;
            }
        };
        if (reentrant) {
            thReentrantDLock.get().put(fullPath, new ReentrantDLock(lock));
        }
        return lock;
    }

    private void validateLockCount(String fullPath, AtomicInteger currentNum, CuratorFramework client) throws Exception {
        if (DLockConfig.isLockMaximumEnable() && DLockConfig.getLockMaximum() < currentNum.get()) {
            Stat stat = (Stat)client.checkExists().forPath(fullPath + "/locks");
            if (stat == null) {
                TimeUnit.SECONDS.sleep(2L);
                stat = (Stat)client.checkExists().forPath(fullPath + "/locks");
            }
            if (stat != null && stat.getNumChildren() > DLockConfig.getLockMaximum()) {
                throw new KDException(BosErrorCode.dlock, new Object[]{String.format("Acquire the lock error, the number of locks cannot exceed the maximum.\n Instance=%s, lockKey=%s, maximum=%s", Instance.getInstanceId(), fullPath, DLockConfig.getLockMaximum())});
            }
            log.warn(String.format("Something wrong occurred in the lock path :%s, maybe the lock was not close correctly.Resetting concurrent lock count.", fullPath));
            this.resetLockCount(fullPath);
        }
    }

    private synchronized void incrementLockCount(AtomicInteger count) {
        count.getAndIncrement();
    }

    private synchronized void decrementLockCount(String fullPath) {
        AtomicInteger lockCount = keySizeMap.get(fullPath);
        if (lockCount != null && lockCount.decrementAndGet() <= 0) {
            keySizeMap.remove(fullPath);
        }
    }

    private synchronized void resetLockCount(String fullPath) {
        AtomicInteger lockCount = keySizeMap.get(fullPath);
        if (lockCount != null) {
            lockCount.set(0);
        }
    }

    private void tryClear(CuratorFramework client, String fullPath) {
        try {
            client.transaction().forOperations(new CuratorOp[]{(CuratorOp)client.transactionOp().delete().forPath(fullPath + '/' + LOCK_PARENT), (CuratorOp)client.transactionOp().delete().forPath(fullPath + '/' + LEASE_PARENT), (CuratorOp)client.transactionOp().delete().forPath(fullPath)});
        }
        catch (KeeperException.NoNodeException | KeeperException.NotEmptyException e) {
            DisCardUtil.discard();
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    @Override
    public Map<String, DLockInfo> getAllLockInfo() {
        HashMap<String, DLockInfo> ret = new HashMap<String, DLockInfo>();
        try {
            for (CuratorFramework client : this.zkClient.getClients()) {
                GetChildrenBuilder getChildren = client.getChildren();
                ExistsBuilder checkExists = client.checkExists();
                GetDataBuilder getData = client.getData();
                String path = this.getFullPath("");
                path = path.substring(0, path.length() - 1);
                for (String key : (List)getChildren.forPath(path)) {
                    this.getAllLockInfo(key, ret, getChildren, checkExists, getData);
                }
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return ret;
    }

    private void getAllLockInfo(String longKey, Map<String, DLockInfo> map, GetChildrenBuilder getChildren, ExistsBuilder checkExists, GetDataBuilder getData) {
        DLockInfoItem di = this.getLockInfo(longKey, getChildren, checkExists, getData);
        if (di.info != null) {
            map.put(longKey, di.info);
        } else if (!di.isLockKey) {
            try {
                for (String key : (List)getChildren.forPath(this.getFullPath(longKey))) {
                    String subKey = longKey + '/' + key;
                    this.getAllLockInfo(subKey, map, getChildren, checkExists, getData);
                }
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
        }
    }

    @Override
    public DLockInfo getLockInfo(String key) {
        return this.getLockInfo(key, this.zkClient.getBalanceClient(key).getChildren(), this.zkClient.getBalanceClient(key).checkExists(), this.zkClient.getBalanceClient(key).getData()).info;
    }

    private DLockInfoItem getLockInfo(String key, GetChildrenBuilder getChildren, ExistsBuilder checkExists, GetDataBuilder getData) {
        try {
            String value = null;
            long ephemeralOwner = 0L;
            long ctime = 0L;
            int waitingLocks = 0;
            String leasesPath = this.getFullPath(key + '/' + LEASE_PARENT);
            Stat leasesStat = (Stat)checkExists.forPath(leasesPath);
            if (leasesStat == null) {
                return no_lockinfo_without_lockkey;
            }
            if (leasesStat.getNumChildren() <= 0) {
                return no_lockinfo_with_lockkey;
            }
            List lockIds = (List)getChildren.forPath(leasesPath);
            List sortedLockIds = lockIds.stream().sorted(Comparator.comparing(o -> o.substring(o.indexOf("-lease-") + 7))).collect(Collectors.toList());
            for (String lockId : sortedLockIds) {
                String lockIdPath = leasesPath + '/' + lockId;
                if (value == null) {
                    value = new String((byte[])getData.forPath(lockIdPath), "UTF-8");
                }
                Stat idStat = (Stat)checkExists.forPath(lockIdPath);
                if (ctime != 0L && ctime <= idStat.getCtime()) continue;
                ctime = idStat.getCtime();
                ephemeralOwner = idStat.getEphemeralOwner();
            }
            String locksPath = this.getFullPath(key + '/' + LOCK_PARENT);
            Stat locksStat = (Stat)checkExists.forPath(locksPath);
            if (locksStat != null) {
                waitingLocks += locksStat.getNumChildren();
            }
            return new DLockInfoItem(new DLockInfo(key, this.getFullPath(""), value, ephemeralOwner, ctime, 0L, waitingLocks), true);
        }
        catch (Exception e) {
            DisCardUtil.discard();
            return no_lockinfo_without_lockkey;
        }
    }

    @Override
    public void forceUnlock(String ... keys) {
        if (keys == null || keys.length <= 0) {
            return;
        }
        try {
            for (String key : keys) {
                String path;
                GetChildrenBuilder getChildren;
                BackgroundVersionable deletingChildrenIfNeeded;
                block22: {
                    CuratorFramework client = this.zkClient.getBalanceClient(key);
                    deletingChildrenIfNeeded = ((ChildrenDeletable)client.delete().guaranteed()).deletingChildrenIfNeeded();
                    getChildren = client.getChildren();
                    path = this.getFullPath(key);
                    try {
                        if (DLockConfig.useRedisAcquired()) {
                            try (JedisClient jedisClient = RedisFactory.getJedisClient((String)REDIS_URL);){
                                jedisClient.del(path + '/' + LOCK_ACQUIRED);
                                break block22;
                            }
                        }
                        deletingChildrenIfNeeded.forPath(path + '/' + LOCK_ACQUIRED);
                    }
                    catch (Exception e) {
                        DisCardUtil.discard();
                    }
                }
                try {
                    AtomicInteger count;
                    List leasePaths = (List)getChildren.forPath(path + '/' + LEASE_PARENT);
                    if (!leasePaths.isEmpty()) {
                        log.info("unlock path :" + path);
                        List sortedList = leasePaths.stream().sorted(Comparator.comparing(o -> o.substring(o.indexOf("-lease-") + 7))).collect(Collectors.toList());
                        String deleteLeasePath = (String)sortedList.get(0);
                        deletingChildrenIfNeeded.forPath(path + '/' + LEASE_PARENT + '/' + deleteLeasePath);
                    }
                    if ((count = keySizeMap.get(path)) == null) continue;
                    this.decrementLockCount(path);
                }
                catch (KeeperException.NoNodeException e) {
                    DisCardUtil.discard();
                }
            }
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    @Override
    public void forceClear(String ... keys) {
        if (keys == null || keys.length <= 0) {
            return;
        }
        try {
            for (String key : keys) {
                BackgroundVersionable deletingChildrenIfNeeded = ((ChildrenDeletable)this.zkClient.getBalanceClient(key).delete().guaranteed()).deletingChildrenIfNeeded();
                String path = this.getFullPath(key);
                try {
                    log.info("clear lock path :" + path);
                    deletingChildrenIfNeeded.forPath(path);
                    keySizeMap.remove(path);
                    if (!DLockConfig.useRedisAcquired()) continue;
                    try (JedisClient jedisClient = RedisFactory.getJedisClient((String)REDIS_URL);){
                        jedisClient.del(path + '/' + LOCK_ACQUIRED);
                    }
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                }
            }
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    static /* synthetic */ DLockMode access$200(CuratorLockManager x0) {
        return x0.defaultMode;
    }

    static class ReentrantDLock {
        private DLock lock;
        private int ref;

        ReentrantDLock(DLock lock) {
            this.lock = lock;
            this.ref = 0;
        }

        void incRef() {
            ++this.ref;
        }

        void decRef() {
            --this.ref;
        }

        boolean canRelease() {
            return this.ref <= 0;
        }
    }

    private static class DLockInfoItem {
        private DLockInfo info;
        private boolean isLockKey;

        private DLockInfoItem(DLockInfo info, boolean isLockKey) {
            this.info = info;
            this.isLockKey = isLockKey;
        }
    }
}

