/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.redis;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dlock.ClientSplit;
import kd.bos.dlock.config.BalanceConfig;
import kd.bos.dlock.redis.RedisLockManager;
import kd.bos.redis.JedisClient;

public class RedisClientSplit
extends ClientSplit {
    public RedisClientSplit(String url) {
        if (BalanceConfig.get().isRedisSplit()) {
            this.urls = url.split("\\|");
            this.split = true;
        } else {
            this.urls = new String[]{url};
            this.split = false;
        }
    }

    public List<JedisClient> getClients() {
        ArrayList<JedisClient> clients = new ArrayList<JedisClient>(this.urls.length);
        for (String url : this.urls) {
            clients.add(RedisLockManager.getOrCreate(url));
        }
        return clients;
    }

    public JedisClient getBalanceClient(String lockPath) {
        String url = this.split ? this.urls[this.hashAlgorithm(lockPath) % this.urls.length] : this.urls[0];
        return RedisLockManager.getOrCreate(url);
    }
}

