/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.redis;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import kd.bos.dlock.redis.RedisLocker;
import kd.bos.util.DisCardUtil;

class RedisLockKeeper {
    private static final long DEFAULT_TOUCH_INTERVAL = RedisLockKeeper.touchInterval(300000L);
    private static final Map<KeepObject, Long> KEEP_MAP = new ConcurrentHashMap<KeepObject, Long>();
    private static final Set<RedisLocker> UN_KEEP_SET = new ConcurrentSkipListSet<RedisLocker>();
    private static final Object TOUCH_LOCK = new Object();

    RedisLockKeeper() {
    }

    private static long touchInterval(long timeout) {
        return timeout / 2L;
    }

    private static long touch() {
        long minTS = -1L;
        for (KeepObject obj : new ArrayList<KeepObject>(KEEP_MAP.keySet())) {
            RedisLocker lock = obj.getObject();
            if (lock == null || UN_KEEP_SET.remove(lock)) {
                KEEP_MAP.remove(obj);
                continue;
            }
            try {
                long ts = obj.doTouch();
                if (minTS != -1L && minTS <= ts) continue;
                minTS = ts;
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
        }
        return minTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void keep(RedisLocker lock) {
        KEEP_MAP.put(new KeepObject(lock), 1L);
        Object object = TOUCH_LOCK;
        synchronized (object) {
            TOUCH_LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unkeep(RedisLocker lock) {
        UN_KEEP_SET.add(lock);
        if (KEEP_MAP.size() < 100) {
            Object object = TOUCH_LOCK;
            synchronized (object) {
                TOUCH_LOCK.notify();
            }
        }
    }

    static {
        new KeeperThread().start();
    }

    private static class KeeperThread
    extends Thread {
        private KeeperThread() {
            this.setDaemon(true);
            this.setName(RedisLockKeeper.class.getSimpleName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        long last = RedisLockKeeper.touch();
                        Object object = TOUCH_LOCK;
                        synchronized (object) {
                            if (last > 0L) {
                                TOUCH_LOCK.wait(last);
                            } else {
                                TOUCH_LOCK.wait(DEFAULT_TOUCH_INTERVAL);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                    continue;
                }
                break;
            }
        }
    }

    private static class KeepObject {
        private long lastTouchTS;
        private long expireTimeTS;
        private long touchIntervalTS;
        private WeakReference<RedisLocker> lockRef;

        private KeepObject(RedisLocker lock) {
            this.lockRef = new WeakReference<RedisLocker>(lock);
            this.expireTimeTS = lock.getExpireTime();
            this.lastTouchTS = System.currentTimeMillis();
            this.touchIntervalTS = RedisLockKeeper.touchInterval(this.expireTimeTS);
        }

        private RedisLocker getObject() {
            return (RedisLocker)this.lockRef.get();
        }

        private long doTouch() {
            if (System.currentTimeMillis() - this.lastTouchTS >= this.touchIntervalTS) {
                RedisLocker dlock = (RedisLocker)this.lockRef.get();
                if (dlock == null) {
                    return 1L;
                }
                if (dlock.touchExpire()) {
                    this.lastTouchTS = System.currentTimeMillis();
                } else {
                    this.lockRef.clear();
                    return 1L;
                }
            }
            return this.touchIntervalTS;
        }
    }
}

