/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.serialization;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.common.serialization.Serialization;
import kd.bos.mservice.common.serialization.support.java.JavaSerialization;
import kd.bos.mservice.common.serialization.support.kdhessian.KdHessianSerialization;
import kd.bos.mservice.common.serialization.support.nativehessian.NativeHessianSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationFactory {
    private static Logger logger = LoggerFactory.getLogger(SerializationFactory.class);
    private static Map<String, Serialization> serializations = new ConcurrentHashMap<String, Serialization>(2);

    public static final Serialization get() {
        String type = System.getProperty("mservice.rpc.serialization.type", "nativehessian");
        return SerializationFactory.get(type);
    }

    public static Serialization get(String type) {
        if (type == null) {
            return null;
        }
        return serializations.computeIfAbsent(type, k -> {
            Serialization serialization = null;
            if ("khessian".equals(type)) {
                serialization = new KdHessianSerialization();
            } else if ("nativehessian".equals(type)) {
                serialization = new NativeHessianSerialization();
            } else if ("java".equals(type)) {
                serialization = new JavaSerialization();
            } else {
                String className = System.getProperty("mservice.rpc.serialization." + type + ".class");
                if (className != null) {
                    try {
                        serialization = (Serialization)Class.forName(className).newInstance();
                    }
                    catch (Error | Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
            return serialization;
        });
    }
}

