/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.serialization.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kd.bos.mservice.serialization.KServiceSerialization;
import kd.bos.mservice.serialization.SerializationException;

public class JacksonSerialization
implements KServiceSerialization {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public void serialize(Object obj, OutputStream paramOutputStream) {
        try {
            mapper.writeValue(paramOutputStream, obj);
        }
        catch (IOException e) {
            throw new SerializationException("Jackson serialize error ", e);
        }
    }

    @Override
    public <T> T deserialize(InputStream inputStream, Class<T> type) {
        try {
            if (type.isAssignableFrom(String.class)) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                try {
                    return (T)mapper.readValue(sb.toString(), type);
                }
                catch (Exception exception) {
                    return (T)sb.toString();
                }
            }
            return (T)mapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new SerializationException("Jackson deserialize error ", e);
        }
    }

    @Override
    public <T> T deserializeWithParameterizedType(InputStream inputStream, ParameterizedType type) {
        try {
            JavaType javaType = mapper.getTypeFactory().constructType((Type)type);
            return (T)mapper.readValue(inputStream, javaType);
        }
        catch (IOException e) {
            throw new SerializationException("Jackson deserialize error ", e);
        }
    }
}

