/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nosql.document;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.UpdateOptions;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.nosql.IndexableTableStorage;
import kd.bos.nosql.ResultSet;
import kd.bos.nosql.Row;
import kd.bos.nosql.document.MongoFilterBuilder;
import kd.bos.nosql.exception.NosqlStorageErrorCode;
import kd.bos.nosql.operate.Order;
import kd.bos.nosql.operate.Query;
import kd.bos.nosql.operate.SItem;
import kd.bos.nosql.operate.Select;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;

public class MongoStorage
implements IndexableTableStorage {
    private static final String MONGOIP = "nosql.storage.indexabletable.mongo.ip";
    private static final String MONGOPORT = "nosql.storage.indexabletable.mongo.port";
    private static final String MONGOUSER = "nosql.storage.indexabletable.mongo.user";
    private static final String MONGOPASSWORD = "nosql.storage.indexabletable.mongo.password";
    private static final String MONGOBATCHSIZE = "nosql.storage.indexabletable.mongo.batchsize";
    private Logger logger = Logger.getLogger(MongoStorage.class);
    private static Map<String, MongoStorage> instances = new HashMap<String, MongoStorage>();
    private String insulateKey;
    public static final String mgID = "_id";
    public static final UpdateOptions upsertOption = new UpdateOptions().upsert(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MongoStorage instance(String insulateKey) {
        MongoStorage storage = instances.get(insulateKey);
        if (storage == null) {
            Map<String, MongoStorage> map = instances;
            synchronized (map) {
                storage = instances.get(insulateKey);
                if (storage == null) {
                    storage = new MongoStorage();
                    storage.insulateKey = insulateKey;
                    instances.put(insulateKey, storage);
                }
            }
        }
        return storage;
    }

    @Override
    public void store(String tableName, Iterator<Row> itr) {
        this.store(tableName, itr, false);
    }

    @Override
    public void add(String tableName, Iterator<Row> itr) {
        this.store(tableName, itr, true);
    }

    private void store(String tableName, Iterator<Row> itr, boolean isNew) {
        block16: {
            int batchsize = Integer.parseInt(System.getProperty(MONGOBATCHSIZE, "50000"));
            try (MongoClient mongoClient = this.getClient();){
                MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
                MongoCollection collection = mongoDatabase.getCollection(tableName);
                ArrayList<Document> documents = new ArrayList<Document>();
                int size = 0;
                while (itr.hasNext()) {
                    Row row = itr.next();
                    Object id = row.getValue(mgID);
                    Document doc = new Document();
                    row.toMap((Map<String, Object>)doc);
                    if (id == null || isNew) {
                        documents.add(doc);
                        if (++size <= batchsize) continue;
                        collection.insertMany(documents);
                        documents.clear();
                        size = 0;
                        continue;
                    }
                    Document docSave = new Document("$set", (Object)doc);
                    collection.updateMany(Filters.eq((String)mgID, (Object)id), (Bson)docSave, upsertOption);
                }
                if (documents.size() <= 0) break block16;
                try {
                    collection.insertMany(documents);
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, NosqlStorageErrorCode.mongoWrite, new Object[]{e.getMessage()});
                }
            }
        }
    }

    @Override
    public void store(String tableName, final Row ... rows) {
        if (rows == null) {
            return;
        }
        if (rows.length == 1) {
            try (MongoClient mongoClient = this.getClient();){
                MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
                MongoCollection collection = mongoDatabase.getCollection(tableName);
                Document doc = new Document();
                rows[0].toMap((Map<String, Object>)doc);
                collection.insertOne((Object)doc);
            }
            return;
        }
        Iterator<Row> my = new Iterator<Row>(){
            private int p = 0;

            @Override
            public boolean hasNext() {
                return this.p < rows.length;
            }

            @Override
            public Row next() {
                return rows[this.p++];
            }
        };
        this.store(tableName, my);
    }

    @Override
    public void removeFields(String tableName, String ... fields) {
        try (MongoClient mongoClient = this.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(tableName);
            Document document = new Document();
        }
    }

    private ResultSet query(Query query) {
        Order order;
        final MongoClient mongoClient = this.getClient();
        MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
        MongoCollection collection = mongoDatabase.getCollection(query.getFrom().getTable());
        FindIterable findIterable = query.getFilter() != null ? collection.find((Bson)query.getFilter().build(MongoFilterBuilder.getInstance())) : collection.find();
        Select select = query.getSelect();
        if (select != null) {
            BasicDBObject selectF = new BasicDBObject();
            List<String> sf = select.getSelectFiled();
            if (sf.size() != 1 || !"*".equals(sf.get(0))) {
                for (String f : sf) {
                    selectF.append(f, (Object)1);
                }
                findIterable.projection((Bson)selectF);
            }
        }
        if ((order = query.getOrder()) != null) {
            List<SItem> of = order.getOrderFields();
            BasicDBObject bcdb = new BasicDBObject();
            for (SItem si : of) {
                bcdb.append(si.getField(), (Object)this.convertSortType(si.getType()));
            }
            findIterable.sort((Bson)bcdb);
        }
        final MongoCursor mongoCursor = findIterable.iterator();
        ResultSet rs = new ResultSet(){
            private Document doc = null;

            @Override
            public boolean next() {
                if (mongoCursor.hasNext()) {
                    this.doc = (Document)mongoCursor.next();
                    return true;
                }
                mongoClient.close();
                return mongoCursor.hasNext();
            }

            @Override
            public Set<String> getAllFields() {
                return this.doc.keySet();
            }

            @Override
            public Object getValue(String field) {
                return this.doc.get((Object)field);
            }

            @Override
            public Double getDouble(String key) {
                return (Double)this.getValue(key);
            }

            @Override
            public Long getLong(String key) {
                return (Long)this.getValue(key);
            }

            @Override
            public String getString(String key) {
                return (String)this.getValue(key);
            }

            @Override
            public Boolean getBoolean(String key) {
                return (Boolean)this.getValue(key);
            }

            @Override
            public Date getDate(String key) {
                return (Date)this.getValue(key);
            }

            @Override
            public BigDecimal getBigDecimal(String key) {
                Object value = this.getValue(key);
                if (value != null) {
                    if (value instanceof Decimal128) {
                        Decimal128 dv = (Decimal128)value;
                        return dv.bigDecimalValue();
                    }
                    if (value instanceof BigDecimal) {
                        return (BigDecimal)value;
                    }
                }
                return new BigDecimal(0);
            }

            @Override
            public String toString() {
                return this.doc.toString();
            }

            @Override
            public void close() throws IOException {
                mongoClient.close();
            }
        };
        return rs;
    }

    private long count(Query query) {
        try (MongoClient mongoClient = this.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(query.getFrom().getTable());
            long count = query.getFilter() != null ? collection.count((Bson)query.getFilter().build(MongoFilterBuilder.getInstance())) : collection.count();
            long l = count;
            return l;
        }
    }

    private void deleteBySelect(Query query) {
        block13: {
            try (MongoClient mongoClient = this.getClient();){
                MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
                MongoCollection collection = mongoDatabase.getCollection(query.getFrom().getTable());
                if (query.getFilter() != null) {
                    collection.deleteMany((Bson)query.getFilter().build(MongoFilterBuilder.getInstance()));
                    break block13;
                }
                throw new KDException(NosqlStorageErrorCode.cannotbenull, new Object[]{"the filter of delete "});
            }
        }
    }

    private int convertSortType(Order.Type t) {
        switch (t) {
            case ASC: {
                return 1;
            }
            case DESC: {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public void dropIndex(String tableName, String ... fileds) {
        try (MongoClient mongoClient = this.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(tableName);
            BasicDBObject bcdb = new BasicDBObject();
            for (String filed : fileds) {
                bcdb.append(filed, (Object)1);
            }
            collection.dropIndex((Bson)bcdb);
            this.logger.debug((Object)("create compoud index : " + bcdb + ",on table :" + tableName));
        }
    }

    @Override
    public void createIndex(String tableName, String ... fileds) {
        try (MongoClient mongoClient = this.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(tableName);
            BasicDBObject bcdb = new BasicDBObject();
            for (String filed : fileds) {
                bcdb.append(filed, (Object)1);
            }
            collection.createIndex((Bson)bcdb);
            this.logger.debug((Object)("create compoud index : " + bcdb + ",on table :" + tableName));
        }
    }

    @Override
    public boolean fieldInIndex(String tableName, String filed) {
        try (MongoClient mongoClient = this.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(tableName);
            ListIndexesIterable indx = collection.listIndexes();
            for (Document d : indx) {
                if (!d.getString((Object)"name").equalsIgnoreCase(filed + "_1")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected MongoClient getClient() {
        String ip = System.getProperty(MONGOIP);
        String port = System.getProperty(MONGOPORT);
        String user = System.getProperty(MONGOUSER);
        String password = System.getProperty(MONGOPASSWORD);
        if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)password)) {
            password = Encrypters.decode((String)password);
            MongoCredential credential = MongoCredential.createCredential((String)user, (String)"admin", (char[])password.toCharArray());
            return new MongoClient(new ServerAddress(ip, Integer.parseInt(port)), credential, MongoClientOptions.builder().build());
        }
        return new MongoClient(ip, Integer.parseInt(port));
    }

    protected String getDataBaseName() {
        String clusterName = this.insulateKey;
        return StringUtils.isEmpty((String)clusterName) ? "db_perf_gl" : clusterName;
    }

    @Override
    public void drop(String tableName) {
        try (MongoClient mongoClient = this.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(tableName);
            collection.drop();
        }
    }

    @Override
    public void delete(String table, String whereOndition) {
        StringBuilder oql = new StringBuilder("select * from ");
        oql.append(table);
        if (StringUtils.isNotEmpty((String)whereOndition)) {
            if (whereOndition.trim().toLowerCase(Locale.ENGLISH).startsWith("where")) {
                oql.append(" ").append(whereOndition);
            } else {
                oql.append(" where ").append(whereOndition);
            }
        }
        this.delete(oql.toString());
    }

    @Override
    public ResultSet query(String oql) {
        return this.query(Query.fromOQL(oql));
    }

    @Override
    public long count(String oql) {
        return this.count(Query.fromOQL(oql));
    }

    @Override
    public void delete(String oql) {
        this.deleteBySelect(Query.fromOQL(oql));
    }

    @Override
    public void createUniqueIndex(String tableName, String ... fields) {
        if (fields.length == 0) {
            return;
        }
        try (MongoClient mongoClient = this.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(tableName);
            BasicDBObject bcdb = new BasicDBObject();
            for (String filed : fields) {
                bcdb.append(filed, (Object)1);
            }
            IndexOptions indexOptions = new IndexOptions().unique(true);
            collection.createIndex((Bson)bcdb, indexOptions);
            this.logger.debug((Object)("create compoud index : " + bcdb + ",on table :" + tableName));
        }
    }
}

