/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nosql.operate;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.sql.parser.SqlParser;
import kd.bos.algo.sql.tree.AllColumns;
import kd.bos.algo.sql.tree.And;
import kd.bos.algo.sql.tree.Equal;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.GT;
import kd.bos.algo.sql.tree.GTE;
import kd.bos.algo.sql.tree.In;
import kd.bos.algo.sql.tree.LT;
import kd.bos.algo.sql.tree.LTE;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.algo.sql.tree.Not;
import kd.bos.algo.sql.tree.NotEqual;
import kd.bos.algo.sql.tree.Or;
import kd.bos.algo.sql.tree.OrderBy;
import kd.bos.algo.sql.tree.Query;
import kd.bos.algo.sql.tree.QueryBody;
import kd.bos.algo.sql.tree.QuerySpecification;
import kd.bos.algo.sql.tree.Relation;
import kd.bos.algo.sql.tree.SelectItem;
import kd.bos.algo.sql.tree.SingleColumn;
import kd.bos.algo.sql.tree.SortItem;
import kd.bos.algo.sql.tree.Statement;
import kd.bos.algo.sql.tree.Table;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.exception.KDException;
import kd.bos.nosql.exception.NosqlStorageErrorCode;
import kd.bos.nosql.operate.Filter;
import kd.bos.nosql.operate.Filters;
import kd.bos.nosql.operate.From;
import kd.bos.nosql.operate.Order;
import kd.bos.nosql.operate.Select;

public class OqlParse {
    private String oql;
    private Filter<?> fiter;
    private Select select;
    private From from;
    private Order order;

    public Filter<?> getFilter() {
        return this.fiter;
    }

    public Select getSelect() {
        return this.select;
    }

    public From getFrom() {
        return this.from;
    }

    public Order getOrder() {
        return this.order;
    }

    private OqlParse() {
    }

    public static OqlParse parse(String oql) {
        OqlParse par = new OqlParse();
        par.oql = oql;
        par._parse();
        return par;
    }

    private void _parse() {
        SqlParser paser = new SqlParser();
        Statement e = paser.parseStatement(this.oql);
        QueryBody body = ((Query)e).getQueryBody();
        QuerySpecification qs = (QuerySpecification)body;
        this.select = this.parseSelect(qs.getSelect());
        this.from = this.parseFrom((Relation)qs.getFrom().get());
        if (qs.getWhere().isPresent()) {
            this.fiter = OqlParse.parseWhere((Expr)qs.getWhere().get());
        }
        if (qs.getOrderBy().isPresent()) {
            this.order = this.parseOrder((OrderBy)qs.getOrderBy().get());
        }
        qs.getLimit();
    }

    private Select parseSelect(kd.bos.algo.sql.tree.Select select) {
        List ls = select.getSelectItems();
        Select s = new Select();
        for (SelectItem si : ls) {
            if (si instanceof SingleColumn) {
                Expr ex = (Expr)((SingleColumn)si).getChildren().get(0);
                ex.sql();
                s.append(ex.sql());
                continue;
            }
            if (si instanceof AllColumns) {
                return null;
            }
            throw new KDException(NosqlStorageErrorCode.unsupport, new Object[]{"unspport selectitem type:" + si.getClass().toString()});
        }
        return s;
    }

    private Order parseOrder(OrderBy orderBy) {
        Iterator itr = orderBy.getChildren().iterator();
        Order order = new Order();
        while (itr.hasNext()) {
            SortItem si = (SortItem)itr.next();
            SortItem.Ordering o = si.getOrdering();
            order.append(si.getSortKey().sql(), SortItem.Ordering.ASCENDING == o ? Order.Type.ASC : Order.Type.DESC);
        }
        return order;
    }

    private From parseFrom(Relation relation) {
        if (relation instanceof Table) {
            Table t = (Table)relation;
            String table = Joiner.on((char)'.').join((Iterable)t.getName().getOriginalParts());
            return new From(table);
        }
        throw new KDException(NosqlStorageErrorCode.unsupport, new Object[]{"unsupport from type: " + relation.getClass().toString()});
    }

    private static Filter<?> parseWhere(Expr ep) {
        if (ep instanceof And) {
            Iterator itr = ep.getChildren().iterator();
            Filter f1 = null;
            while (itr.hasNext()) {
                Expr t = (Expr)itr.next();
                if (f1 == null) {
                    f1 = OqlParse.parseWhere(t);
                    continue;
                }
                f1 = Filters.and(f1, OqlParse.parseWhere(t));
            }
            return f1;
        }
        if (ep instanceof Or) {
            Iterator itr = ep.getChildren().iterator();
            Filter f1 = null;
            while (itr.hasNext()) {
                Expr t = (Expr)itr.next();
                if (f1 == null) {
                    f1 = OqlParse.parseWhere(t);
                    continue;
                }
                f1 = Filters.or(f1, OqlParse.parseWhere(t));
            }
            return f1;
        }
        if (ep instanceof Equal) {
            P p = OqlParse.getPair(ep, false);
            return Filters.eq(p.filed, p.v);
        }
        if (ep instanceof NotEqual) {
            P p = OqlParse.getPair(ep, false);
            return Filters.neq(p.filed, p.v);
        }
        if (ep instanceof GT) {
            P p = OqlParse.getPair(ep, false);
            return Filters.gt(p.filed, p.v);
        }
        if (ep instanceof GTE) {
            P p = OqlParse.getPair(ep, false);
            return Filters.gte(p.filed, p.v);
        }
        if (ep instanceof LT) {
            P p = OqlParse.getPair(ep, false);
            return Filters.lt(p.filed, p.v);
        }
        if (ep instanceof LTE) {
            P p = OqlParse.getPair(ep, false);
            return Filters.lte(p.filed, p.v);
        }
        if (ep instanceof In) {
            P p = OqlParse.getPair(ep, true);
            return Filters.in(p.filed, (Object[])p.v);
        }
        if (ep instanceof Not) {
            if ((ep = ep.getChild(0)) instanceof In) {
                P p = OqlParse.getPair(ep, true);
                return Filters.nin(p.filed, (Object[])p.v);
            }
            throw new KDException(NosqlStorageErrorCode.unsupport, new Object[]{"unsupport: not " + ep.getClass().getName()});
        }
        throw new KDException(NosqlStorageErrorCode.unsupport, new Object[]{"unsupport:  " + ep.getClass().getName()});
    }

    private static P getPair(Expr ep, boolean isMult) {
        List chl = ep.getChildren();
        P p = new P();
        if (chl.get(0) instanceof UnresolvedAttribute) {
            UnresolvedAttribute att = (UnresolvedAttribute)chl.get(0);
            p.filed = (String)att.getNameParts().get(0);
        }
        if (!isMult) {
            if (chl.get(1) instanceof Literal) {
                Literal lit = (Literal)chl.get(1);
                p.v = lit.getValue();
            }
        } else {
            ArrayList<Object> l = new ArrayList<Object>();
            for (int i = 1; i < chl.size(); ++i) {
                if (!(chl.get(i) instanceof Literal)) {
                    throw new KDException(NosqlStorageErrorCode.unsupport, new Object[]{"unsupport: not pair " + ((Expr)chl.get(i)).getClass().getName()});
                }
                Literal lit = (Literal)chl.get(i);
                l.add(lit.getValue());
            }
            p.v = l.toArray();
        }
        return p;
    }

    static class P {
        private String filed;
        private Object v;

        P() {
        }
    }
}

