/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.parse;

import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.config.ConfigHandlerHolder;
import com.tongweb.starter.parse.utils.MapBeanUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class ConfigProcessor {
    private static final Log log = LogFactory.getLog(ConfigProcessor.class);
    private String fileName;
    private ServletContainer tongweb;
    private TongWebProperties tongWebProperties;

    public ConfigProcessor() {
    }

    public ConfigProcessor(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void processConfig() throws IOException {
        TongWebProperties tongWebProperties = this.processEnvConfig();
        this.printResult(tongWebProperties);
        this.tongWebProperties = tongWebProperties;
    }

    private TongWebProperties processEnvConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, value) -> {
            String key = (String)k;
            if (key.startsWith("tongwebTag.")) {
                map.put(key.substring("tongwebTag.".length()), value);
            }
        }));
        return this.transFormFromHashMap(map);
    }

    private TongWebProperties transFormFromHashMap(Map<String, Object> origin) {
        HashMap<String, Object> removeFirstPrefixMap = new HashMap<String, Object>();
        HashMap camelCaseMap = new HashMap();
        origin.forEach((k, v) -> removeFirstPrefixMap.put(MapBeanUtil.removeFirstPrefix((String)k), v));
        removeFirstPrefixMap.forEach((k, v) -> camelCaseMap.put(MapBeanUtil.middleLineToCamel((String)k), v));
        try {
            TongWebProperties tongWebProperties = (TongWebProperties)MapBeanUtil.mapToBean(camelCaseMap, TongWebProperties.class);
            return tongWebProperties;
        }
        catch (Exception var5) {
            throw new RuntimeException(var5);
        }
    }

    private void printResult(TongWebProperties tongWebProperties) {
    }

    public void configComponents() throws Exception {
        ConfigHandlerHolder.configComponents((TongWebProperties)this.tongWebProperties, (ServletContainer)this.tongweb);
    }

    public void addShutdownListener() {
    }

    public void setTongweb(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }
}

