/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.websocket.server;

import com.tongweb.web.util.codec.binary.Base64;
import com.tongweb.web.util.res.StringManager;
import com.tongweb.web.util.security.ConcurrentMessageDigest;
import com.tongweb.web.websocket.Constants;
import com.tongweb.web.websocket.Transformation;
import com.tongweb.web.websocket.TransformationFactory;
import com.tongweb.web.websocket.Util;
import com.tongweb.web.websocket.WsHandshakeResponse;
import com.tongweb.web.websocket.pojo.PojoMethodMapping;
import com.tongweb.web.websocket.server.WsHandshakeRequest;
import com.tongweb.web.websocket.server.WsHttpUpgradeHandler;
import com.tongweb.web.websocket.server.WsPerSessionServerEndpointConfig;
import com.tongweb.web.websocket.server.WsServerContainer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;

public class UpgradeUtil {
    private static final StringManager sm = StringManager.getManager((String)UpgradeUtil.class.getPackage().getName());
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.ISO_8859_1);

    private UpgradeUtil() {
    }

    public static boolean isWebSocketUpgradeRequest(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && response instanceof HttpServletResponse && UpgradeUtil.headerContainsToken((HttpServletRequest)request, "Upgrade", "websocket") && "GET".equals(((HttpServletRequest)request).getMethod());
    }

    public static void doUpgrade(WsServerContainer sc, HttpServletRequest req, HttpServletResponse resp, ServerEndpointConfig sec, Map<String, String> pathParams) throws ServletException, IOException {
        String subProtocol = null;
        if (!UpgradeUtil.headerContainsToken(req, "Connection", "upgrade")) {
            resp.sendError(400);
        } else if (!UpgradeUtil.headerContainsToken(req, "Sec-WebSocket-Version", "13")) {
            resp.setStatus(426);
            resp.setHeader("Sec-WebSocket-Version", "13");
        } else {
            String key = req.getHeader("Sec-WebSocket-Key");
            if (key == null) {
                resp.sendError(400);
            } else {
                String origin = req.getHeader("Origin");
                if (!sec.getConfigurator().checkOrigin(origin)) {
                    resp.sendError(403);
                } else {
                    List<Extension> negotiatedExtensionsPhase2;
                    List<String> subProtocols = UpgradeUtil.getTokensFromHeader(req, "Sec-WebSocket-Protocol");
                    subProtocol = sec.getConfigurator().getNegotiatedSubprotocol(sec.getSubprotocols(), subProtocols);
                    ArrayList extensionsRequested = new ArrayList();
                    Enumeration extHeaders = req.getHeaders("Sec-WebSocket-Extensions");
                    while (extHeaders.hasMoreElements()) {
                        Util.parseExtensionHeader(extensionsRequested, (String)((String)extHeaders.nextElement()));
                    }
                    ArrayList installedExtensions = null;
                    if (sec.getExtensions().size() == 0) {
                        installedExtensions = Constants.INSTALLED_EXTENSIONS;
                    } else {
                        installedExtensions = new ArrayList();
                        installedExtensions.addAll(sec.getExtensions());
                        installedExtensions.addAll(Constants.INSTALLED_EXTENSIONS);
                    }
                    List negotiatedExtensionsPhase1 = sec.getConfigurator().getNegotiatedExtensions(installedExtensions, extensionsRequested);
                    List<Transformation> transformations = UpgradeUtil.createTransformations(negotiatedExtensionsPhase1);
                    if (transformations.isEmpty()) {
                        negotiatedExtensionsPhase2 = Collections.emptyList();
                    } else {
                        negotiatedExtensionsPhase2 = new ArrayList(transformations.size());
                        for (Transformation t : transformations) {
                            negotiatedExtensionsPhase2.add(t.getExtensionResponse());
                        }
                    }
                    Transformation transformation = null;
                    StringBuilder responseHeaderExtensions = new StringBuilder();
                    boolean first = true;
                    for (Transformation t : transformations) {
                        if (first) {
                            first = false;
                        } else {
                            responseHeaderExtensions.append(',');
                        }
                        UpgradeUtil.append(responseHeaderExtensions, t.getExtensionResponse());
                        if (transformation == null) {
                            transformation = t;
                            continue;
                        }
                        transformation.setNext(t);
                    }
                    if (transformation != null && !transformation.validateRsvBits(0)) {
                        throw new ServletException(sm.getString("upgradeUtil.incompatibleRsv"));
                    }
                    resp.setHeader("Upgrade", "websocket");
                    resp.setHeader("Connection", "upgrade");
                    resp.setHeader("Sec-WebSocket-Accept", UpgradeUtil.getWebSocketAccept(key));
                    if (subProtocol != null && subProtocol.length() > 0) {
                        resp.setHeader("Sec-WebSocket-Protocol", subProtocol);
                    }
                    if (!transformations.isEmpty()) {
                        resp.setHeader("Sec-WebSocket-Extensions", responseHeaderExtensions.toString());
                    }
                    if (!Endpoint.class.isAssignableFrom(sec.getEndpointClass()) && sec.getUserProperties().get("com.tongweb.web.websocket.pojo.PojoEndpoint.methodMapping") == null) {
                        try {
                            PojoMethodMapping methodMapping = new PojoMethodMapping(sec.getEndpointClass(), sec.getDecoders(), sec.getPath(), sc.getInstanceManager(Thread.currentThread().getContextClassLoader()));
                            if (methodMapping.getOnClose() != null || methodMapping.getOnOpen() != null || methodMapping.getOnError() != null || methodMapping.hasMessageHandlers()) {
                                sec.getUserProperties().put("com.tongweb.web.websocket.pojo.PojoEndpoint.methodMapping", methodMapping);
                            }
                        }
                        catch (DeploymentException var25) {
                            throw new ServletException(sm.getString("upgradeUtil.pojoMapFail", new Object[]{sec.getEndpointClass().getName()}), (Throwable)var25);
                        }
                    }
                    WsPerSessionServerEndpointConfig perSessionServerEndpointConfig = new WsPerSessionServerEndpointConfig(sec);
                    WsHandshakeRequest wsRequest = new WsHandshakeRequest(req, pathParams);
                    WsHandshakeResponse wsResponse = new WsHandshakeResponse();
                    sec.getConfigurator().modifyHandshake((ServerEndpointConfig)perSessionServerEndpointConfig, (HandshakeRequest)wsRequest, (HandshakeResponse)wsResponse);
                    wsRequest.finished();
                    for (Map.Entry entry : wsResponse.getHeaders().entrySet()) {
                        for (String headerValue : (List)entry.getValue()) {
                            resp.addHeader((String)entry.getKey(), headerValue);
                        }
                    }
                    WsHttpUpgradeHandler wsHandler = (WsHttpUpgradeHandler)req.upgrade(WsHttpUpgradeHandler.class);
                    wsHandler.preInit((ServerEndpointConfig)perSessionServerEndpointConfig, sc, wsRequest, negotiatedExtensionsPhase2, subProtocol, transformation, pathParams, req.isSecure());
                }
            }
        }
    }

    private static List<Transformation> createTransformations(List<Extension> negotiatedExtensions) {
        TransformationFactory factory = TransformationFactory.getInstance();
        LinkedHashMap<String, List> extensionPreferences = new LinkedHashMap<String, List>();
        ArrayList<Transformation> result = new ArrayList<Transformation>(negotiatedExtensions.size());
        for (Extension extension : negotiatedExtensions) {
            extensionPreferences.computeIfAbsent(extension.getName(), k -> new ArrayList()).add(extension.getParameters());
        }
        for (Map.Entry entry : extensionPreferences.entrySet()) {
            Transformation transformation = factory.create((String)entry.getKey(), (List)entry.getValue(), true);
            if (transformation == null) continue;
            result.add(transformation);
        }
        return result;
    }

    private static void append(StringBuilder sb, Extension extension) {
        if (extension != null && extension.getName() != null && extension.getName().length() != 0) {
            sb.append(extension.getName());
            for (Extension.Parameter p : extension.getParameters()) {
                sb.append(';');
                sb.append(p.getName());
                if (p.getValue() == null) continue;
                sb.append('=');
                sb.append(p.getValue());
            }
        }
    }

    private static boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            String[] var6 = tokens = header.split(",");
            int var7 = tokens.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                String token = var6[var8];
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            String[] var6 = tokens = header.split(",");
            int var7 = tokens.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                String token = var6[var8];
                result.add(token.trim());
            }
        }
        return result;
    }

    private static String getWebSocketAccept(String key) {
        byte[] digest = ConcurrentMessageDigest.digestSHA1((byte[][])new byte[][]{key.getBytes(StandardCharsets.ISO_8859_1), WS_ACCEPT});
        return Base64.encodeBase64String((byte[])digest);
    }
}

