/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.websocket.server;

import com.tongweb.connector.http11.upgrade.UpgradeInfo;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.net.SocketWrapperBase;
import com.tongweb.web.util.res.StringManager;
import com.tongweb.web.websocket.Transformation;
import com.tongweb.web.websocket.WsRemoteEndpointImplBase;
import com.tongweb.web.websocket.server.WsServerContainer;
import com.tongweb.web.websocket.server.WsWriteTimeout;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;

public class WsRemoteEndpointImplServer
extends WsRemoteEndpointImplBase {
    private static final StringManager sm = StringManager.getManager(WsRemoteEndpointImplServer.class);
    private final Log log = LogFactory.getLog(WsRemoteEndpointImplServer.class);
    private final SocketWrapperBase<?> socketWrapper;
    private final UpgradeInfo upgradeInfo;
    private final WsWriteTimeout wsWriteTimeout;
    private volatile SendHandler handler = null;
    private volatile ByteBuffer[] buffers = null;
    private volatile long timeoutExpiry = -1L;

    public WsRemoteEndpointImplServer(SocketWrapperBase<?> socketWrapper, UpgradeInfo upgradeInfo, WsServerContainer serverContainer) {
        this.socketWrapper = socketWrapper;
        this.upgradeInfo = upgradeInfo;
        this.wsWriteTimeout = serverContainer.getTimeout();
    }

    protected final boolean isMasked() {
        return false;
    }

    protected void doWrite(final SendHandler handler, final long blockingWriteTimeoutExpiry, ByteBuffer ... buffers) {
        if (this.socketWrapper.hasAsyncIO()) {
            final boolean block = blockingWriteTimeoutExpiry != -1L;
            long timeout = -1L;
            if (block) {
                timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                if (timeout <= 0L) {
                    SendResult sr = new SendResult((Throwable)new SocketTimeoutException());
                    handler.onResult(sr);
                    return;
                }
            } else {
                this.handler = handler;
                timeout = this.getSendTimeout();
                if (timeout > 0L) {
                    this.timeoutExpiry = timeout + System.currentTimeMillis();
                    this.wsWriteTimeout.register(this);
                }
            }
            this.socketWrapper.write(block ? SocketWrapperBase.BlockingMode.BLOCK : SocketWrapperBase.BlockingMode.SEMI_BLOCK, timeout, TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE_WITH_COMPLETION, (CompletionHandler)new CompletionHandler<Long, Object>(){

                @Override
                public void completed(Long result, Object attachment) {
                    if (block) {
                        long timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                        if (timeout <= 0L) {
                            this.failed((Throwable)new SocketTimeoutException(), (Object)null);
                        } else {
                            handler.onResult(SENDRESULT_OK);
                        }
                    } else {
                        WsRemoteEndpointImplServer.this.wsWriteTimeout.unregister(WsRemoteEndpointImplServer.this);
                        WsRemoteEndpointImplServer.this.clearHandler(null, true);
                    }
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    if (block) {
                        SendResult sr = new SendResult(exc);
                        handler.onResult(sr);
                    } else {
                        WsRemoteEndpointImplServer.this.wsWriteTimeout.unregister(WsRemoteEndpointImplServer.this);
                        WsRemoteEndpointImplServer.this.clearHandler(exc, true);
                        WsRemoteEndpointImplServer.this.close();
                    }
                }
            }, buffers);
        } else if (blockingWriteTimeoutExpiry == -1L) {
            this.handler = handler;
            this.buffers = buffers;
            this.onWritePossible(true);
        } else {
            try {
                ByteBuffer[] var13 = buffers;
                int var16 = buffers.length;
                for (int var7 = 0; var7 < var16; ++var7) {
                    ByteBuffer buffer = var13[var7];
                    long timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                    if (timeout <= 0L) {
                        SendResult sr = new SendResult((Throwable)new SocketTimeoutException());
                        handler.onResult(sr);
                        return;
                    }
                    this.socketWrapper.setWriteTimeout(timeout);
                    this.socketWrapper.write(true, buffer);
                }
                long timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                if (timeout <= 0L) {
                    SendResult sr = new SendResult((Throwable)new SocketTimeoutException());
                    handler.onResult(sr);
                    return;
                }
                this.socketWrapper.setWriteTimeout(timeout);
                this.socketWrapper.flush(true);
                handler.onResult(SENDRESULT_OK);
            }
            catch (IOException var12) {
                SendResult sr = new SendResult((Throwable)var12);
                handler.onResult(sr);
            }
        }
    }

    protected void updateStats(long payloadLength) {
        this.upgradeInfo.addMsgsSent(1L);
        this.upgradeInfo.addBytesSent(payloadLength);
    }

    public void onWritePossible(boolean useDispatch) {
        ByteBuffer[] buffers = this.buffers;
        if (buffers != null) {
            long timeout;
            boolean complete = false;
            try {
                this.socketWrapper.flush(false);
                while (this.socketWrapper.isReadyForWrite()) {
                    complete = true;
                    ByteBuffer[] var4 = buffers;
                    int var5 = buffers.length;
                    for (int var6 = 0; var6 < var5; ++var6) {
                        ByteBuffer buffer = var4[var6];
                        if (!buffer.hasRemaining()) continue;
                        complete = false;
                        this.socketWrapper.write(false, buffer);
                        break;
                    }
                    if (!complete) continue;
                    this.socketWrapper.flush(false);
                    complete = this.socketWrapper.isReadyForWrite();
                    if (complete) {
                        this.wsWriteTimeout.unregister(this);
                        this.clearHandler(null, useDispatch);
                    }
                    break;
                }
            }
            catch (IOException | IllegalStateException var8) {
                this.wsWriteTimeout.unregister(this);
                this.clearHandler(var8, useDispatch);
                this.close();
            }
            if (!complete && (timeout = this.getSendTimeout()) > 0L) {
                this.timeoutExpiry = timeout + System.currentTimeMillis();
                this.wsWriteTimeout.register(this);
            }
        }
    }

    protected void doClose() {
        block3: {
            if (this.handler != null) {
                this.clearHandler(new EOFException(), true);
            }
            try {
                this.socketWrapper.close();
            }
            catch (Exception var2) {
                if (!this.log.isInfoEnabled()) break block3;
                this.log.info((Object)sm.getString("wsRemoteEndpointServer.closeFailed"), (Throwable)var2);
            }
        }
        this.wsWriteTimeout.unregister(this);
    }

    protected long getTimeoutExpiry() {
        return this.timeoutExpiry;
    }

    protected void onTimeout(boolean useDispatch) {
        if (this.handler != null) {
            this.clearHandler(new SocketTimeoutException(), useDispatch);
        }
        this.close();
    }

    public void setTransformation(Transformation transformation) {
        super.setTransformation(transformation);
    }

    private void clearHandler(Throwable t, boolean useDispatch) {
        SendHandler sh = this.handler;
        this.handler = null;
        this.buffers = null;
        if (sh != null) {
            if (useDispatch) {
                OnResultRunnable r = new OnResultRunnable(sh, t);
                try {
                    this.socketWrapper.execute((Runnable)r);
                }
                catch (RejectedExecutionException var6) {
                    r.run();
                }
            } else if (t == null) {
                sh.onResult(new SendResult());
            } else {
                sh.onResult(new SendResult(t));
            }
        }
    }

    private static class OnResultRunnable
    implements Runnable {
        private final SendHandler sh;
        private final Throwable t;

        private OnResultRunnable(SendHandler sh, Throwable t) {
            this.sh = sh;
            this.t = t;
        }

        @Override
        public void run() {
            if (this.t == null) {
                this.sh.onResult(new SendResult());
            } else {
                this.sh.onResult(new SendResult(this.t));
            }
        }
    }
}

