/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.locks.LockSupport;
import kd.bos.config.client.ConfigUrlType;
import kd.bos.config.client.util.ConfigUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.framework.lifecycle.services.ConfigurationService;
import kd.bos.instance.Instance;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.config.MserviceConfigUtil;
import kd.bos.nacos.NacosFactory;
import kd.bos.security.KDSecurityManager;
import kd.bos.service.bootstrap.BootServer;
import kd.bos.service.bootstrap.JvmDefaultPropertyInit;
import kd.bos.service.lightweight.LightService;
import kd.bos.service.mcserverhandler.MCServerHandler;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import org.apache.log4j.Logger;

public class Booter {
    private static final String KEY_SPRINGBOOTERSERVER_CLASS = "kd.bos.service.bootstrap.springboot.SpringbootServer";
    private static ExtensionFactory<BootServer> BootServerFactory = ExtensionFactory.getExtensionFacotry(BootServer.class);
    private static Logger logger;

    public static void main(String[] args) {
        try {
            Class.forName("java.sql.DriverManager");
        }
        catch (Exception e) {
            Booter.getLogger().error((Object)("Class forName java.sql.DriverManager error: " + e.getMessage() + ", Execute System.exit(-1), Starting to exit the service"), (Throwable)e);
            e.printStackTrace();
            LockSupport.parkNanos(1000000000L);
            System.exit(-1);
        }
        try {
            JvmDefaultPropertyInit.init();
            Booter.startLightweightService();
            MCServerHandler.handleMCLogin();
            ConfigurationService service = new ConfigurationService();
            service.start();
            BootServer server = Booter.getBootServer();
            if (args == null) {
                args = new String[]{};
            }
            server.start(args);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            throw new KDException(e, BosErrorCode.bOS, new Object[]{"Booter.start  error:" + e.getMessage()});
        }
    }

    private static void startLightweightService() {
        if (Instance.isLightWeightDeploy()) {
            String[] serviceNames;
            HashSet<String> services = new HashSet<String>(8);
            String serviceNameConfig = SystemProperties.getWithEnv((String)"lightweightdeploy.services", (String)"zookeeper");
            for (String serviceName : serviceNames = serviceNameConfig.split(",")) {
                services.add(serviceName);
            }
            ArrayList<LightService> lightServices = new ArrayList<LightService>(services.size());
            ServiceLoader<LightService> loads = ServiceLoader.load(LightService.class);
            for (LightService lightService : loads) {
                lightServices.add(lightService);
            }
            Collections.sort(lightServices, Comparator.comparingInt(LightService::getOrder));
            for (LightService lightService : lightServices) {
                try {
                    if (!services.contains(lightService.getName())) continue;
                    lightService.start();
                }
                catch (Exception e) {
                    Booter.getLogger().error((Object)(lightService.getName() + " lightService start error"), (Throwable)e);
                }
            }
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(Booter.class);
        }
        return logger;
    }

    private static BootServer getBootServer() {
        String bootType = MserviceAssemblyConfig.MSERVICE_BOOTER_TYPE;
        if ("springboot".equals(bootType)) {
            try {
                return (BootServer)Class.forName(KEY_SPRINGBOOTERSERVER_CLASS).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new Error("Can't init springboot:" + e.getMessage(), e);
            }
        }
        Booter.initProperties();
        return (BootServer)BootServerFactory.getExtension(System.getProperty("webserver.type", "jetty"));
    }

    private static void initProperties() {
        String discoveryType;
        String rpctype = MserviceAssemblyConfig.MSERVICE_RPC_TYPE;
        if ("feign".equals(rpctype)) {
            MserviceAssemblyConfig.MSERVICE_RPC_TYPE = "dubbo";
        }
        if ("nacos".equals(discoveryType = MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE)) {
            System.setProperty("dubbo.registry.protocol", "nacos");
            String nacosUrl = MserviceConfigUtil.getRegisterUrlByType((String)discoveryType);
            if (!StringUtils.isEmpty((String)nacosUrl)) {
                System.setProperty("dubbo.registry.address", nacosUrl);
            } else if (ConfigUrlType.nacos.name().equals(ConfigUtils.getConfigUrlType())) {
                Properties properties = NacosFactory.getNacosProperties((String)System.getProperty("configUrl"));
                System.setProperty("dubbo.registry.address", properties.getProperty("serverAddr"));
                System.setProperty("nacos.registry.address", properties.getProperty("serverAddr"));
                Object nacosUser = properties.get("username");
                Object nacosPwd = properties.get("password");
                Object nacosNamespace = properties.get("namespace");
                if (nacosUser != null && nacosPwd != null) {
                    System.setProperty("nacos.registry.username", String.valueOf(nacosUser));
                    System.setProperty("nacos.registry.password", String.valueOf(nacosPwd));
                }
                if (nacosNamespace != null) {
                    System.setProperty("nacos.registry.namespace", String.valueOf(nacosNamespace));
                }
            }
        } else {
            String address = System.getProperty("dubbo.registry.address");
            if (address == null) {
                address = MserviceConfigUtil.getRegisterUrlByType((String)discoveryType);
                if (address == null) {
                    address = System.getProperty("configUrl");
                }
                System.setProperty("dubbo.registry.address", address);
            }
        }
    }

    static {
        KDSecurityManager.initialize();
    }
}

