/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.embedaas;

import com.apusic.aas.JarScanFilter;
import com.apusic.aas.util.descriptor.web.FilterDef;
import com.apusic.aas.util.descriptor.web.FilterMap;
import com.apusic.aas.util.scan.StandardJarScanFilter;
import com.apusic.aas.util.scan.StandardJarScanner;
import com.apusic.ams.Container;
import com.apusic.ams.Context;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.Valve;
import com.apusic.ams.Wrapper;
import com.apusic.ams.connector.Connector;
import com.apusic.ams.core.StandardContext;
import com.apusic.ams.startup.Aas;
import com.apusic.ams.startup.ContextConfig;
import com.apusic.ams.valves.ErrorReportValve;
import com.apusic.connector.AbstractProtocol;
import com.apusic.connector.ProtocolHandler;
import com.apusic.connector.http11.AbstractHttp11Protocol;
import java.io.IOException;
import javax.servlet.Filter;
import kd.bos.eye.httpserver.EyeInstaller;
import kd.bos.framework.filter.EncodingFilter;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.service.bootstrap.BootServer;
import kd.bos.service.web.WebResourceUtils;
import kd.bos.util.WebPortUtil;

public class EmbedAasServer
implements BootServer {
    public static final String SERVER_CONNECTION_TIMEOUT = "server.connection-timeout";
    public static final String SERVER_MAX_HTTP_HEADER_SIZE = "server.max-http-header-size";
    public static final String SERVER_AAS_MAX_THREADS = "server.aas.max-threads";
    public static final String SERVER_AAS_MIN_SPARE_THREADS = "server.aas.min-spare-threads";
    public static final String SERVER_AAS_MAX_HTTP_POST_SIZE = "server.aas.max-http-post-size";
    public static final String SERVER_AAS_MAX_CONNECTIONS = "server.aas.max-connections";
    public static final String SERVER_AAS_ACCEPT_COUNT = "server.aas.accept-count";
    public static final String SERVER_AAS_MAX_SWALLOW_SIZE = "server.aas.max-swallow-size";
    public static final String SERVER_AAS_COMPRESSION = "server.aas.compression";
    public static final String SERVER_AAS_COMPRESSION_MIN_SIZE = "server.aas.compression-min-size";
    public static final String SERVER_AAS_COMPRESSABLE_MIME_TYPE = "server.aas.compressable-mime-type";
    public static final String SERVER_AAS_MAX_KEEP_ALIVE_TIMEOUT = "server.aas.max-keep-alive-timeout";
    public static final String SERVER_AAS_MAX_KEEP_ALIVE_REQUESTS = "server.aas.max-keep-alive-requests";
    public static final String SERVER_AAS_DISABLE_UPLOAD_IMEOUT = "server.aas.disable-upload-timeout";

    private static void initWebappDefaults(Aas aas, Context context) {
        Wrapper servlet = Aas.addServlet((Context)context, (String)"default", (String)"com.apusic.ams.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        context.addServletMappingDecoded("/", "default");
        context.setSessionTimeout(30);
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public void start(String[] args) {
        try {
            Valve[] valveArray;
            String webport = WebPortUtil.getWebPort((String)null);
            if (webport == null) {
                String value = EmbedAasServer.getProperty("JETTY_PORT", "8080");
                WebPortUtil.setWebPort((String)value);
                webport = value;
            }
            int port = Integer.parseInt(webport);
            String contextPath = EmbedAasServer.getProperty("JETTY_CONTEXT", "/ierp");
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            String webappPath = EmbedAasServer.getProperty("JETTY_WEBAPP_PATH", "webapp");
            Aas aas = new Aas();
            aas.getHost().setAutoDeploy(false);
            aas.setAddDefaultWebXmlToWebapp(false);
            ContextConfig contextConfig = new ContextConfig();
            String source = EmbedAasServer.getProperty("JETTY_WEBXML_PATH", EmbedAasServer.class.getClassLoader().getResource(WebResourceUtils.getWebReousrceXmlPath()).getPath());
            if (source.indexOf("target/classes") > 0) {
                contextConfig.setDefaultWebXml("file:" + source);
            } else {
                contextConfig.setDefaultWebXml("jar:" + source);
            }
            Context ierpContext = aas.addWebapp(aas.getHost(), contextPath, webappPath, (LifecycleListener)contextConfig);
            StandardJarScanner jarScanner = (StandardJarScanner)ierpContext.getJarScanner();
            String containerSciFilter = "org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer|org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer|org.apache.tomcat.websocket.server.WsSci|com.bes.enterprise.web.websocket.server.WsSci|com.tongweb.web.websocket.server.WsSci|com.bes.enterprise.web.jasper.servlet.JasperInitializer";
            ierpContext.setContainerSciFilter(containerSciFilter);
            ierpContext.setParentClassLoader(EmbedAasServer.class.getClassLoader());
            jarScanner.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

                public boolean isSkipAll() {
                    return true;
                }
            });
            ierpContext.addApplicationListener("kd.bos.msgjet.websocket.tomcat.TomcatWsContextListener");
            this.addEncodingFilter(ierpContext);
            EmbedAasServer.initWebappDefaults(aas, ierpContext);
            this.monitorInstall(ierpContext);
            MonitorInstaller.installIerp((Object)ierpContext);
            EyeInstaller.installIerp((Object)ierpContext);
            StandardContext monitorContext = new StandardContext();
            monitorContext.setPath("");
            StandardJarScanner scanner = (StandardJarScanner)monitorContext.getJarScanner();
            scanner.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

                public boolean isSkipAll() {
                    return true;
                }
            });
            monitorContext.setContainerSciFilter(containerSciFilter);
            monitorContext.addLifecycleListener((LifecycleListener)new Aas.FixContextListener());
            aas.getHost().addChild((Container)monitorContext);
            this.monitorInstall((Context)monitorContext);
            Connector connector = new Connector();
            connector.setPort(port);
            this.configConenctor(connector);
            aas.setConnector(connector);
            aas.start();
            for (Valve tempValve : valveArray = aas.getHost().getPipeline().getValves()) {
                String simpleName = tempValve.getClass().getSimpleName();
                if (!simpleName.equals("ErrorReportValve")) continue;
                ErrorReportValve errorReportValve = (ErrorReportValve)tempValve;
                errorReportValve.setShowServerInfo(false);
                break;
            }
        }
        catch (LifecycleException | IOException var13) {
            throw new Error("EmbedAasServer start exception:" + var13.getMessage(), var13);
        }
    }

    private void configConenctor(Connector connector) {
        AbstractProtocol protocol;
        ProtocolHandler handler = connector.getProtocolHandler();
        String _connectionTimeout = System.getProperty(SERVER_CONNECTION_TIMEOUT, System.getenv(SERVER_CONNECTION_TIMEOUT));
        String _maxHttpHeaderSize = System.getProperty(SERVER_MAX_HTTP_HEADER_SIZE, System.getenv(SERVER_MAX_HTTP_HEADER_SIZE));
        String _maxThreads = System.getProperty(SERVER_AAS_MAX_THREADS, System.getenv(SERVER_AAS_MAX_THREADS));
        String _minSpareThreads = System.getProperty(SERVER_AAS_MIN_SPARE_THREADS, System.getenv(SERVER_AAS_MIN_SPARE_THREADS));
        String _maxHttpPostSize = System.getProperty(SERVER_AAS_MAX_HTTP_POST_SIZE, System.getenv(SERVER_AAS_MAX_HTTP_POST_SIZE));
        String _maxConnections = System.getProperty(SERVER_AAS_MAX_CONNECTIONS, System.getenv(SERVER_AAS_MAX_CONNECTIONS));
        String _acceptCount = System.getProperty(SERVER_AAS_ACCEPT_COUNT, System.getenv(SERVER_AAS_ACCEPT_COUNT));
        String _maxSwallowSize = System.getProperty(SERVER_AAS_MAX_SWALLOW_SIZE, System.getenv(SERVER_AAS_MAX_SWALLOW_SIZE));
        String _compression = System.getProperty(SERVER_AAS_COMPRESSION, System.getenv(SERVER_AAS_COMPRESSION));
        String _compressionMinSize = System.getProperty(SERVER_AAS_COMPRESSION_MIN_SIZE, System.getenv(SERVER_AAS_COMPRESSION_MIN_SIZE));
        String _compressableMimeType = System.getProperty(SERVER_AAS_COMPRESSABLE_MIME_TYPE, System.getenv(SERVER_AAS_COMPRESSABLE_MIME_TYPE));
        String _maxKeepAliveTimeout = System.getProperty(SERVER_AAS_MAX_KEEP_ALIVE_TIMEOUT, System.getenv(SERVER_AAS_MAX_KEEP_ALIVE_TIMEOUT));
        String _maxKeepAliveRequests = System.getProperty(SERVER_AAS_MAX_KEEP_ALIVE_REQUESTS, System.getenv(SERVER_AAS_MAX_KEEP_ALIVE_REQUESTS));
        String _disableUploadTimeout = System.getProperty(SERVER_AAS_DISABLE_UPLOAD_IMEOUT, System.getenv(SERVER_AAS_DISABLE_UPLOAD_IMEOUT));
        if (_connectionTimeout != null && _connectionTimeout.length() > 0 && handler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)handler;
            protocol.setConnectionTimeout(Integer.parseInt(_connectionTimeout));
        }
        if (_maxHttpHeaderSize != null && _maxHttpHeaderSize.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxHttpHeaderSize(Integer.parseInt(_maxHttpHeaderSize));
        }
        if (_maxThreads != null && _maxThreads.length() > 0 && handler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)handler;
            protocol.setMaxThreads(Integer.parseInt(_maxThreads));
        }
        if (_minSpareThreads != null && _minSpareThreads.length() > 0 && handler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)handler;
            protocol.setMinSpareThreads(Integer.parseInt(_minSpareThreads));
        }
        if (_maxHttpPostSize != null && _maxHttpPostSize.length() > 0) {
            connector.setMaxPostSize(Integer.parseInt(_maxHttpPostSize));
        } else {
            connector.setMaxPostSize(200000000);
        }
        if (_maxConnections != null && _maxConnections.length() > 0 && handler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)handler;
            protocol.setMaxConnections(Integer.parseInt(_maxConnections));
        }
        if (_acceptCount != null && _acceptCount.length() > 0 && handler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)handler;
            protocol.setAcceptCount(Integer.parseInt(_acceptCount));
        }
        if (_maxSwallowSize != null && _maxSwallowSize.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxSwallowSize(Integer.parseInt(_maxSwallowSize));
        }
        if (_compression != null && _compression.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setCompression(_compression);
        }
        if (_compressionMinSize != null && _compressionMinSize.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setCompressionMinSize(Integer.parseInt(_compressionMinSize));
        }
        if (_compressableMimeType != null && _compressableMimeType.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setCompressibleMimeType(_compressableMimeType);
        }
        if (_maxKeepAliveTimeout != null && _maxKeepAliveTimeout.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setKeepAliveTimeout(Integer.parseInt(_maxKeepAliveTimeout));
        }
        if (_maxKeepAliveRequests != null && _maxKeepAliveRequests.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxKeepAliveRequests(Integer.parseInt(_maxKeepAliveRequests));
        }
        if (_disableUploadTimeout != null && _disableUploadTimeout.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setDisableUploadTimeout(Boolean.parseBoolean(_disableUploadTimeout));
        }
    }

    private void monitorInstall(Context context) {
        try {
            MonitorInstaller.install((Object)context);
            EyeInstaller.install((Object)context);
        }
        catch (IOException var3) {
            throw new Error("EmbedAasServer monitorInstall IOException:" + var3.getMessage(), var3);
        }
    }

    private void addEncodingFilter(Context context) {
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName("encodingFilter");
        filterDef.setFilter((Filter)new EncodingFilter());
        filterDef.setFilterClass(EncodingFilter.class.getName());
        context.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName("encodingFilter");
        filterMap.addURLPattern("*");
        context.addFilterMap(filterMap);
    }
}

