/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.embedbes;

import com.bes.enterprise.web.BESConnector;
import com.bes.enterprise.web.util.descriptor.web.FilterDef;
import com.bes.enterprise.web.util.descriptor.web.FilterMap;
import com.bes.enterprise.web.util.scan.StandardJarScanner;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.startup.BESCore;
import com.bes.enterprise.webtier.startup.ContextConfig;
import com.bes.enterprise.webtier.valves.ErrorReportValve;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.servlet.Filter;
import kd.bos.eye.httpserver.EyeInstaller;
import kd.bos.framework.filter.EncodingFilter;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.service.bootstrap.BootServer;
import kd.bos.service.web.WebResourceUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.WebPortUtil;
import org.apache.commons.io.IOUtils;

public class EmbedBesServer
implements BootServer {
    @Override
    public void start(String[] args) throws Exception {
        Valve[] valveArray;
        String webport = WebPortUtil.getWebPort(null);
        if (webport == null) {
            String value = EmbedBesServer.getProperty("JETTY_PORT", "8080");
            WebPortUtil.setWebPort((String)value);
            webport = value;
        }
        int port = Integer.parseInt(webport);
        String contextPath = EmbedBesServer.getProperty("JETTY_CONTEXT", "/ierp");
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        String webappPath = System.getProperty("bes.webapp.path", "/mservice/webapp");
        if (this.isWindows()) {
            webappPath = EmbedBesServer.getProperty("JETTY_WEBAPP_PATH", "webapp");
        }
        BESCore besCore = new BESCore();
        besCore.getHost().setAutoDeploy(false);
        ContextConfig contextConfig = new ContextConfig();
        Context ierpContext = besCore.addWebapp(besCore.getHost(), contextPath, webappPath, contextConfig);
        StandardJarScanner jarScanner = (StandardJarScanner)ierpContext.getJarScanner();
        jarScanner.setScanManifest(false);
        String webXmlPath = EmbedBesServer.getProperty("JETTY_WEBXML_PATH", EmbedBesServer.class.getClassLoader().getResource(WebResourceUtils.getWebReousrceXmlPath()).getPath());
        String jarSource = webXmlPath.indexOf("target/classes") > 0 ? "file:" + webXmlPath : "jar:" + webXmlPath;
        String tarXmlPath = "";
        if (this.isWindows()) {
            tarXmlPath = EmbedBesServer.class.getResource("/").getPath() + "web.xml";
        } else {
            String besWebXmlPath = System.getProperty("bes.webxml.path", "/mservice/lib/");
            if (!besWebXmlPath.equals("")) {
                if (!besWebXmlPath.endsWith("/")) {
                    besWebXmlPath = besWebXmlPath + "/";
                }
                tarXmlPath = besWebXmlPath + "web.xml";
            }
        }
        URL url = URI.create(jarSource).toURL();
        File targetFile = new File(tarXmlPath);
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        }
        IOUtils.copy((URL)url, (File)targetFile);
        contextConfig.setDefaultWebXml(tarXmlPath);
        ierpContext.addApplicationListener("kd.bos.msgjet.websocket.tomcat.TomcatWsContextListener");
        String containerSciFilter = "org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer|org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer|org.apache.tomcat.websocket.server.WsSci|com.apusic.aas.websocket.server.WsSci|com.tongweb.web.websocket.server.WsSci|com.bes.enterprise.web.jasper.servlet.JasperInitializer";
        ierpContext.setContainerSciFilter(containerSciFilter);
        ierpContext.setParentClassLoader(EmbedBesServer.class.getClassLoader());
        this.addEncodingFilter(ierpContext);
        this.monitorInstall(ierpContext);
        EyeInstaller.installIerp((Object)ierpContext);
        DefaultContext monitorContext = new DefaultContext();
        StandardJarScanner contextJarScanner = (StandardJarScanner)monitorContext.getJarScanner();
        contextJarScanner.setScanManifest(false);
        monitorContext.setPath("");
        monitorContext.setContainerSciFilter(containerSciFilter);
        monitorContext.addLifecycleListener((LifecycleListener)new BESCore.FixContextListener());
        besCore.getHost().addChild((Container)monitorContext);
        this.monitorInstall((Context)monitorContext);
        int max = Integer.getInteger("server.tomcat.max-http-form-post-size", 200000000);
        BESConnector connector = new BESConnector("HTTP/1.1");
        connector.setPort(port);
        connector.setMaxPostSize(max);
        besCore.getService().addConnector((Connector)connector);
        besCore.start();
        for (Valve tempValve : valveArray = besCore.getHost().getPipeline().getValves()) {
            String simpleName = tempValve.getClass().getSimpleName();
            if (!simpleName.equals("ErrorReportValve")) continue;
            ErrorReportValve errorReportValve = (ErrorReportValve)tempValve;
            errorReportValve.setShowServerInfo(false);
            break;
        }
        besCore.getServer().await();
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (StringUtils.isNotEmpty((String)osName)) {
            return osName.toLowerCase().contains("win");
        }
        return false;
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static void initWebappDefaults(BESCore besCore, Context context) {
        Wrapper servlet = BESCore.addServlet((Context)context, (String)"default", (String)"com.bes.enterprise.webtier.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        context.addServletMappingDecoded("/", "default");
        context.setSessionTimeout(30);
    }

    private void monitorInstall(Context context) {
        try {
            MonitorInstaller.install((Object)context);
            EyeInstaller.install((Object)context);
        }
        catch (IOException e) {
            throw new Error("EmbedTomcatServer monitorInstall IOException:" + e.getMessage(), e);
        }
    }

    private void addEncodingFilter(Context context) {
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName("encodingFilter");
        filterDef.setFilter((Filter)new EncodingFilter());
        filterDef.setFilterClass(EncodingFilter.class.getName());
        context.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName("encodingFilter");
        filterMap.addURLPattern("*");
        context.addFilterMap(filterMap);
    }
}

