/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.lightweight;

import kd.bos.service.lightweight.LightService;
import kd.bos.util.SystemProperties;
import org.apache.zookeeper.server.LightweightZookeeperServer;

public class ZookeeperService
implements LightService {
    @Override
    public void start() {
        String port = SystemProperties.getWithEnv((String)"zookeeper.server.port", (String)"2181");
        if (!Boolean.getBoolean("zookeeper.admin.enableServer")) {
            System.setProperty("zookeeper.admin.enableServer", "false");
        }
        String dataDir = SystemProperties.getWithEnv((String)"zookeeper.data.dir", (String)"zookeeper/data");
        String tickTime = SystemProperties.getWithEnv((String)"zookeeper.server.tickTime", (String)"5000");
        String maxClientCnxns = SystemProperties.getWithEnv((String)"zookeeper.server.maxClientCnxns", (String)"10");
        try {
            LightweightZookeeperServer zookeeperServer = new LightweightZookeeperServer();
            zookeeperServer.start(new String[]{port, dataDir, tickTime, maxClientCnxns});
        }
        catch (Exception e) {
            throw new RuntimeException("zookeeper server error", e);
        }
    }

    @Override
    public String getName() {
        return "zookeeper";
    }

    @Override
    public int getOrder() {
        return 1000;
    }
}

