/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.web.filter;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.Configs;
import kd.bos.service.web.filter.AsyncPool;
import kd.bos.service.web.filter.EntranceExtensionFilter;
import kd.bos.service.web.filter.HttpServletRequestWrapper;
import kd.bos.session.SessionKeys;
import kd.bos.thread.OutOfMemoryObserver;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.RevProxyUtil;
import org.eclipse.jetty.server.Request;

public class ActionEntranceFilter
implements EntranceExtensionFilter {
    private static Log logger = LogFactory.getLog(ActionEntranceFilter.class);

    @Override
    public void doFilter(ServletRequest paramServletRequest, ServletResponse paramServletResponse, FilterChain chain) throws IOException, ServletException {
        if (Configs.isWebResourceBalanceEnable() && "jetty".equalsIgnoreCase(System.getProperty("webserver.type", "jetty"))) {
            String requestAccountId = this.getRequestAccountId(paramServletRequest);
            ThreadTruck.put((Object)"request_isolatorAccountId", (Object)(requestAccountId == null ? "Fixed_Virtual_Tenant_101010" : requestAccountId));
            ServletRequest _request = paramServletRequest;
            while (_request instanceof ServletRequestWrapper) {
                _request = ((ServletRequestWrapper)_request).getRequest();
            }
            if (_request instanceof Request) {
                ((Request)_request).setAsyncSupported(true, null);
            }
            AsyncContext asyncContext = paramServletRequest.startAsync();
            asyncContext.setTimeout((long)Integer.getInteger("org.eclipse.jetty.http.timeout", 0).intValue());
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)paramServletRequest);
            try {
                AsyncPool.getExecutor().execute(() -> {
                    try {
                        chain.doFilter((ServletRequest)wrapper, paramServletResponse);
                    }
                    catch (OutOfMemoryError e) {
                        OutOfMemoryObserver.onOutOfMemory((OutOfMemoryError)e);
                        throw e;
                    }
                    catch (IOException e) {
                        logger.warn("Async web request throw IOException:", (Throwable)e);
                    }
                    catch (ServletException e) {
                        logger.warn("Async web request throw ServletException:", (Throwable)e);
                    }
                    finally {
                        ThreadLifeCycleManager.end();
                        asyncContext.complete();
                    }
                });
            }
            catch (Exception e) {
                String servletPath = ActionUtil.getServletPath((HttpServletRequest)((HttpServletRequest)paramServletRequest));
                if (servletPath.startsWith("//")) {
                    servletPath = servletPath.substring(2);
                } else if (servletPath.startsWith("/")) {
                    servletPath = servletPath.substring(1);
                }
                int pos = servletPath.lastIndexOf(47);
                String action = pos > 0 ? servletPath.substring(pos + 1) : servletPath;
                pos = action.indexOf(".");
                if (pos > 0) {
                    action = action.substring(0, pos);
                }
                ActionUtil.responseException((Throwable)e, (String)action, (String)((HttpServletRequest)paramServletRequest).getRequestURI(), (ServletResponse)paramServletResponse);
            }
        } else {
            chain.doFilter(paramServletRequest, paramServletResponse);
        }
    }

    private String getRequestAccountId(ServletRequest paramServletRequest) {
        HttpServletRequest request = (HttpServletRequest)paramServletRequest;
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(SessionKeys.getGlobalCookieAccountIsolatorKey((String)tenantAlias))) continue;
            return cookie.getValue();
        }
        return null;
    }
}

