/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.container;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.serverless.container.ServerlessContainer;

public class ServerlessContainerFactory {
    public static ServerlessContainer getServerlessContainer() {
        String serverlessType = System.getProperty("serverless.type");
        if ("aws".equalsIgnoreCase(serverlessType)) {
            return ServerlessContainerFactory.getAWSServerlessContainer();
        }
        if ("hw".equalsIgnoreCase(serverlessType)) {
            return ServerlessContainerFactory.getHWServerlessContainer();
        }
        return null;
    }

    public static ServerlessContainer getAWSServerlessContainer() {
        String className = "kd.bos.serverless.aws.AWSServerlessContainer";
        try {
            return (ServerlessContainer)Class.forName(className).newInstance();
        }
        catch (Exception t) {
            throw new KDException(BosErrorCode.bOSNotImplemented, className, (Throwable)t);
        }
    }

    public static ServerlessContainer getHWServerlessContainer() {
        String className = "kd.bos.serverless.hw.HWServerlessContainer";
        try {
            return (ServerlessContainer)Class.forName(className).newInstance();
        }
        catch (Exception t) {
            throw new KDException(BosErrorCode.bOSNotImplemented, className, (Throwable)t);
        }
    }
}

