/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.serverless.api.JobStatus;
import kd.bos.serverless.api.StatusEnum;
import kd.bos.serverless.config.Constant;
import kd.bos.util.StringUtils;

public class JobStatusCache {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("severless-cache");
    private static final String CACHE_KEY_PREFIX = "serverless-status-";
    private static final String STATUS_STR = "status";
    private static final String DES_STR = "des";

    public static JobStatus getStatus(String jobid) {
        Map map = cache.getAll(CACHE_KEY_PREFIX + jobid);
        if (map != null && !StringUtils.isEmpty((String)((String)map.get(STATUS_STR)))) {
            return new JobStatus(StatusEnum.valueOf((String)((String)map.get(STATUS_STR))), (String)map.get(DES_STR));
        }
        return null;
    }

    public static void cacheStatus(String jobid, StatusEnum status, String des) {
        int timeout = Integer.parseInt(System.getProperty("serverless.job.timeout.seconds", Constant.DEFAULT_JOBSTATUS_TIMEOUT));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DES_STR, des);
        map.put(STATUS_STR, status.toString());
        cache.put(CACHE_KEY_PREFIX + jobid, map, timeout, TimeUnit.SECONDS);
    }

    public static void delete(String jobid) {
        cache.remove(CACHE_KEY_PREFIX + jobid);
    }
}

