/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.core;

import java.io.Serializable;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.serverless.api.JobParameterStore;
import kd.bos.serverless.api.ServerlessException;
import kd.bos.serverless.support.HessianSerializer;

public class MessageTruckRedis
implements JobParameterStore {
    private static MessageTruckRedis instance = new MessageTruckRedis();
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static MessageTruckRedis get() {
        return instance;
    }

    public void storeParameter(String jobid, Serializable params) {
        if (cache.contains(jobid)) {
            throw new ServerlessException("job exists alreadly with jobid :" + jobid);
        }
        byte[] paramsb = HessianSerializer.serialize(params);
        if ((long)paramsb.length > Long.getLong("serverless.job.parameter.limit", 0x3200000L)) {
            throw new ServerlessException("parameters too large with jobid :" + jobid);
        }
        cache.put(jobid, paramsb);
    }

    public Object loadParameter(String jobid) {
        byte[] bytes = cache.getByteValue(jobid);
        return HessianSerializer.deserialize(bytes);
    }

    public void deleteParameter(String jobid) {
        cache.remove(jobid);
    }
}

