/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.core;

import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.serverless.api.Job;
import kd.bos.serverless.api.StatusEnum;
import kd.bos.serverless.config.Configuration;
import kd.bos.serverless.config.ServerlessJobDef;
import kd.bos.serverless.container.ServerlessContainer;
import kd.bos.serverless.container.ServerlessContainerFactory;
import kd.bos.serverless.core.JobStatusCache;
import kd.bos.serverless.core.MessageSidecar;
import kd.bos.serverless.core.MessageTruckFactory;
import kd.bos.serverless.service.JobFinalize;
import kd.bos.util.StringUtils;

public class ServerlessJobExecuter
implements Runnable {
    private String jobid;
    private boolean isFinish = false;
    private static final Log logger = LogFactory.getLog(ServerlessJobExecuter.class);
    private JobFinalize finanlizer = null;

    public ServerlessJobExecuter(String jobid) {
        this.jobid = jobid;
    }

    public ServerlessJobExecuter(String jobid, JobFinalize finanlizer) {
        this.jobid = jobid;
        this.finanlizer = finanlizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            JobStatusCache.cacheStatus(this.jobid, StatusEnum.RUNNING, this.jobid + " job is running.");
            if (StringUtils.isEmpty((String)this.jobid)) {
                throw new KDException(BosErrorCode.serverlessException, new Object[]{"jobId is empty"});
            }
            String jobStoreKey = "_sys." + this.jobid;
            MessageSidecar messageCar = (MessageSidecar)MessageTruckFactory.get().loadParameter(jobStoreKey);
            RequestContext rc = messageCar.getRc();
            if (rc != null) {
                RequestContext.set((RequestContext)rc);
            }
            Job job = this.getJob(messageCar.getJobname());
            Object parameter = messageCar.getMessage();
            job.execute(this.jobid, parameter);
            MessageTruckFactory.get().deleteParameter(jobStoreKey);
            this.isFinish = true;
            JobStatusCache.cacheStatus(this.jobid, StatusEnum.FINISH, this.jobid + " job is finish.");
        }
        catch (Exception e) {
            logger.error("serverless job error: " + this.jobid, (Throwable)e);
            JobStatusCache.cacheStatus(this.jobid, StatusEnum.ERROR, "job is error:" + e.getMessage());
        }
        finally {
            ServerlessContainer sc = ServerlessContainerFactory.getServerlessContainer();
            if (sc != null) {
                sc.delete(this.jobid);
            }
            if (this.finanlizer != null) {
                this.finanlizer.finalizeWork();
            }
        }
    }

    private Job getJob(String jobName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ServerlessJobDef jobdef = Configuration.getJob(jobName);
        String classstr = jobdef.getClassName();
        Job job = (Job)Class.forName(classstr).newInstance();
        return job;
    }

    public boolean isFinished() {
        return this.isFinish;
    }
}

