/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.support;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import kd.bos.serverless.api.ServerlessException;

public class HessianSerializer {
    public static byte[] serialize(Serializable message) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Hessian2Output h2o = new Hessian2Output((OutputStream)os);
        try {
            h2o.startMessage();
            h2o.writeObject((Object)message);
            h2o.completeMessage();
            h2o.close();
            byte[] buffer = os.toByteArray();
            os.close();
            return buffer;
        }
        catch (Exception e) {
            throw new ServerlessException("serialize serverless message error: ", (Throwable)e);
        }
    }

    public static Object deserialize(byte[] message) {
        Hessian2Input h2i = new Hessian2Input((InputStream)new ByteArrayInputStream(message));
        try {
            h2i.startMessage();
            return h2i.readObject();
        }
        catch (Exception e) {
            throw new ServerlessException("deserialize serverless message error: ", (Throwable)e);
        }
    }
}

