/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.kscript.dom.CodeObject;
import kd.bos.kscript.exception.BOSException;
import kd.bos.kscript.exception.ExceptionUtil;
import kd.bos.kscript.exception.IExceptionInfoSupport;
import kd.bos.kscript.exception.StringUtils;
import kd.bos.kscript.parser.Source;

public class KScriptException
extends BOSException
implements IExceptionInfoSupport {
    private static final long serialVersionUID = 1L;
    private String errorCode = null;
    private String errorExpr = null;
    private String errorMsg = null;
    private String locale = null;
    private int errorLineNum = 0;
    private String errorLineCode = null;
    private List args = null;
    private String infoId = null;

    public String getErrorLineCode() {
        return this.errorLineCode;
    }

    public KScriptException setErrorLineCode(Source source) {
        this.errorLineCode = source.getLine(this.errorLineNum);
        return this;
    }

    public KScriptException setErrorLineCode(String errorLineCode) {
        this.errorLineCode = errorLineCode;
        return this;
    }

    public int getErrorLineNum() {
        return this.errorLineNum;
    }

    public void setErrorLineNum(int errorLineNum) {
        this.errorLineNum = errorLineNum;
    }

    public KScriptException() {
    }

    public KScriptException(String message) {
        super(message);
    }

    public KScriptException(String message, Throwable e) {
        super(message, e);
        if (e instanceof KScriptException) {
            KScriptException o = (KScriptException)e;
            this.errorCode = o.errorCode;
            this.errorExpr = o.errorExpr;
            this.errorMsg = o.errorMsg;
        }
    }

    public KScriptException(String code, String expr, String msg, Throwable e) {
        super(msg + "\nCode: " + code + "\nExpr: " + expr, e);
        this.errorCode = code;
        this.errorExpr = expr;
        this.errorMsg = msg;
    }

    public KScriptException(String code, String expr, String msg, String locale, Throwable e) {
        super(msg + "\nCode: " + code + "\nExpr: " + expr, e);
        this.errorCode = code;
        this.errorExpr = expr;
        this.errorMsg = msg;
        this.locale = locale;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorExpr() {
        return this.errorExpr;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public KScriptException setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public KScriptException setErrorExpr(String errorExpr) {
        this.errorExpr = errorExpr;
        return this;
    }

    public KScriptException setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public List getArgs() {
        return this.args;
    }

    public KScriptException addArg(Object arg) {
        if (this.args == null) {
            this.args = new ArrayList();
        }
        if (arg == null) {
            this.args.add(null);
        } else if (arg instanceof Class) {
            this.args.add(((Class)arg).getName());
        } else if (arg instanceof CodeObject) {
            StringBuffer sb = new StringBuffer();
            ((CodeObject)arg).output(sb, "");
            this.args.add(sb.toString());
        } else {
            this.args.add(arg.toString());
        }
        return this;
    }

    public String getInfoId() {
        return this.infoId;
    }

    public KScriptException setInfoId(String id) {
        this.infoId = id;
        return this;
    }

    public String getCode() {
        return null;
    }

    public Map getConext() {
        return null;
    }

    public String getLang() {
        if (StringUtils.isEmpty(this.locale)) {
            return "l2";
        }
        return this.locale;
    }

    public Object getTarget() {
        return null;
    }

    @Override
    public String getMessage() {
        String result = ExceptionUtil.getDetailMessage(this);
        String str = "";
        if (this.errorLineNum != 0) {
            str = str + "Execute error at line " + this.errorLineNum + "\r\n";
        }
        if (!StringUtils.isEmpty(this.errorLineCode)) {
            str = str + this.errorLineCode + "\r\n";
        }
        if (result == null) {
            return str + super.getMessage();
        }
        return str + result;
    }
}

