/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.kscript.debug.ArrayValue;
import kd.bos.kscript.debug.ErrorValue;
import kd.bos.kscript.debug.IValue;
import kd.bos.kscript.debug.ListValue;
import kd.bos.kscript.debug.MapValue;
import kd.bos.kscript.debug.ObjectValue;
import kd.bos.kscript.debug.SetValue;
import kd.bos.kscript.runtime.PrimitiveValue;
import kd.bos.kscript.runtime.ToString;
import org.apache.log4j.Logger;

public class BasicValue
implements IValue {
    static final Logger logger = Logger.getLogger(BasicValue.class);
    public final Object value;
    public final Class type;

    public BasicValue(Object value, Class type) {
        this.value = value;
        this.type = type == null ? value.getClass() : type;
    }

    public BasicValue(Object value) {
        this(value, null);
    }

    public Object getOriginalValue() {
        return this.value;
    }

    @Override
    public String getStackTrace() {
        if (this.value == null || !(this.value instanceof Throwable)) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        ((Throwable)this.value).printStackTrace(out);
        out.flush();
        return sw.toString();
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getChildName(int index) {
        return null;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public final IValue getChildValue(int index) {
        try {
            return BasicValue.valueOf(this._getChildValue(index), this._getChildType(index));
        }
        catch (Exception ex) {
            return new ErrorValue(ex);
        }
    }

    protected Class _getChildType(int index) {
        return null;
    }

    protected Object _getChildValue(int index) throws Exception {
        return null;
    }

    @Override
    public Class getGeneralType() {
        return BasicValue.getGeneralType(this.type);
    }

    @Override
    public String getTypeName() {
        return BasicValue.getTypeName(this.type);
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return null;
        }
        return ToString.toString(this.value);
    }

    private static Class getGeneralType(Class type) {
        if (type.isArray()) {
            return BasicValue.arrayType(BasicValue.getGeneralType(type.getComponentType()));
        }
        if (type.isPrimitive()) {
            return type;
        }
        Package p = type.getPackage();
        if (p != null && (p.getName().equals("java.lang") || p.getName().equals("java.util"))) {
            return type;
        }
        if (String.class.isAssignableFrom(type)) {
            return String.class;
        }
        if (Map.class.isAssignableFrom(type)) {
            return Map.class;
        }
        if (List.class.isAssignableFrom(type)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return Set.class;
        }
        if (Throwable.class.isAssignableFrom(type)) {
            return Throwable.class;
        }
        return Object.class;
    }

    private static Class arrayType(Class type) {
        return Array.newInstance(type, 0).getClass();
    }

    private static String getTypeName(Class type) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            return BasicValue.getTypeName(type.getComponentType()) + "[]";
        }
        String name = type.getName();
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public static IValue valueOf(Object obj, Class type) {
        if (obj == null) {
            if (type == null) {
                return null;
            }
            return new BasicValue(obj, type);
        }
        if (type == null) {
            type = obj.getClass();
        }
        if (type.isArray()) {
            return new ArrayValue(obj);
        }
        if (obj instanceof List) {
            return new ListValue(obj);
        }
        if (obj instanceof Map) {
            return new MapValue(obj);
        }
        if (obj instanceof Set) {
            return new SetValue(obj);
        }
        if (obj instanceof String) {
            return new BasicValue(obj, String.class);
        }
        if (type.isPrimitive()) {
            return new BasicValue(obj, type);
        }
        if (obj instanceof PrimitiveValue) {
            PrimitiveValue pv = (PrimitiveValue)obj;
            return new BasicValue(pv.getBoxValue(), pv.getUnBoxType());
        }
        return new ObjectValue(obj);
    }
}

