/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.debug;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.kscript.debug.AbstractBreakPoints;
import kd.bos.kscript.debug.IDebugContext;
import kd.bos.kscript.dom.CodeObject;

public class BreakPoints
extends AbstractBreakPoints {
    private final HashSet lines;
    private volatile boolean breakImmediately;
    private volatile transient boolean modified = false;

    public BreakPoints() {
        this.breakImmediately = true;
        this.lines = new HashSet();
    }

    private BreakPoints(BreakPoints src) {
        this.breakImmediately = src.breakImmediately;
        this.lines = new HashSet(src.lines);
    }

    public BreakPoints copy() {
        return new BreakPoints(this);
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isBreakImmediately() {
        return this.breakImmediately;
    }

    public void setBreakImmediately(boolean b) {
        if (this.breakImmediately != b) {
            this.modified = true;
            this.breakImmediately = b;
        }
    }

    public synchronized boolean containsLine(int line) {
        return this.lines.contains(line);
    }

    public synchronized void removeLine(int line) {
        this.lines.remove(line);
        this.modified = true;
    }

    public synchronized boolean reverseLine(int line) {
        this.modified = true;
        Integer k = line;
        if (this.lines.contains(k)) {
            this.lines.remove(k);
            return false;
        }
        this.lines.add(k);
        return true;
    }

    public synchronized void addLine(int line) {
        this.lines.add(line);
        this.modified = true;
    }

    public synchronized int getLineCount() {
        return this.lines.size();
    }

    public synchronized int[] getLines() {
        int[] ar = new int[this.lines.size()];
        Iterator ite = this.lines.iterator();
        int i = 0;
        while (ite.hasNext()) {
            ar[i] = (Integer)ite.next();
            ++i;
        }
        return ar;
    }

    @Override
    public boolean needBreak(IDebugContext debug, boolean no_line_break_points, CodeObject code, Map context, boolean isFirstCode) {
        if (isFirstCode && this.breakImmediately) {
            return true;
        }
        return !no_line_break_points && this.containsLine(code.position.beginLine);
    }

    public void dump() {
        int[] lines = this.getLines();
    }
}

