/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.debug;

import kd.bos.kscript.debug.DebugTracer;
import kd.bos.kscript.debug.IDebugContext;
import kd.bos.kscript.debug.IDebugEnv;
import kd.bos.kscript.debug.IDebugTracer;
import kd.bos.kscript.runtime.Interpreter;

public class DebugFactory {
    private static final ThreadLocal threadTracers = new ThreadLocal();

    public static synchronized void initializeInterpreter(IDebugEnv debugEnv, Interpreter interpreter) {
        if (debugEnv != null) {
            DebugTracer tracer = new DebugTracer(debugEnv, interpreter);
            interpreter.setTracer(tracer);
        }
    }

    public static IDebugTracer setCurrentTracer(IDebugTracer tracer) {
        IDebugTracer old = (IDebugTracer)threadTracers.get();
        threadTracers.set(tracer);
        return old;
    }

    public static IDebugTracer getCurrentTracer() {
        return (IDebugTracer)threadTracers.get();
    }

    public static IDebugContext getCurrentDebugContext() {
        Object x = threadTracers.get();
        if (x != null && x instanceof IDebugContext) {
            return (IDebugContext)x;
        }
        return null;
    }
}

