/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.dom.Function;
import kd.bos.kscript.dom.stmt.CodeStmt;
import kd.bos.kscript.parser.AbstractParser;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.Source;
import kd.bos.kscript.parser.StmtParser;
import kd.bos.kscript.parser.Token;
import kd.bos.kscript.parser.TokenList;

public class KScriptParser
extends AbstractParser {
    public final List namespaces;
    public final Map classMap;
    public Source source = null;
    public List stmtList = new ArrayList();
    public Map functionDeclMap = new Hashtable();
    public Map classDeclMap = new Hashtable();

    public KScriptParser(String text) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = new ArrayList();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new Hashtable();
    }

    public KScriptParser(TokenList tokList) {
        this._tokenList = tokList;
        this.namespaces = new ArrayList();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new Hashtable();
    }

    public KScriptParser(TokenList tokList, List namespaces, Map classMap) {
        this._tokenList = tokList;
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public KScriptParser(String text, List namespaces, Map classMap) throws ParserException {
        this(new Source(text), namespaces, classMap);
    }

    public KScriptParser(Source source, List namespaces, Map classMap) throws ParserException {
        this.source = source;
        Lexer lexer = new Lexer(source);
        this._tokenList = new TokenList(lexer);
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public void parse() throws ParserException {
        StmtParser stmtParser = new StmtParser(this._tokenList, this.namespaces, this.classMap);
        while (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
            if (this._tokenList.lookup(0).equals(Token.FunctionToken)) {
                this.parse_function();
                continue;
            }
            CodeStmt stmt = stmtParser.stmt();
            if (stmt == null) continue;
            stmt.validate();
            this.stmtList.add(stmt);
        }
    }

    public void parse_function() throws ParserException {
        Token first = this._tokenList.lookup(0);
        this._tokenList.match(Token.FunctionToken);
        Function func = new Function(first);
        func.name = this._tokenList.lookup((int)0).value;
        this._tokenList.match(1);
        this._tokenList.match(Token.OpenBraceToken);
        if (!this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
            String pramName = this._tokenList.lookup((int)0).value;
            func.paramList.add(pramName);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                pramName = this._tokenList.lookup((int)0).value;
                func.paramList.add(pramName);
                this._tokenList.match(1);
            }
        }
        this._tokenList.match(Token.CloseBraceToken);
        this._tokenList.match(Token.OpenCurlyBraceToken);
        StmtParser stmtParser = new StmtParser(this._tokenList, this.namespaces, this.classMap);
        stmtParser.stmtList(func.stmtList, Token.CloseCurlyBraceToken);
        this._tokenList.match(Token.CloseCurlyBraceToken);
        this.functionDeclMap.put(func.name, func);
        func.position = this.getPosition(first);
    }

    public String outputResult() {
        StringBuffer buff = new StringBuffer();
        this.outputResult(buff);
        return buff.toString();
    }

    public void outputResult(StringBuffer buff) {
        boolean flag = false;
        Iterator<Object> iter = this.functionDeclMap.values().iterator();
        while (iter.hasNext()) {
            if (flag) {
                buff.append("\n\n");
            }
            Function funDecl = (Function)iter.next();
            funDecl.output(buff, null);
        }
        if (flag) {
            buff.append("\n\n");
        }
        flag = false;
        iter = this.stmtList.iterator();
        while (iter.hasNext()) {
            if (flag) {
                buff.append("\n");
            }
            CodeStmt stmt = (CodeStmt)iter.next();
            stmt.output(buff, null);
            flag = true;
        }
    }
}

