/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.dom.expr.BinaryOpExpr;
import kd.bos.kscript.dom.expr.CodeExpr;
import kd.bos.kscript.dom.expr.VectorCreateExpr;
import kd.bos.kscript.dom.stmt.AbstractCaseItem;
import kd.bos.kscript.dom.stmt.BlockStmt;
import kd.bos.kscript.dom.stmt.BreakStmt;
import kd.bos.kscript.dom.stmt.CaseItem;
import kd.bos.kscript.dom.stmt.CodeStmt;
import kd.bos.kscript.dom.stmt.ContinueStmt;
import kd.bos.kscript.dom.stmt.DefaultCaseItem;
import kd.bos.kscript.dom.stmt.DoStmt;
import kd.bos.kscript.dom.stmt.ElseIfItem;
import kd.bos.kscript.dom.stmt.ExprListStmt;
import kd.bos.kscript.dom.stmt.ExprStmt;
import kd.bos.kscript.dom.stmt.ForStmt;
import kd.bos.kscript.dom.stmt.IfStmt;
import kd.bos.kscript.dom.stmt.ReturnStmt;
import kd.bos.kscript.dom.stmt.SwitchStmt;
import kd.bos.kscript.dom.stmt.VarDeclItem;
import kd.bos.kscript.dom.stmt.VarDeclStmt;
import kd.bos.kscript.dom.stmt.WhileStmt;
import kd.bos.kscript.parser.AbstractParser;
import kd.bos.kscript.parser.ExprParser;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.Token;
import kd.bos.kscript.parser.TokenList;
import kd.bos.kscript.util.TypeUtils;

public class StmtParser
extends AbstractParser {
    public final List namespaces;
    public final Map classMap;

    public StmtParser(TokenList tokList) {
        this._tokenList = tokList;
        this.namespaces = new ArrayList();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new Hashtable();
    }

    public StmtParser(TokenList tokList, List namespaces, Map classMap) {
        this._tokenList = tokList;
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public StmtParser(String text) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = new ArrayList();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new Hashtable();
    }

    public StmtParser(String text, List namespaces, Map classMap) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public void stmtList(List list) throws ParserException {
        this.stmtList(list, null);
    }

    public void stmtList(List list, Token endTok) throws ParserException {
        while (!(this._tokenList.lookup(0).equals(Token.EOFToken) || endTok != null && this._tokenList.lookup(0).equals(endTok))) {
            CodeStmt stmt = this.stmt();
            if (stmt == null) continue;
            list.add(stmt);
        }
    }

    public CodeStmt stmt() throws ParserException {
        Token first = this._tokenList.lookup(0);
        if (this._tokenList.lookup(0).equals(Token.SemicolonToken)) {
            this._tokenList.match();
            return null;
        }
        if (this._tokenList.lookup(0).equals(Token.IfToken)) {
            return this.ifStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.WhileToken)) {
            return this.whileStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.DoToken)) {
            return this.doStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.ForToken)) {
            return this.forStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.ReturnToken)) {
            this._tokenList.match();
            ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
            CodeExpr expr = parser.expr();
            if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
                this._tokenList.match(Token.SemicolonToken);
            }
            return new ReturnStmt(this.getPosition(first), expr);
        }
        if (this._tokenList.lookup(0).equals(Token.BreakToken)) {
            this._tokenList.match();
            if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
                this._tokenList.match(Token.SemicolonToken);
            }
            return new BreakStmt(this.getPosition(first));
        }
        if (this._tokenList.lookup(0).equals(Token.ContinueToken)) {
            this._tokenList.match();
            if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
                this._tokenList.match(Token.SemicolonToken);
            }
            return new ContinueStmt(this.getPosition(first));
        }
        if (this._tokenList.lookup(0).equals(Token.SwitchToken)) {
            return this.switchStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
            this._tokenList.match();
            BlockStmt blockStmt = new BlockStmt(null);
            this.stmtList(blockStmt.stmtList, Token.CloseCurlyBraceToken);
            this._tokenList.match(Token.CloseCurlyBraceToken);
            blockStmt.position = this.getPosition(first);
            return blockStmt;
        }
        if (this._tokenList.lookup(0).equals(Token.VarToken)) {
            this._tokenList.match();
            VarDeclStmt varDeclStmt = new VarDeclStmt(null);
            VarDeclItem varItem = new VarDeclItem(null);
            Token varItemFirst = this._tokenList.lookup(0);
            String varName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            varItem.name = varName;
            ExprParser parser = new ExprParser(this._tokenList);
            if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                this._tokenList.match();
                if (this._tokenList.lookup(0).equals(Token.OpenSquareBraceToken)) {
                    Token vectorFirst = this._tokenList.lookup(0);
                    this._tokenList.match();
                    if (this._tokenList.lookup(0).equals(Token.CloseSquareBraceToken)) {
                        this._tokenList.match();
                        varItem.initExpr = new VectorCreateExpr(this.getPosition(vectorFirst));
                    } else {
                        VectorCreateExpr vecCreateExpr = new VectorCreateExpr(null);
                        parser.exprList(vecCreateExpr.paramList);
                        varItem.initExpr = vecCreateExpr;
                        this._tokenList.match(Token.CloseSquareBraceToken);
                        vecCreateExpr.position = this.getPosition(vectorFirst);
                    }
                } else {
                    varItem.initExpr = parser.expr();
                }
            }
            varItem.position = this.getPosition(varItemFirst);
            varDeclStmt.varDeclList.add(varItem);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                varItem = new VarDeclItem(null);
                varItemFirst = this._tokenList.lookup(0);
                varName = this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
                varItem.name = varName;
                if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                    this._tokenList.match();
                    varItem.initExpr = parser.expr();
                }
                varItem.position = this.getPosition(varItemFirst);
                varDeclStmt.varDeclList.add(varItem);
            }
            if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
                this._tokenList.match(Token.SemicolonToken);
            }
            varDeclStmt.position = this.getPosition(first);
            return varDeclStmt;
        }
        if (this._tokenList.lookup(0).equals(Token.New)) {
            ExprParser parser = new ExprParser(this._tokenList);
            return new ExprStmt(this.getPosition(first), parser.expr());
        }
        if (this._tokenList.lookup((int)0).type == 1 || this._tokenList.lookup((int)0).type == 3) {
            StringBuffer buff = new StringBuffer();
            buff.append(this._tokenList.lookup((int)0).value);
            int tokIndex = 0;
            while (this._tokenList.lookup(++tokIndex).equals(Token.PeriodToken)) {
                buff.append('.');
                buff.append(this._tokenList.lookup((int)(++tokIndex)).value);
            }
            String typeName = buff.toString();
            Class type = TypeUtils.classForName(this.namespaces, this.classMap, typeName);
            if (type != null || this._tokenList.lookup((int)tokIndex).type == 1 || this._tokenList.lookup(tokIndex).equals(Token.OpenSquareBraceToken) && this._tokenList.lookup(tokIndex + 1).equals(Token.CloseSquareBraceToken)) {
                for (int i = 0; i < tokIndex; ++i) {
                    this._tokenList.match();
                }
                if (this._tokenList.lookup(0).equals(Token.OpenSquareBraceToken) && this._tokenList.lookup(1).equals(Token.CloseSquareBraceToken)) {
                    this._tokenList.match();
                    this._tokenList.match();
                    typeName = typeName + "[]";
                }
                VarDeclStmt varDeclStmt = new VarDeclStmt(null);
                VarDeclItem varItem = new VarDeclItem(null);
                Token varItemFirst = this._tokenList.lookup(0);
                varItem.type = typeName;
                varItem.name = this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
                ExprParser parser = new ExprParser(this._tokenList);
                if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                    this._tokenList.match();
                    varItem.initExpr = parser.expr();
                }
                varItem.position = this.getPosition(varItemFirst);
                varDeclStmt.varDeclList.add(varItem);
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    varItem = new VarDeclItem(null);
                    varItemFirst = this._tokenList.lookup(0);
                    String varName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    varItem.name = varName;
                    if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                        this._tokenList.match();
                        varItem.initExpr = parser.expr();
                    }
                    varItem.position = this.getPosition(varItemFirst);
                    varDeclStmt.varDeclList.add(varItem);
                }
                this._tokenList.match(Token.SemicolonToken);
                varDeclStmt.position = this.getPosition(first);
                return varDeclStmt;
            }
            if (this._tokenList.lookup((int)tokIndex).type == 1) {
                // empty if block
            }
        }
        ExprParser parser = new ExprParser(this._tokenList);
        ArrayList<CodeExpr> exprList = new ArrayList<CodeExpr>();
        CodeExpr expr = parser.expr();
        exprList.add(expr);
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            expr = parser.expr();
            exprList.add(expr);
        }
        if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
            this._tokenList.match(Token.SemicolonToken);
        }
        if (exprList.size() == 1) {
            return new ExprStmt(this.getPosition(first), expr);
        }
        return new ExprListStmt(this.getPosition(first), exprList);
    }

    public SwitchStmt switchStmt() throws ParserException {
        Token first = this._tokenList.lookup(0);
        this._tokenList.match(Token.SwitchToken);
        ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
        SwitchStmt switchStmt = new SwitchStmt(null);
        this._tokenList.match(Token.OpenBraceToken);
        switchStmt.testExpr = parser.expr();
        this._tokenList.match(Token.CloseBraceToken);
        this._tokenList.match(Token.OpenCurlyBraceToken);
        while (this._tokenList.lookup(0).equals(Token.CaseToken) || this._tokenList.lookup(0).equals(Token.DefaultToken)) {
            AbstractCaseItem abstractCaseItem;
            Token caseFirst = this._tokenList.lookup(0);
            if (this._tokenList.lookup(0).equals(Token.DefaultToken)) {
                this._tokenList.match();
                abstractCaseItem = new DefaultCaseItem(null);
            } else {
                this._tokenList.match();
                CaseItem caseItem = new CaseItem(null);
                caseItem.valueExpr = parser.expr();
                abstractCaseItem = caseItem;
            }
            this._tokenList.match(Token.ColonToken);
            while (!(this._tokenList.lookup(0).equals(Token.EOFToken) || this._tokenList.lookup(0).equals(Token.CaseToken) || this._tokenList.lookup(0).equals(Token.DefaultToken) || this._tokenList.lookup(0).equals(Token.CloseCurlyBraceToken))) {
                CodeStmt stmt = this.stmt();
                if (stmt == null) continue;
                abstractCaseItem.stmtList.add(stmt);
            }
            abstractCaseItem.position = this.getPosition(caseFirst);
            if (abstractCaseItem instanceof DefaultCaseItem) {
                switchStmt.caseItemList.add(abstractCaseItem);
                switchStmt.defaultCaseItem = abstractCaseItem;
                continue;
            }
            switchStmt.caseItemList.add(abstractCaseItem);
        }
        this._tokenList.match(Token.CloseCurlyBraceToken);
        switchStmt.position = this.getPosition(first);
        return switchStmt;
    }

    public IfStmt ifStmt() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.IfToken)) {
            CodeStmt stmt;
            Token first = this._tokenList.lookup(0);
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
            CodeExpr expr = parser.expr();
            if (expr instanceof BinaryOpExpr) {
                BinaryOpExpr boe = (BinaryOpExpr)expr;
                if (boe.operator == 2) {
                    throw (ParserException)new ParserException("condition can not be assign.", expr, "Can't use assign expression as condition.").setInfoId("CONDITION_CAN_NOT_BE_ASSIGN").addArg(expr.position.beginLine + ":" + expr.position.beginColumn).addArg(boe.toString());
                }
            }
            this._tokenList.match(Token.CloseBraceToken);
            IfStmt ifStmt = new IfStmt(null);
            ifStmt.testExpr = expr;
            if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                this._tokenList.match();
                this.stmtList(ifStmt.trueStmtList, Token.CloseCurlyBraceToken);
                this._tokenList.match(Token.CloseCurlyBraceToken);
            } else {
                stmt = this.stmt();
                ifStmt.trueStmtList.add(stmt);
            }
            while (this._tokenList.lookup(0).equals(Token.ElseToken)) {
                this._tokenList.match();
                if (this._tokenList.lookup(0).equals(Token.IfToken) && this._tokenList.lookup(1).equals(Token.OpenBraceToken)) {
                    Token elseFirst = this._tokenList.lookup(0);
                    this._tokenList.match();
                    this._tokenList.match();
                    ElseIfItem elseIf = new ElseIfItem(null);
                    elseIf.testExpr = parser.expr();
                    this._tokenList.match(Token.CloseBraceToken);
                    if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                        this._tokenList.match();
                        this.stmtList(elseIf.stmtList, Token.CloseCurlyBraceToken);
                        this._tokenList.match(Token.CloseCurlyBraceToken);
                    } else {
                        CodeStmt stmt2 = this.stmt();
                        elseIf.stmtList.add(stmt2);
                    }
                    elseIf.position = this.getPosition(elseFirst);
                    ifStmt.elseIfList.add(elseIf);
                    continue;
                }
                if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                    this._tokenList.match();
                    this.stmtList(ifStmt.elseStmtList, Token.CloseCurlyBraceToken);
                    this._tokenList.match(Token.CloseCurlyBraceToken);
                    break;
                }
                stmt = this.stmt();
                ifStmt.elseStmtList.add(stmt);
                break;
            }
            ifStmt.position = this.getPosition(first);
            return ifStmt;
        }
        Token tok = this._tokenList.lookup(0);
        throw (ParserException)new ParserException("find unexpected token.", tok, "Can't find expect \"if\" token").setInfoId("IF_NO_IF").addArg(tok.beginLine + ":" + tok.beginColumn).addArg(tok.toString());
    }

    public WhileStmt whileStmt() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.WhileToken)) {
            Token first = this._tokenList.lookup(0);
            this._tokenList.match();
            WhileStmt whileStmt = new WhileStmt(first);
            this._tokenList.match(Token.OpenBraceToken);
            ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
            CodeExpr expr = parser.expr();
            this._tokenList.match(Token.CloseBraceToken);
            whileStmt.testExpr = expr;
            if (whileStmt.testExpr == null) {
                throw (ParserException)new ParserException("can't find test case in while statment.", (Token)null, "test condition of while is null").setInfoId("WHILE_NO_CODITION").addArg(whileStmt.position.beginLine + ":" + whileStmt.position.beginColumn).addArg(whileStmt);
            }
            if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                this._tokenList.match();
                this.stmtList(whileStmt.stmtList, Token.CloseCurlyBraceToken);
                this._tokenList.match(Token.CloseCurlyBraceToken);
            } else {
                CodeStmt stmt = this.stmt();
                whileStmt.stmtList.add(stmt);
            }
            whileStmt.position = this.getPosition(first);
            return whileStmt;
        }
        Token token = this._tokenList.lookup(0);
        throw (ParserException)new ParserException("find unexpected token.", this._tokenList.lookup(0), "Can't find expect \"while\" token").setInfoId("WHILE_NO_WHILE").addArg(token.beginLine + ":" + token.beginColumn).addArg(token);
    }

    public DoStmt doStmt() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.DoToken)) {
            Token first = this._tokenList.lookup(0);
            this._tokenList.match();
            DoStmt doStmt = new DoStmt(null);
            if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                this._tokenList.match();
                this.stmtList(doStmt.stmtList, Token.CloseCurlyBraceToken);
                this._tokenList.match(Token.CloseCurlyBraceToken);
            } else {
                CodeStmt stmt = this.stmt();
                doStmt.stmtList.add(stmt);
            }
            this._tokenList.match(Token.WhileToken);
            this._tokenList.match(Token.OpenBraceToken);
            ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
            CodeExpr expr = parser.expr();
            this._tokenList.match(Token.CloseBraceToken);
            this._tokenList.match(Token.SemicolonToken);
            doStmt.testExpr = expr;
            doStmt.position = this.getPosition(first);
            return doStmt;
        }
        Token token = this._tokenList.lookup(0);
        throw (ParserException)new ParserException("find unexpected token.", token, "Can't find expect \"do\" token").setInfoId("DO_NO_DO").addArg(token.beginLine + ":" + token.beginColumn).addArg(token);
    }

    public ForStmt forStmt() throws ParserException {
        ForStmt forStmt = new ForStmt(null);
        Token first = this._tokenList.lookup(0);
        if (this._tokenList.lookup(0).equals(Token.ForToken)) {
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            forStmt.initStmt = this.stmt();
            ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
            forStmt.testExpr = parser.expr();
            this._tokenList.match(Token.SemicolonToken);
            Token incrementFirst = this._tokenList.lookup(0);
            ArrayList<CodeExpr> exprList = new ArrayList<CodeExpr>();
            CodeExpr expr = parser.expr();
            exprList.add(expr);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                expr = parser.expr();
                exprList.add(expr);
            }
            forStmt.incrementStmt = exprList.size() == 1 ? new ExprStmt(this.getPosition(incrementFirst), expr) : new ExprListStmt(this.getPosition(incrementFirst), exprList);
            this._tokenList.match(Token.CloseBraceToken);
            if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                this._tokenList.match();
                this.stmtList(forStmt.stmtList, Token.CloseCurlyBraceToken);
                this._tokenList.match(Token.CloseCurlyBraceToken);
            } else {
                CodeStmt stmt = this.stmt();
                forStmt.stmtList.add(stmt);
            }
            return forStmt;
        }
        Token token = this._tokenList.lookup(0);
        throw (ParserException)new ParserException("find unexpected token.", this._tokenList.lookup(0), "Can't find expect \"for\" token").setInfoId("FOR_NO_FOR").addArg(token.beginLine + ":" + token.beginColumn).addArg(token.toString());
    }
}

