/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.kscript.IFunctionProvider;
import kd.bos.kscript.IObjectLoaderProvider;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.debug.DebugFactory;
import kd.bos.kscript.debug.DebugStopException;
import kd.bos.kscript.debug.IDebugEnv;
import kd.bos.kscript.debug.IDebugTracer;
import kd.bos.kscript.dom.Function;
import kd.bos.kscript.dom.expr.ArrayIndexerExpr;
import kd.bos.kscript.dom.expr.BigDecimalExpr;
import kd.bos.kscript.dom.expr.BinaryOpExpr;
import kd.bos.kscript.dom.expr.BinaryOpType;
import kd.bos.kscript.dom.expr.BoolExpr;
import kd.bos.kscript.dom.expr.CharExpr;
import kd.bos.kscript.dom.expr.CodeExpr;
import kd.bos.kscript.dom.expr.ConditionExpr;
import kd.bos.kscript.dom.expr.DoubleExpr;
import kd.bos.kscript.dom.expr.FloatExpr;
import kd.bos.kscript.dom.expr.IdentifierExpr;
import kd.bos.kscript.dom.expr.IntExpr;
import kd.bos.kscript.dom.expr.LambdaExpr;
import kd.bos.kscript.dom.expr.LongExpr;
import kd.bos.kscript.dom.expr.MethodInvokeExpr;
import kd.bos.kscript.dom.expr.NewFunctionExpr;
import kd.bos.kscript.dom.expr.NullExpr;
import kd.bos.kscript.dom.expr.ObjectCreateExpr;
import kd.bos.kscript.dom.expr.PropertyExpr;
import kd.bos.kscript.dom.expr.StringExpr;
import kd.bos.kscript.dom.expr.UnaryExpr;
import kd.bos.kscript.dom.expr.VectorCreateExpr;
import kd.bos.kscript.dom.stmt.AbstractCaseItem;
import kd.bos.kscript.dom.stmt.BlockStmt;
import kd.bos.kscript.dom.stmt.BreakStmt;
import kd.bos.kscript.dom.stmt.CaseItem;
import kd.bos.kscript.dom.stmt.CodeStmt;
import kd.bos.kscript.dom.stmt.ContinueStmt;
import kd.bos.kscript.dom.stmt.DoStmt;
import kd.bos.kscript.dom.stmt.ElseIfItem;
import kd.bos.kscript.dom.stmt.ExprListStmt;
import kd.bos.kscript.dom.stmt.ExprStmt;
import kd.bos.kscript.dom.stmt.ForStmt;
import kd.bos.kscript.dom.stmt.IfStmt;
import kd.bos.kscript.dom.stmt.ReturnStmt;
import kd.bos.kscript.dom.stmt.SwitchStmt;
import kd.bos.kscript.dom.stmt.VarDeclItem;
import kd.bos.kscript.dom.stmt.VarDeclStmt;
import kd.bos.kscript.dom.stmt.WhileStmt;
import kd.bos.kscript.exception.TODOException;
import kd.bos.kscript.exception.Uuid;
import kd.bos.kscript.parser.ExprParser;
import kd.bos.kscript.parser.KScriptParser;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.Source;
import kd.bos.kscript.parser.TokenList;
import kd.bos.kscript.runtime.CachedFunctionProvider;
import kd.bos.kscript.runtime.FunctionObject;
import kd.bos.kscript.runtime.InterpreterException;
import kd.bos.kscript.runtime.KScriptUtil;
import kd.bos.kscript.runtime.LambdaObject;
import kd.bos.kscript.runtime.Preprocessor;
import kd.bos.kscript.runtime.PrimitiveBoolean;
import kd.bos.kscript.runtime.PrimitiveCharacter;
import kd.bos.kscript.runtime.PrimitiveDouble;
import kd.bos.kscript.runtime.PrimitiveFloat;
import kd.bos.kscript.runtime.PrimitiveInt;
import kd.bos.kscript.runtime.PrimitiveLong;
import kd.bos.kscript.runtime.PrimitiveValue;
import kd.bos.kscript.runtime.ReflectionUtils;
import kd.bos.kscript.runtime.ToString;
import kd.bos.kscript.runtime.Triple;
import kd.bos.kscript.util.Context;
import kd.bos.kscript.util.TypeUtils;
import org.apache.log4j.Logger;

public class Interpreter {
    private static Logger log = Logger.getLogger((String)"kd.bos.kscript.runtime.Interpreter");
    public static final String BOS_CONTEXT_KEY = "__bosContext";
    private static final String CONDITIONAL_SUM = "conditional_sum";
    private static final String DEBUGGER = "debuger";
    private static final String UNSUPPORTED_STATEMENT = "UNSUPPORTED_STATEMENT";
    private static final String ERROR_MSG_NOTFOUND_IDENTIFIER = "Systax Err.Can't find indentifier in context.";
    private static final String ERROR_MSG_EXP_ISNOT_IDENTIFIER = "Systax Err. The expression is not an Identifier.";
    private static final String COST = " COST:";
    private static final String EVALFUNCTION = "[evalFunction] Function:";
    private static final String DEFAULT_OBJECT = "__defaultObject__";
    private static final String ILLEGAL = "IllegalArgumentException";
    public List namespaces = new ArrayList();
    private Map classMap = new HashMap();
    private Map funcDeclMap = new HashMap();
    private Map codeDomCache = new HashMap();
    private Object _defaultObject;
    public List funcProviderList = new ArrayList();
    public static final List publicFuncProviderList = new ArrayList();
    private static List internalFunctionList = new ArrayList();
    private boolean forBot = false;
    private boolean synchronizedCallMethod = false;
    private boolean properyExprOwnerNullIgore = true;
    public static final String KS_COLLECT_VALUE = "_KS_VALUE";
    public static final String KS_COLLECT_OWNER = "_KS_OWNER";
    public static final String KS_COLLECT_SIZE = "_KS_SIZE";
    private Map methodCache = new HashMap();
    private static final String METHOD_GET = "_GET_";
    private static final String METHOD_SET = "_SET_";
    private Map parseCache = new HashMap();
    private Source source = null;
    private IDebugTracer tracer = null;
    private IDebugEnv debugEnv = null;
    private boolean isSupportDebug = false;
    private IObjectLoaderProvider bizObjectProvider = null;
    private static final String BOT = "__BOT";
    private static final String DYNBOT = "__DYNBOT";

    public Source getSource() {
        return this.source;
    }

    public IDebugTracer getTracer() {
        return this.tracer;
    }

    public void setTracer(IDebugTracer tracer) {
        this.tracer = tracer;
    }

    public IDebugEnv getDebugEnv() {
        return this.debugEnv;
    }

    public void setDebugEnv(IDebugEnv debugEnv) {
        this.debugEnv = debugEnv;
        if (this.isSupportDebug()) {
            DebugFactory.initializeInterpreter(debugEnv, this);
        }
    }

    public boolean isSupportDebug() {
        return this.isSupportDebug;
    }

    public void setSupportDebug(boolean isSupportDebug) {
        this.isSupportDebug = isSupportDebug;
    }

    public void addFunctionProvider(IFunctionProvider funcProvider) {
        this.funcProviderList.add(funcProvider);
    }

    public Interpreter(Context context, boolean supportDebug) {
        this((Object)context, supportDebug);
    }

    public Interpreter(Object context, boolean supportDebug) {
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap.put("boolean", Boolean.TYPE);
        this.classMap.put("boolean[]", boolean[].class);
        this.classMap.put("char", Character.TYPE);
        this.classMap.put("char[]", char[].class);
        this.classMap.put("[C", char[].class);
        this.classMap.put("byte", Byte.TYPE);
        this.classMap.put("byte[]", byte[].class);
        this.classMap.put("[B", byte[].class);
        this.classMap.put("short", Short.TYPE);
        this.classMap.put("short[]", short[].class);
        this.classMap.put("[S", short[].class);
        this.classMap.put("int", Integer.TYPE);
        this.classMap.put("int[]", int[].class);
        this.classMap.put("[I", int[].class);
        this.classMap.put("long", Long.TYPE);
        this.classMap.put("long[]", long[].class);
        this.classMap.put("[J", long[].class);
        this.classMap.put("float", Float.TYPE);
        this.classMap.put("float[]", float[].class);
        this.classMap.put("[F", float[].class);
        this.classMap.put("double", Double.TYPE);
        this.classMap.put("double[]", double[].class);
        this.classMap.put("[D", double[].class);
        try {
            this.bizObjectProvider = (IObjectLoaderProvider)Class.forName("kd.bos.dao.ormapping.KscriptObjectLoaderProvider").newInstance();
        }
        catch (InstantiationException e) {
            log.warn((Object)"cannot registe defaultObjectLoaderProvider[kd.bos.dao.ormapping.KscriptObjectLoaderProvider]. Because : InstantiationException");
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"cannot registe defaultObjectLoaderProvider[kd.bos.dao.ormapping.KscriptObjectLoaderProvider]. Because : IllegalAccessException");
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"cannot registe defaultObjectLoaderProvider[kd.bos.dao.ormapping.KscriptObjectLoaderProvider]. Because : ClassNotFoundException");
        }
        int publicFuncProviderListSize = publicFuncProviderList.size();
        for (int i = 0; i < publicFuncProviderListSize; ++i) {
            this.funcProviderList.add(publicFuncProviderList.get(i));
        }
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.setContext(context);
        }
        this.isSupportDebug = supportDebug;
    }

    public void setBizObjectProvider(IObjectLoaderProvider bizObjectProvider) {
        this.bizObjectProvider = bizObjectProvider;
    }

    public IObjectLoaderProvider getBizObjectProvider() {
        return this.bizObjectProvider;
    }

    public Interpreter(Object bosContext) {
        this(bosContext, false);
    }

    public Interpreter(Context bosContext) {
        this(bosContext, false);
    }

    public Interpreter() {
        this(null, false);
    }

    public void setDefaultObject(Object obj) {
        this._defaultObject = obj;
    }

    public Object getDefaultObject() {
        return this._defaultObject;
    }

    public Object getBOSContext() {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getContext();
        }
        return null;
    }

    public void setBOSContext(Context ctx) {
        this.setBOSContext((Object)ctx);
    }

    public void setBOSContext(Object ctx) {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.setContext(ctx);
        }
    }

    public Class ClassForName(String typeName) {
        return TypeUtils.classForName(this.namespaces, this.classMap, typeName);
    }

    public synchronized Object evalForMultiPass(String text, Map context) throws InterpreterException, ParserException {
        KScriptParser parser;
        Object rtnValue = null;
        if (context == null) {
            context = new HashMap<Object, Object>();
        }
        if (!context.containsKey(BOS_CONTEXT_KEY) || context.get(BOS_CONTEXT_KEY) == null) {
            context.put(BOS_CONTEXT_KEY, this.getBOSContext());
        }
        if (this.tracer != null) {
            context.put(DEBUGGER, this.tracer);
        }
        if ((parser = (KScriptParser)this.codeDomCache.get(text)) == null) {
            parser = new KScriptParser(text, this.namespaces, this.classMap);
            parser.functionDeclMap = this.funcDeclMap;
            this.codeDomCache.put(text, parser);
        }
        parser.parse();
        IDebugTracer oldTracer = DebugFactory.setCurrentTracer(this.tracer);
        try {
            if (this.tracer != null) {
                this.tracer.evalEnter(this, parser.source, context);
            }
            this.source = parser.source;
            List stmtList = parser.stmtList;
            if (stmtList.size() == 1 && stmtList.get(0) instanceof ExprStmt) {
                CodeExpr expr = ((ExprStmt)stmtList.get((int)0)).expr;
                rtnValue = this.evalExprInternal(expr, context);
            } else {
                rtnValue = this.evalBlockStmtList(stmtList, context, true);
            }
            if (rtnValue == NoneReturnValue.NoneReturn) {
                rtnValue = null;
            }
            if (rtnValue instanceof PrimitiveValue) {
                rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
            }
            Object[] keyArray = context.keySet().toArray();
            for (int i = 0; i < keyArray.length; ++i) {
                Object val = context.get(keyArray[i]);
                if (!(val instanceof PrimitiveValue)) continue;
                val = ((PrimitiveValue)val).getBoxValue();
                context.put(keyArray[i], val);
            }
            if (this.tracer != null) {
                rtnValue = this.tracer.evalLeave(this, parser.source, context, rtnValue);
            }
        }
        catch (DebugStopException ex) {
            if (this.tracer != null) {
                this.tracer.evalLeave(this, parser.source, context, ex);
            }
            throw ex;
        }
        finally {
            DebugFactory.setCurrentTracer(oldTracer);
        }
        return rtnValue;
    }

    public Object eval(String text, Map context) throws InterpreterException, ParserException {
        return this.eval(text, context, true);
    }

    public synchronized Object eval(String text, Map context, boolean unboxValue) throws InterpreterException, ParserException {
        try {
            KScriptParser parser;
            text = Preprocessor.handler(text, context);
            Object rtnValue = null;
            if (context == null) {
                context = new HashMap<Object, Object>();
            }
            if (!context.containsKey(BOS_CONTEXT_KEY) || context.get(BOS_CONTEXT_KEY) == null) {
                context.put(BOS_CONTEXT_KEY, this.getBOSContext());
            }
            if (this.tracer != null) {
                context.put(DEBUGGER, this.tracer);
            }
            if ((parser = (KScriptParser)this.parseCache.get(text)) == null) {
                parser = new KScriptParser(text, this.namespaces, this.classMap);
                parser.functionDeclMap = this.funcDeclMap;
                parser.parse();
                this.parseCache.put(text, parser);
            }
            IDebugTracer oldTracer = DebugFactory.setCurrentTracer(this.tracer);
            try {
                if (this.tracer != null) {
                    this.tracer.evalEnter(this, parser.source, context);
                }
                List stmtList = parser.stmtList;
                this.source = parser.source;
                if (stmtList.size() == 1 && stmtList.get(0) instanceof ExprStmt) {
                    CodeExpr expr = ((ExprStmt)stmtList.get((int)0)).expr;
                    rtnValue = this.evalExprInternal(expr, context);
                } else {
                    rtnValue = this.evalBlockStmtList(stmtList, context, true);
                }
                if (rtnValue == NoneReturnValue.NoneReturn) {
                    rtnValue = null;
                }
                if (unboxValue) {
                    if (rtnValue instanceof PrimitiveValue) {
                        rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
                    }
                    Object[] keyArray = context.keySet().toArray();
                    for (int i = 0; i < keyArray.length; ++i) {
                        Object val = context.get(keyArray[i]);
                        if (!(val instanceof PrimitiveValue)) continue;
                        val = ((PrimitiveValue)val).getBoxValue();
                        context.put(keyArray[i], val);
                    }
                }
                if (this.tracer != null) {
                    rtnValue = this.tracer.evalLeave(this, parser.source, context, rtnValue);
                }
            }
            catch (DebugStopException ex) {
                if (this.tracer != null) {
                    this.tracer.evalLeave(this, parser.source, context, ex);
                }
                throw ex;
            }
            finally {
                DebugFactory.setCurrentTracer(oldTracer);
            }
            return rtnValue;
        }
        catch (InterpreterException ex) {
            throw ex;
        }
        catch (ParserException ex) {
            throw new ParserException(text, ex);
        }
    }

    private String getContext(Map context) {
        return "Context:=" + ToString.toString(context);
    }

    public synchronized Object evalTokenList(TokenList tokenList, Map context) throws InterpreterException, ParserException {
        Object rtnValue = null;
        if (context == null) {
            context = new HashMap<Object, Object>();
        }
        if (!context.containsKey(BOS_CONTEXT_KEY) || context.get(BOS_CONTEXT_KEY) == null) {
            context.put(BOS_CONTEXT_KEY, this.getBOSContext());
        }
        KScriptParser parser = new KScriptParser(tokenList, new ArrayList(), new HashMap());
        parser.parse();
        List stmtList = parser.stmtList;
        if (stmtList.size() == 1 && stmtList.get(0) instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmtList.get((int)0)).expr;
            rtnValue = this.evalExprInternal(expr, context);
        } else {
            rtnValue = this.evalBlockStmtList(stmtList, context, true);
        }
        if (rtnValue == NoneReturnValue.NoneReturn) {
            rtnValue = null;
        }
        if (rtnValue instanceof PrimitiveValue) {
            rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
        }
        Object[] keyArray = context.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            Object val = context.get(keyArray[i]);
            if (!(val instanceof PrimitiveValue)) continue;
            val = ((PrimitiveValue)val).getBoxValue();
            context.put(keyArray[i], val);
        }
        return rtnValue;
    }

    private Object evalBlockStmtList(List stmtList, Map context) throws InterpreterException {
        return this.evalBlockStmtList(stmtList, context, false);
    }

    /*
     * WARNING - void declaration
     */
    private Object evalBlockStmtList(List stmtList, Map context, boolean initVarFlag) throws InterpreterException {
        void var8_10;
        Object rtnValue = NoneReturnValue.NoneReturn;
        ArrayList<String> localVarList = new ArrayList<String>();
        HashMap replacedVarMap = new HashMap();
        for (CodeStmt codeStmt : stmtList) {
            if (codeStmt instanceof VarDeclStmt) {
                VarDeclStmt varDeclStmt = (VarDeclStmt)codeStmt;
                for (VarDeclItem varItem : varDeclStmt.varDeclList) {
                    if (localVarList.contains(varItem.name)) {
                        if (varItem.name.equals("__src") || varItem.name.equals("__desc")) continue;
                        throw (InterpreterException)new InterpreterException("local variant already declared. variant's name is '" + varItem.name + "'", codeStmt).setInfoId("LOCAL_VAR_ALREADY_DECLARED").addArg(varItem.name.toString()).addArg(codeStmt.toString()).setErrorLineCode(this.getSource());
                    }
                    localVarList.add(varItem.name);
                    if (context.containsKey(varItem.name)) {
                        replacedVarMap.put(varItem.name, context.get(varItem.name));
                    }
                    if (varItem.initExpr == null) {
                        if (initVarFlag) {
                            context.put(varItem.name, context.get(varItem.name));
                            continue;
                        }
                        context.put(varItem.name, null);
                        continue;
                    }
                    Object initValue = this.evalExprInternal(varItem.initExpr, context);
                    context.put(varItem.name, initValue);
                }
                continue;
            }
            rtnValue = this.evalStmt(codeStmt, context);
            if (rtnValue == NoneReturnValue.NoneReturn) continue;
            break;
        }
        boolean bl = false;
        while (var8_10 < localVarList.size()) {
            context.remove(localVarList.get((int)var8_10));
            ++var8_10;
        }
        for (Map.Entry entry : replacedVarMap.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        return rtnValue;
    }

    private Object evalStmt(CodeStmt stmt, Map context) throws InterpreterException {
        if (this.tracer != null) {
            this.tracer.evalCode(this, stmt, context);
        }
        if (stmt != null) {
            if (stmt instanceof ExprStmt) {
                ExprStmt exprStmt = (ExprStmt)stmt;
                this.evalExprInternal(exprStmt.expr, context);
            } else if (stmt instanceof ExprListStmt) {
                ExprListStmt exprListStmt = (ExprListStmt)stmt;
                for (CodeExpr expr : exprListStmt.exprList) {
                    this.evalExprInternal(expr, context);
                }
            } else {
                if (stmt instanceof ReturnStmt) {
                    ReturnStmt rtnStmt = (ReturnStmt)stmt;
                    Object rtnValue = this.evalExprInternal(rtnStmt.expr, context);
                    return rtnValue;
                }
                if (stmt instanceof BreakStmt) {
                    return NoneReturnValue.Break;
                }
                if (stmt instanceof ContinueStmt) {
                    return NoneReturnValue.Continue;
                }
                if (stmt instanceof IfStmt) {
                    IfStmt ifStmt = (IfStmt)stmt;
                    Object testValue = this.evalExprInternal(ifStmt.testExpr, context);
                    if (testValue instanceof PrimitiveValue) {
                        testValue = ((PrimitiveValue)testValue).getBoxValue();
                    }
                    boolean flag = false;
                    Object rtnValue = NoneReturnValue.NoneReturn;
                    if (testValue.equals(Boolean.TRUE)) {
                        rtnValue = this.evalBlockStmtList(ifStmt.trueStmtList, context);
                        flag = true;
                    } else {
                        for (ElseIfItem elseIf : ifStmt.elseIfList) {
                            testValue = this.evalExprInternal(elseIf.testExpr, context);
                            if (testValue instanceof PrimitiveValue) {
                                testValue = ((PrimitiveValue)testValue).getBoxValue();
                            }
                            if (!testValue.equals(Boolean.TRUE)) continue;
                            rtnValue = this.evalBlockStmtList(elseIf.stmtList, context);
                            flag = true;
                        }
                        if (!flag) {
                            rtnValue = this.evalBlockStmtList(ifStmt.elseStmtList, context);
                        }
                    }
                    return rtnValue;
                }
                if (stmt instanceof DoStmt) {
                    DoStmt doStmt = (DoStmt)stmt;
                    return this.evalDoStmt(doStmt, context);
                }
                if (stmt instanceof WhileStmt) {
                    WhileStmt whileStmt = (WhileStmt)stmt;
                    return this.evalWhileStmt(whileStmt, context);
                }
                if (stmt instanceof ForStmt) {
                    ForStmt forStmt = (ForStmt)stmt;
                    return this.evalForStmt(forStmt, context);
                }
                if (stmt instanceof SwitchStmt) {
                    SwitchStmt switchStmt = (SwitchStmt)stmt;
                    return this.evalSwitchStmt(switchStmt, context);
                }
                if (stmt instanceof BlockStmt) {
                    BlockStmt blockStmt = (BlockStmt)stmt;
                    return this.evalBlockStmtList(blockStmt.stmtList, context);
                }
                throw (InterpreterException)new InterpreterException("UNSUPPORT. stmt's class is : " + stmt.getClass().getName(), stmt).setInfoId(UNSUPPORTED_STATEMENT).addArg(stmt.getClass().getName()).addArg(stmt.toString()).setErrorLineCode(this.getSource());
            }
        }
        return NoneReturnValue.NoneReturn;
    }

    private Object evalSwitchStmt(SwitchStmt switchStmt, Map context) throws InterpreterException {
        Object testValue = this.evalExprInternal(switchStmt.testExpr, context);
        boolean flag = false;
        Iterator iter = switchStmt.caseItemList.iterator();
        Object rtnValue = NoneReturnValue.NoneReturn;
        while (iter.hasNext()) {
            AbstractCaseItem abstractCaseItem = (AbstractCaseItem)iter.next();
            if (flag) {
                rtnValue = this.evalBlockStmtList(abstractCaseItem.stmtList, context);
            } else if (abstractCaseItem instanceof CaseItem) {
                CaseItem caseItem = (CaseItem)abstractCaseItem;
                Object cmpValue = this.evalExprInternal(caseItem.valueExpr, context);
                if (testValue == cmpValue || testValue != null && testValue.equals(cmpValue) || TypeUtils.equal(testValue, cmpValue)) {
                    flag = true;
                    rtnValue = this.evalBlockStmtList(caseItem.stmtList, context);
                }
            }
            if (rtnValue == NoneReturnValue.NoneReturn) continue;
            if (rtnValue == NoneReturnValue.Continue) {
                throw (InterpreterException)new InterpreterException("Error. can't set Continue here", abstractCaseItem).setInfoId("CONTINUE_POS_ERROR").addArg(abstractCaseItem.toString()).setErrorLineCode(this.getSource());
            }
            if (rtnValue != NoneReturnValue.Break) break;
            rtnValue = null;
            break;
        }
        if (!flag && switchStmt.defaultCaseItem != null) {
            rtnValue = this.evalBlockStmtList(switchStmt.defaultCaseItem.stmtList, context);
        }
        if (rtnValue != NoneReturnValue.NoneReturn) {
            if (rtnValue == NoneReturnValue.Continue) {
                throw (InterpreterException)new InterpreterException("Error. can't set Continue here", switchStmt).setInfoId("CONTINUE_POS_ERROR").addArg(switchStmt.toString()).setErrorLineCode(this.getSource());
            }
            if (rtnValue == NoneReturnValue.Break) {
                rtnValue = null;
            }
        }
        return rtnValue;
    }

    private Object evalDoStmt(DoStmt doStmt, Map context) throws InterpreterException {
        Object testValue;
        if (doStmt.testExpr == null) {
            throw (InterpreterException)new InterpreterException("whileStmt's testExpr is null.", doStmt).setInfoId("WHILE_NO_CODITION_EX").addArg(doStmt.toString()).setErrorLineCode(this.getSource());
        }
        Object rtnValue = NoneReturnValue.NoneReturn;
        do {
            if ((rtnValue = this.evalBlockStmtList(doStmt.stmtList, context)) != NoneReturnValue.NoneReturn) {
                if (rtnValue == NoneReturnValue.Continue) {
                    rtnValue = NoneReturnValue.NoneReturn;
                } else {
                    if (rtnValue != NoneReturnValue.Break) break;
                    rtnValue = NoneReturnValue.NoneReturn;
                    break;
                }
            }
            if (!((testValue = this.evalExprInternal(doStmt.testExpr, context)) instanceof PrimitiveValue)) continue;
            testValue = ((PrimitiveValue)testValue).getBoxValue();
        } while (testValue.equals(Boolean.TRUE));
        return rtnValue;
    }

    private Object evalWhileStmt(WhileStmt whileStmt, Map context) throws InterpreterException {
        Object rtnValue;
        block4: {
            if (whileStmt.testExpr == null) {
                throw (InterpreterException)new InterpreterException("whileStmt's testExpr is null.", whileStmt).setInfoId("WHILE_NO_CODITION_EX").addArg(whileStmt.toString()).setErrorLineCode(this.getSource());
            }
            rtnValue = NoneReturnValue.NoneReturn;
            while (true) {
                Object testValue;
                if ((testValue = this.evalExprInternal(whileStmt.testExpr, context)) instanceof PrimitiveValue) {
                    testValue = ((PrimitiveValue)testValue).getBoxValue();
                }
                if (!testValue.equals(Boolean.TRUE)) break block4;
                rtnValue = this.evalBlockStmtList(whileStmt.stmtList, context);
                if (rtnValue == NoneReturnValue.NoneReturn) continue;
                if (rtnValue != NoneReturnValue.Continue) break;
                rtnValue = NoneReturnValue.NoneReturn;
            }
            if (rtnValue == NoneReturnValue.Break) {
                rtnValue = NoneReturnValue.NoneReturn;
            }
        }
        return rtnValue;
    }

    private Object evalForStmt(ForStmt forStmt, Map context) throws InterpreterException {
        ArrayList<String> localVarList = new ArrayList<String>();
        HashMap replacedVarMap = new HashMap();
        if (forStmt.initStmt instanceof VarDeclStmt) {
            VarDeclStmt varDeclStmt = (VarDeclStmt)forStmt.initStmt;
            for (VarDeclItem varItem : varDeclStmt.varDeclList) {
                localVarList.add(varItem.name);
                if (context.containsKey(varItem.name)) {
                    replacedVarMap.put(varItem.name, context.get(varItem.name));
                }
                if (varItem.initExpr == null) {
                    context.put(varItem.name, null);
                    continue;
                }
                Object initValue = this.evalExprInternal(varItem.initExpr, context);
                context.put(varItem.name, initValue);
            }
        } else {
            this.evalStmt(forStmt.initStmt, context);
        }
        Object rtnValue = NoneReturnValue.NoneReturn;
        while (true) {
            Object testValue;
            if ((testValue = this.evalExprInternal(forStmt.testExpr, context)) instanceof PrimitiveValue) {
                testValue = ((PrimitiveValue)testValue).getBoxValue();
            }
            if (!testValue.equals(Boolean.TRUE)) break;
            rtnValue = this.evalBlockStmtList(forStmt.stmtList, context);
            if (rtnValue != NoneReturnValue.NoneReturn) {
                if (rtnValue == NoneReturnValue.Continue) {
                    rtnValue = NoneReturnValue.NoneReturn;
                } else {
                    if (rtnValue != NoneReturnValue.Break) break;
                    rtnValue = NoneReturnValue.NoneReturn;
                    break;
                }
            }
            if (forStmt.incrementStmt instanceof ExprStmt) {
                ExprStmt exprStmt = (ExprStmt)forStmt.incrementStmt;
                if (exprStmt.expr == null) continue;
            }
            this.evalStmt(forStmt.incrementStmt, context);
        }
        for (int i = 0; i < localVarList.size(); ++i) {
            context.remove(localVarList.get(i));
        }
        for (Map.Entry entry : replacedVarMap.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        return rtnValue;
    }

    public synchronized Object evalExpr(String text, Map context) throws InterpreterException, ParserException {
        if (context == null) {
            context = new HashMap<Object, Object>();
        }
        if (!context.containsKey(BOS_CONTEXT_KEY) || context.get(BOS_CONTEXT_KEY) == null) {
            context.put(BOS_CONTEXT_KEY, this.getBOSContext());
        }
        if (this.tracer != null) {
            context.put(DEBUGGER, this.tracer);
        }
        Object rtnValue = null;
        Source source = new Source(text);
        IDebugTracer oldTracer = DebugFactory.setCurrentTracer(this.tracer);
        try {
            if (this.tracer != null) {
                this.tracer.evalEnter(this, source, context);
            }
            if ((rtnValue = this.evalExprInternal(source, context)) instanceof PrimitiveValue) {
                rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
            }
            Object[] keyArray = context.keySet().toArray();
            for (int i = 0; i < keyArray.length; ++i) {
                Object val = context.get(keyArray[i]);
                if (!(val instanceof PrimitiveValue)) continue;
                val = ((PrimitiveValue)val).getBoxValue();
                context.put(keyArray[i], val);
            }
            if (rtnValue instanceof NoneReturnValue) {
                rtnValue = null;
            }
            if (this.tracer != null) {
                rtnValue = this.tracer.evalLeave(this, source, context, rtnValue);
            }
        }
        catch (DebugStopException ex) {
            if (this.tracer != null) {
                this.tracer.evalLeave(this, source, context, ex);
            }
            throw ex;
        }
        finally {
            DebugFactory.setCurrentTracer(oldTracer);
        }
        return rtnValue;
    }

    public synchronized Object evalExpr(CodeExpr expr, Map context) throws InterpreterException {
        Object rtnValue;
        if (context == null) {
            context = new HashMap<Object, Object>();
        }
        if (!context.containsKey(BOS_CONTEXT_KEY) || context.get(BOS_CONTEXT_KEY) == null) {
            context.put(BOS_CONTEXT_KEY, this.getBOSContext());
        }
        if ((rtnValue = this.evalExprInternal(expr, context)) instanceof PrimitiveValue) {
            rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
        }
        Object[] keyArray = context.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            Object val = context.get(keyArray[i]);
            if (!(val instanceof PrimitiveValue)) continue;
            val = ((PrimitiveValue)val).getBoxValue();
            context.put(keyArray[i], val);
        }
        if (rtnValue instanceof NoneReturnValue) {
            return null;
        }
        return rtnValue;
    }

    private Object evalExprInternal(Source source, Map context) throws InterpreterException, ParserException {
        Lexer lexer = new Lexer(source);
        TokenList tokList = new TokenList(lexer);
        ExprParser parser = new ExprParser(tokList, this.namespaces, this.classMap);
        ArrayList exprList = new ArrayList();
        parser.exprList(exprList);
        Object rtnValue = null;
        for (int i = 0; i < exprList.size(); ++i) {
            CodeExpr expr = (CodeExpr)exprList.get(i);
            this.typeCheck(expr, context);
            rtnValue = this.evalExprInternal(expr, context);
        }
        return rtnValue;
    }

    private void typeCheck(CodeExpr expr, Map context) {
        Class exprClass = expr.getExprClass();
        if (exprClass != null) {
            return;
        }
        if (expr instanceof IdentifierExpr) {
            IdentifierExpr identExpr = (IdentifierExpr)expr;
            Object identObj = context.get(identExpr.value);
            if (identObj != null) {
                identExpr.setExprClass(identObj.getClass());
            }
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            this.typeCheck(binaryOpExpr.left, context);
            this.typeCheck(binaryOpExpr.right, context);
            if (binaryOpExpr.operator == 7 || binaryOpExpr.operator == 8 || binaryOpExpr.operator == 10 || binaryOpExpr.operator == 23 || binaryOpExpr.operator == 11 || binaryOpExpr.operator == 12 || binaryOpExpr.operator == 14 || binaryOpExpr.operator == 15) {
                binaryOpExpr.setExprClass(Boolean.TYPE);
                return;
            }
            Class leftClass = binaryOpExpr.left.getExprClass();
            Class rightClass = binaryOpExpr.right.getExprClass();
            if (leftClass != null && rightClass != null) {
                int leftNumber = this.getClassIdentNumber(leftClass);
                int rightNumber = this.getClassIdentNumber(rightClass);
                if (rightNumber > leftNumber) {
                    binaryOpExpr.setExprClass(rightClass);
                } else {
                    binaryOpExpr.setExprClass(leftClass);
                }
            }
        } else if (expr instanceof ConditionExpr) {
            ConditionExpr conditionExpr = (ConditionExpr)expr;
            if (conditionExpr.testExpr.getExprClass() != null) {
                conditionExpr.testExpr.setExprClass(Boolean.TYPE);
            }
            this.typeCheck(conditionExpr.trueExpr, context);
            this.typeCheck(conditionExpr.falseExpr, context);
            Class leftClass = conditionExpr.trueExpr.getExprClass();
            Class rightClass = conditionExpr.falseExpr.getExprClass();
            if (leftClass != null && rightClass != null) {
                int leftNumber = this.getClassIdentNumber(leftClass);
                int rightNumber = this.getClassIdentNumber(rightClass);
                if (rightNumber > leftNumber) {
                    conditionExpr.setExprClass(rightClass);
                } else {
                    conditionExpr.setExprClass(leftClass);
                }
            }
        }
    }

    private int getClassIdentNumber(Class exprClass) {
        if (exprClass.equals(Byte.TYPE)) {
            return 1;
        }
        if (exprClass.equals(Byte.TYPE)) {
            return -1;
        }
        if (exprClass.equals(Short.TYPE)) {
            return 2;
        }
        if (exprClass.equals(Short.TYPE)) {
            return -2;
        }
        if (exprClass.equals(Integer.TYPE)) {
            return 3;
        }
        if (exprClass.equals(Integer.TYPE)) {
            return -3;
        }
        if (exprClass.equals(Long.TYPE)) {
            return 4;
        }
        if (exprClass.equals(Long.TYPE)) {
            return -4;
        }
        if (exprClass.equals(Float.TYPE)) {
            return 5;
        }
        if (exprClass.equals(Float.TYPE)) {
            return -5;
        }
        if (exprClass.equals(Double.TYPE)) {
            return 6;
        }
        if (exprClass.equals(Double.TYPE)) {
            return -6;
        }
        if (exprClass.equals(String.class)) {
            return 10;
        }
        return 0;
    }

    private Object evalExprInternal(CodeExpr expr, Map context) throws InterpreterException {
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        if (this.tracer != null) {
            this.tracer.evalCode(this, expr, context);
        }
        try {
            Object rtnValue = null;
            if (expr instanceof BinaryOpExpr) {
                try {
                    rtnValue = this.evalBinaryOpExpr((BinaryOpExpr)expr, context);
                }
                catch (Exception ex) {
                    if (ex instanceof InterpreterException) {
                        throw ex;
                    }
                    this.doEvalOPError(ex, ((BinaryOpExpr)expr).operator, (BinaryOpExpr)expr);
                }
            } else if (expr instanceof IdentifierExpr) {
                rtnValue = this.evalIndentExpr((IdentifierExpr)expr, context);
            } else if (expr instanceof ConditionExpr) {
                rtnValue = this.evalConditionExpr((ConditionExpr)expr, context);
            } else if (expr instanceof PropertyExpr) {
                rtnValue = this.evalPropExpr((PropertyExpr)expr, context);
            } else if (expr instanceof MethodInvokeExpr) {
                rtnValue = this.evalMethodInvokeExpr((MethodInvokeExpr)expr, context);
            } else if (expr instanceof ObjectCreateExpr) {
                rtnValue = this.evalObjectCreateExpr((ObjectCreateExpr)expr, context);
            } else if (expr instanceof BoolExpr) {
                rtnValue = ((BoolExpr)expr).val ? PrimitiveBoolean.TRUE : PrimitiveBoolean.FALSE;
            } else if (expr instanceof CharExpr) {
                rtnValue = new PrimitiveCharacter(((CharExpr)expr).val);
            } else if (expr instanceof NullExpr) {
                rtnValue = null;
            } else if (expr instanceof IntExpr) {
                rtnValue = new PrimitiveInt(((IntExpr)expr).intValue());
            } else if (expr instanceof LongExpr) {
                rtnValue = new PrimitiveLong(((LongExpr)expr).longValue());
            } else {
                if (expr instanceof FloatExpr) {
                    return new PrimitiveFloat(((FloatExpr)expr).floatValue());
                }
                if (expr instanceof DoubleExpr) {
                    return new PrimitiveDouble(((DoubleExpr)expr).doubleValue());
                }
                if (expr instanceof BigDecimalExpr) {
                    return ((BigDecimalExpr)expr).value;
                }
                if (expr instanceof StringExpr) {
                    rtnValue = ((StringExpr)expr).getJavaString();
                } else if (expr instanceof UnaryExpr) {
                    rtnValue = this.evalUnaryExpr((UnaryExpr)expr, context);
                } else if (expr instanceof ArrayIndexerExpr) {
                    rtnValue = this.evalArrayIndexerExpr((ArrayIndexerExpr)expr, context);
                } else if (expr instanceof VectorCreateExpr) {
                    rtnValue = this.evalVectorCreateExpr((VectorCreateExpr)expr, context);
                } else if (expr instanceof LambdaExpr) {
                    rtnValue = this.evalLambdaExpr((LambdaExpr)expr, context);
                } else if (expr instanceof NewFunctionExpr) {
                    rtnValue = this.evalNewFuncExpr((NewFunctionExpr)expr, context);
                } else {
                    throw (InterpreterException)new InterpreterException("UNSUPPORT, expr class : " + expr.getClass().getName(), expr).setInfoId(UNSUPPORTED_STATEMENT).addArg(expr.getClass().getName()).addArg(expr.toString()).setErrorLineCode(this.getSource());
                }
            }
            return rtnValue;
        }
        catch (Throwable ex) {
            if (ex instanceof DebugStopException) {
                throw (DebugStopException)ex;
            }
            if (this.tracer != null) {
                this.tracer.evalError(this, expr, context, ex);
            }
            if (ex instanceof InterpreterException) {
                if (((InterpreterException)ex).getErrorLineNum() == 0 && expr != null && expr.position != null) {
                    ((InterpreterException)ex).setErrorLineNum(expr.position.beginLine);
                    ((InterpreterException)ex).setErrorLineCode(this.getSource());
                }
                throw (InterpreterException)ex;
            }
            throw (InterpreterException)new InterpreterException(ex.toString(), expr, ex).setErrorLineCode(this.getSource());
        }
    }

    private FunctionObject evalNewFuncExpr(NewFunctionExpr expr, Map context) {
        return new FunctionObject(expr, context);
    }

    private LambdaObject evalLambdaExpr(LambdaExpr expr, Map context) {
        LambdaObject rtnObj = new LambdaObject();
        rtnObj.lambdaExpr = expr;
        for (Map.Entry entry : context.entrySet()) {
            rtnObj.context.put(entry.getKey(), entry.getValue());
        }
        return rtnObj;
    }

    private Object evalVectorCreateExpr(VectorCreateExpr expr, Map context) throws InterpreterException {
        ArrayList<Object> rtnValue = new ArrayList<Object>();
        for (CodeExpr pramExpr : expr.paramList) {
            Object pramVal = this.evalExprInternal(pramExpr, context);
            rtnValue.add(pramVal);
        }
        return rtnValue;
    }

    private Object evalArrayIndexerExpr(ArrayIndexerExpr expr, Map context) throws InterpreterException {
        Object targetObj = this.evalExprInternal(expr.targetObjExpr, context);
        Object indexerObj = this.evalExprInternal(expr.indexExpr, context);
        int index = ((Number)indexerObj).intValue();
        if (targetObj.getClass().isArray()) {
            return Array.get(targetObj, index);
        }
        if (targetObj instanceof List) {
            return ((List)targetObj).get(index);
        }
        if (this.isObjectCollection(targetObj)) {
            return this.getObjectCollectionChildByIndex(targetObj, index);
        }
        throw (InterpreterException)new InterpreterException("assign to array error. target must be array or list or IObjectCollection", expr).setInfoId("INDEX_EXPR_ERROR").addArg(expr.toString()).addArg(targetObj.toString()).addArg(targetObj.getClass().getName()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
    }

    private Object evalUnaryExpr(UnaryExpr unaryExpr, Map context) throws InterpreterException {
        if (unaryExpr.operator == 1) {
            return this.evalExprInternal(unaryExpr.expr, context);
        }
        if (unaryExpr.operator == 3) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            rtnValue = TypeUtils.add(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException(ERROR_MSG_NOTFOUND_IDENTIFIER, identExpr).setInfoId("SELFIncrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException(ERROR_MSG_EXP_ISNOT_IDENTIFIER, unaryExpr.expr).setInfoId("SELFIncrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, rtnValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 4) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            Object postValue = TypeUtils.add(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException(ERROR_MSG_NOTFOUND_IDENTIFIER, identExpr).setInfoId("SELFIncrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException(ERROR_MSG_EXP_ISNOT_IDENTIFIER, unaryExpr.expr).setInfoId("SELFIncrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, postValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 5) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            rtnValue = TypeUtils.sub(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException(ERROR_MSG_NOTFOUND_IDENTIFIER, identExpr).setInfoId("SELFDecrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException(ERROR_MSG_EXP_ISNOT_IDENTIFIER, unaryExpr.expr).setInfoId("SELFDecrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, rtnValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 6) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            Object postValue = TypeUtils.sub(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException(ERROR_MSG_NOTFOUND_IDENTIFIER, identExpr).setInfoId("SELFDecrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException(ERROR_MSG_EXP_ISNOT_IDENTIFIER, unaryExpr.expr).setInfoId("SELFDecrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, postValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 7) {
            Object exprVal = this.evalExprInternal(unaryExpr.expr, context);
            if (exprVal instanceof Number) {
                return new PrimitiveInt(~((Number)exprVal).intValue());
            }
            throw (InterpreterException)new InterpreterException("Systax Err. operator ~ only use for integer.", unaryExpr.expr).setInfoId("Tilde_EXPR_ERROR").addArg(unaryExpr.toString()).addArg(exprVal.toString()).addArg(exprVal.getClass().getName()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        if (unaryExpr.operator == 0) {
            Object tempValue = this.evalExprInternal(unaryExpr.expr, context);
            if (tempValue instanceof Boolean) {
                return (Boolean)tempValue != false ? PrimitiveBoolean.FALSE : PrimitiveBoolean.TRUE;
            }
            if (tempValue instanceof PrimitiveBoolean) {
                return ((PrimitiveBoolean)tempValue).getValue() ? PrimitiveBoolean.FALSE : PrimitiveBoolean.TRUE;
            }
            throw (InterpreterException)new InterpreterException("Systax Err. operator ~ only use for integer.", unaryExpr.expr).setInfoId("Not_EXPR_ERROR").addArg(unaryExpr.toString()).addArg(tempValue.toString()).addArg(tempValue.getClass().getName()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        throw (InterpreterException)new InterpreterException("UNSUPPORT", unaryExpr).setInfoId(UNSUPPORTED_STATEMENT).addArg(unaryExpr.getExprClass().getName()).addArg(unaryExpr.toString()).setErrorLineCode(this.getSource());
    }

    private Object evalArrayCreate(ObjectCreateExpr expr, Map context) throws InterpreterException {
        int arrayLength;
        char ch;
        String typeName = expr.objType;
        Class arrayType = TypeUtils.classForName(this.namespaces, this.classMap, typeName);
        if (arrayType == null) {
            throw (InterpreterException)new InterpreterException("ClassNotFoundException, " + typeName, expr).setInfoId("ARRAY_CREATE_NO_CLS").addArg(expr.toString()).addArg(typeName).setErrorLineCode(this.getSource());
        }
        Class<?> componentType = arrayType.getComponentType();
        int dim = 0;
        for (int i = 0; i < typeName.length() && (ch = typeName.charAt(i)) == '['; ++i) {
            ++dim;
        }
        if (dim > 1) {
            throw new InterpreterException("TODO", expr);
        }
        if (expr.paramList.size() == 0) {
            arrayLength = expr.initExprList.size();
        } else {
            CodeExpr pramExpr = (CodeExpr)expr.paramList.get(0);
            Object pramValue = this.evalExprInternal(pramExpr, context);
            if (pramValue instanceof PrimitiveValue) {
                pramValue = ((PrimitiveValue)pramValue).getBoxValue();
            }
            arrayLength = ((Number)pramValue).intValue();
        }
        Object rtnValue = Array.newInstance(componentType, arrayLength);
        for (int i = 0; i < expr.initExprList.size(); ++i) {
            CodeExpr itemExpr = (CodeExpr)expr.initExprList.get(i);
            Object itemValue = this.evalExprInternal(itemExpr, context);
            if (itemValue instanceof PrimitiveValue) {
                itemValue = ((PrimitiveValue)itemValue).getBoxValue();
            }
            Array.set(rtnValue, i, itemValue);
        }
        return rtnValue;
    }

    private Object evalObjectCreateExpr(ObjectCreateExpr expr, Map context) throws InterpreterException {
        Object rtnValue;
        String typeName = expr.objType;
        if (typeName.startsWith("[")) {
            return this.evalArrayCreate(expr, context);
        }
        Class type = TypeUtils.classForName(this.namespaces, this.classMap, typeName);
        if (type == null) {
            throw (InterpreterException)new InterpreterException("ClassNotFoundException, " + typeName, expr).setInfoId("OBJECT_CREATE_NO_CLS").addArg(expr.toString()).addArg(typeName).setErrorLineCode(this.getSource());
        }
        Object[] pramValueArray = new Object[expr.paramList.size()];
        Class[] pramClassArray = new Class[pramValueArray.length];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal((CodeExpr)expr.paramList.get(i), context);
            if (pramValueArray[i] instanceof PrimitiveValue) {
                pramClassArray[i] = ((PrimitiveValue)pramValueArray[i]).getUnBoxType();
                pramValueArray[i] = ((PrimitiveValue)pramValueArray[i]).getBoxValue();
                continue;
            }
            pramClassArray[i] = pramValueArray[i].getClass();
        }
        Constructor constructor = null;
        constructor = ReflectionUtils.getConstructor(type, pramClassArray);
        if (constructor == null) {
            throw (InterpreterException)new InterpreterException("not match constructor. " + type.getName(), expr).setInfoId("OBJECT_CREATE_NO_CONSTRUCTOR").addArg(expr.toString()).addArg(type.getName()).setErrorLineCode(this.getSource());
        }
        try {
            rtnValue = constructor.newInstance(pramValueArray);
        }
        catch (Exception e2) {
            throw (InterpreterException)new InterpreterException("object new instance error", e2).setInfoId("OBJECT_construct_error").addArg(expr.toString()).addArg(constructor.getName()).addArg(e2.getMessage()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        return rtnValue;
    }

    private boolean isInternalFunction(MethodInvokeExpr methodInvokeExpr) {
        CodeExpr ownerExpr = methodInvokeExpr.owner;
        String methodName = methodInvokeExpr.methodName;
        String ownerStr = null;
        if (ownerExpr instanceof IdentifierExpr) {
            ownerStr = ((IdentifierExpr)ownerExpr).value;
        }
        if (ownerStr == null) {
            return internalFunctionList.contains(methodName);
        }
        return ownerStr.equals("Math") && methodName.endsWith("abs");
    }

    private Object evalInternalFunction(MethodInvokeExpr methodInvokeExpr, Map context) throws InterpreterException {
        String methodName = methodInvokeExpr.methodName;
        if (methodName.equals("eval")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            if (pramExpr instanceof StringExpr) {
                String pramExprStr = ((StringExpr)pramExpr).text;
                try {
                    return this.eval(pramExprStr, context);
                }
                catch (ParserException e) {
                    throw (InterpreterException)new InterpreterException("Sytax Error.", pramExpr, e).setInfoId("PARSE_ERROR").addArg(pramExpr.toString()).addArg(e.getMessage()).setErrorLineCode(this.getSource());
                }
            }
            throw (InterpreterException)new InterpreterException("Sytax Error. expression must be a String", pramExpr).setInfoId("EVAL_PARAM_NOT_STRING").addArg(methodInvokeExpr.toString()).addArg(pramExpr == null ? "null" : pramExpr.toString()).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("abs")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram != null && pram instanceof Number) {
                Number num = (Number)pram;
                if (num.doubleValue() >= 0.0) {
                    return num;
                }
                return TypeUtils.multi(num, -1);
            }
            throw (InterpreterException)new InterpreterException("abs's parameter must be Number, but it is" + pram, methodInvokeExpr).setInfoId("ABS_PARAM_NOT_NUM").addArg(methodInvokeExpr.toString()).addArg(pram == null ? "null" : pram.toString()).addArg(pram == null ? "null" : pram.getClass().getName()).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("len")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram instanceof Collection) {
                return new PrimitiveInt(((Collection)pram).size());
            }
            if (pram.getClass().isArray()) {
                return new PrimitiveInt(Array.getLength(pram));
            }
            if (pram instanceof String) {
                return new PrimitiveInt(((String)pram).length());
            }
            throw (InterpreterException)new InterpreterException("len function err. parameter type not support. it should be a collection or array or String, but find" + pram.getClass().getName(), methodInvokeExpr).setInfoId("LEN_PARAM_NOT_SUIT").addArg(methodInvokeExpr.toString()).addArg(pram.toString()).addArg(pram.getClass().getName()).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("newid")) {
            return Uuid.create();
        }
        if (methodName.equals("parseInt")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram instanceof String) {
                return new PrimitiveInt(Integer.parseInt((String)pram));
            }
            if (pram instanceof Number) {
                return new PrimitiveInt(((Number)pram).intValue());
            }
            return new PrimitiveInt(Integer.parseInt(pram.toString()));
        }
        if (methodName.equals("parseFloat")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram instanceof String) {
                return new PrimitiveFloat(Float.parseFloat((String)pram));
            }
            if (pram instanceof Number) {
                return new PrimitiveFloat(((Number)pram).floatValue());
            }
            return new PrimitiveFloat(Float.parseFloat(pram.toString()));
        }
        if (methodName.equals("print")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (this.tracer != null) {
                this.tracer.print(pram);
            }
            return NoneReturnValue.NoneReturn;
        }
        if (methodName.equals("println")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (this.tracer != null) {
                this.tracer.println(pram);
            }
            return NoneReturnValue.NoneReturn;
        }
        if (methodName.equals("Set")) {
            HashSet<Object> set = new HashSet<Object>();
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                Object pram = this.evalExprInternal(pramExpr, context);
                set.add(pram);
            }
            return set;
        }
        if (methodName.equals("List")) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                Object pram = this.evalExprInternal(pramExpr, context);
                list.add(pram);
            }
            return list;
        }
        if (methodName.equalsIgnoreCase("sum")) {
            return this.evalIMSum(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("first")) {
            return this.evalIMFirst(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("last")) {
            return this.evalIMLast(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("all")) {
            return this.evalIMAll(methodInvokeExpr, context, null);
        }
        if (methodName.equals("uniqueAll")) {
            return this.evalIMUniqueAll(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("getByIndex")) {
            return this.evalIMGetByIndex(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("avg")) {
            return this.evalIMAvg(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("count")) {
            return this.evalIMCount(methodInvokeExpr, context, null);
        }
        if (methodName.equals("max")) {
            return this.evalIMMax(methodInvokeExpr, context, null);
        }
        if (methodName.equals("min")) {
            return this.evalIMMin(methodInvokeExpr, context, null);
        }
        if (methodName.startsWith("conditional_")) {
            CodeExpr connExpr;
            if (methodInvokeExpr.paramList.size() < 2) {
                throw (InterpreterException)new InterpreterException("syntax error 'conditional_sum', there must be 2 parameters", methodInvokeExpr).setErrorLineCode(this.getSource());
            }
            CodeExpr connStrExpr = (CodeExpr)methodInvokeExpr.paramList.remove(methodInvokeExpr.paramList.size() - 1);
            if (!(connStrExpr instanceof StringExpr)) {
                throw new TODOException(CONDITIONAL_SUM);
            }
            String connStr = ((StringExpr)connStrExpr).text;
            try {
                ExprParser parser = new ExprParser(connStr);
                connExpr = parser.expr();
            }
            catch (ParserException e) {
                throw (InterpreterException)new InterpreterException("syntax error 'conditional_sum'", connStrExpr, e).setInfoId("PARSE_ERROR").addArg(connStrExpr.toString()).addArg(e.toString()).setErrorLineCode(this.getSource());
            }
            if (methodName.equalsIgnoreCase(CONDITIONAL_SUM)) {
                return this.evalIMSum(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_avg")) {
                return this.evalIMAvg(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_max")) {
                return this.evalIMMax(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_min")) {
                return this.evalIMMin(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_count")) {
                return this.evalIMCount(methodInvokeExpr, context, connExpr);
            }
            throw (InterpreterException)new InterpreterException("method name must be 'conditional_sum' or 'conditional_avg' or 'conditional_max' or 'conditional_min' or 'conditional_count'", connStrExpr).setErrorLineCode(this.getSource());
        }
        throw new InterpreterException("UNSUPPORT, unkonw method.methodName is" + methodName, methodInvokeExpr);
    }

    private List fetchElements(CodeExpr paramExpr, Map context, CodeExpr criteria) throws InterpreterException {
        Interpreter botInter = criteria == null ? null : new Interpreter();
        ArrayList<Object> list = new ArrayList<Object>();
        if (paramExpr instanceof PropertyExpr) {
            PropertyExpr propExpr = (PropertyExpr)paramExpr;
            Object param = this.evalExprInternal(propExpr.owner, context);
            if (KScriptUtil.isCollection(param)) {
                Iterator valIter = KScriptUtil.getIterator(param);
                while (valIter.hasNext()) {
                    Object owner = valIter.next();
                    Object value = this.getProperty(owner, propExpr.propName);
                    if (value == null) continue;
                    if (botInter != null) {
                        context.put(KS_COLLECT_OWNER, owner);
                        context.put(KS_COLLECT_VALUE, value);
                        Object cond = botInter.evalExpr(criteria, context);
                        if (!Boolean.TRUE.equals(cond)) continue;
                        list.add(value);
                        continue;
                    }
                    list.add(value);
                }
            } else {
                Object owner = param;
                param = this.getProperty(param, propExpr.propName);
                Iterator valIter = KScriptUtil.getIterator(param);
                while (valIter.hasNext()) {
                    Object value = valIter.next();
                    if (value == null) continue;
                    if (botInter != null) {
                        context.put(KS_COLLECT_VALUE, value);
                        context.put(KS_COLLECT_OWNER, owner);
                        Object cond = botInter.evalExpr(criteria, context);
                        if (!Boolean.TRUE.equals(cond)) continue;
                        list.add(value);
                        continue;
                    }
                    list.add(value);
                }
            }
        } else {
            Object param = this.evalExprInternal(paramExpr, context);
            Iterator valIter = KScriptUtil.getIterator(param);
            while (valIter.hasNext()) {
                Object value = valIter.next();
                if (value == null) continue;
                if (botInter != null) {
                    context.put(KS_COLLECT_VALUE, value);
                    Object cond = botInter.evalExpr(criteria, context);
                    if (!Boolean.TRUE.equals(cond)) continue;
                    list.add(value);
                    continue;
                }
                list.add(value);
            }
        }
        return list;
    }

    private List fetchAllElements(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria, int minSize) throws InterpreterException {
        ArrayList list = new ArrayList();
        for (CodeExpr expr : methodInvokeExpr.paramList) {
            list.addAll(this.fetchElements(expr, context, criteria));
            if (minSize <= 0 || list.size() < minSize) continue;
            break;
        }
        return list;
    }

    public void split(CodeExpr expr, List exprList) {
        if (expr == null) {
            return;
        }
        if (expr instanceof PropertyExpr) {
            PropertyExpr propExpr = (PropertyExpr)expr;
            exprList.add(0, propExpr.propName);
            this.split(propExpr.owner, exprList);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            StringBuffer buff = new StringBuffer();
            buff.append(methodInvokeExpr.methodName);
            buff.append("(");
            int i = 0;
            Iterator iter = methodInvokeExpr.paramList.iterator();
            while (iter.hasNext()) {
                if (i != 0) {
                    buff.append(", ");
                }
                CodeExpr pramExpr = (CodeExpr)iter.next();
                pramExpr.output(buff);
                ++i;
            }
            buff.append(")");
            exprList.add(0, buff.toString());
            this.split(methodInvokeExpr.owner, exprList);
        } else if (expr instanceof IdentifierExpr) {
            exprList.add(0, expr.toString());
        } else {
            throw new TODOException();
        }
    }

    private Object evalIMSum(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object sumVal = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            sumVal = TypeUtils.add(sumVal, list.get(i));
        }
        return sumVal;
    }

    private Object evalIMAppend(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return null;
        }
        Object appendVal = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            appendVal = TypeUtils.add(appendVal, list.get(i));
        }
        return appendVal;
    }

    private Object evalFunction(Function funcObj, MethodInvokeExpr methodInvokeExpr, Map context) throws InterpreterException {
        long t = System.currentTimeMillis();
        ArrayList<String> localVarList = new ArrayList<String>();
        HashMap replacedVarMap = new HashMap();
        for (int i = 0; i < funcObj.paramList.size(); ++i) {
            Object pramValue;
            String pram = (String)funcObj.paramList.get(i);
            localVarList.add(pram);
            if (i < methodInvokeExpr.paramList.size()) {
                CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(i);
                pramValue = this.evalExprInternal(pramExpr, context);
            } else {
                pramValue = null;
            }
            if (context.containsKey(pram)) {
                replacedVarMap.put(pram, context.get(pram));
            }
            context.put(pram, pramValue);
        }
        if (this.tracer != null) {
            this.tracer.evalFuncEnter(this, funcObj, methodInvokeExpr, context);
        }
        Object rtnValue = this.evalBlockStmtList(funcObj.stmtList, context);
        for (int i = 0; i < localVarList.size(); ++i) {
            context.remove(localVarList.get(i));
        }
        for (Map.Entry entry : replacedVarMap.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        log.debug((Object)(EVALFUNCTION + funcObj.name + ", MethodName:" + methodInvokeExpr.methodName + COST + (System.currentTimeMillis() - t)));
        if (this.tracer != null) {
            rtnValue = this.tracer.evalFuncLeave(this, funcObj, methodInvokeExpr, context, rtnValue);
        }
        return rtnValue;
    }

    private Object evalFunctionObject(FunctionObject funcObjc, MethodInvokeExpr methodInvokeExpr, Map context) throws InterpreterException {
        HashMap<String, Object> evalContext = new HashMap<String, Object>(funcObjc.context);
        Object[] pramValueArray = new Object[methodInvokeExpr.paramList.size()];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal((CodeExpr)methodInvokeExpr.paramList.get(i), context);
            String argName = (String)funcObjc.functionExpr.function.paramList.get(i);
            evalContext.put(argName, pramValueArray[i]);
        }
        Object rtnValue = this.evalFunction(funcObjc.functionExpr.function, methodInvokeExpr, evalContext);
        return rtnValue;
    }

    private Object evalLambdaObject(LambdaObject lambdaObj, MethodInvokeExpr methodInvokeExpr, Map context) throws InterpreterException {
        HashMap<String, Object> evalContext = new HashMap<String, Object>(lambdaObj.context);
        Object[] pramValueArray = new Object[methodInvokeExpr.paramList.size()];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal((CodeExpr)methodInvokeExpr.paramList.get(i), context);
            String argName = (String)lambdaObj.lambdaExpr.paramList.get(i);
            evalContext.put(argName, pramValueArray[i]);
        }
        Object rtnValue = this.evalExprInternal(lambdaObj.lambdaExpr.expr, evalContext);
        return rtnValue;
    }

    private Object evalMethodInvokeExpr(MethodInvokeExpr methodInvokeExpr, Map context) throws InterpreterException {
        if (this.isInternalFunction(methodInvokeExpr)) {
            HashMap tempCont = new HashMap();
            tempCont.putAll(context);
            return this.evalInternalFunction(methodInvokeExpr, tempCont);
        }
        long t = System.currentTimeMillis();
        Object ownerValue = null;
        if (methodInvokeExpr.owner != null) {
            if (methodInvokeExpr.owner instanceof PropertyExpr) {
                String ownerExprStr = methodInvokeExpr.owner.toString();
                ownerValue = TypeUtils.classForName(this.namespaces, this.classMap, ownerExprStr);
            }
            if (ownerValue == null) {
                ownerValue = this.evalExprInternal(methodInvokeExpr.owner, context);
            }
        }
        if (ownerValue == null) {
            Function funcObj = (Function)this.funcDeclMap.get(methodInvokeExpr.methodName);
            if (funcObj != null) {
                return this.evalFunction(funcObj, methodInvokeExpr, context);
            }
            Object contextVal = context.get(methodInvokeExpr.methodName);
            Object returnObj = null;
            if (contextVal instanceof LambdaObject) {
                returnObj = this.evalLambdaObject((LambdaObject)contextVal, methodInvokeExpr, context);
            } else if (contextVal instanceof Function) {
                returnObj = this.evalFunction((Function)contextVal, methodInvokeExpr, context);
            } else if (contextVal instanceof FunctionObject) {
                returnObj = this.evalFunctionObject((FunctionObject)contextVal, methodInvokeExpr, context);
            }
            if (returnObj != null) {
                log.debug((Object)("[evalFunction] MethodName:" + methodInvokeExpr.methodName + COST + (System.currentTimeMillis() - t)));
                return returnObj;
            }
            Object cacheId = context.get("cacheId");
            for (IFunctionProvider funcProvider : this.funcProviderList) {
                if (!funcProvider.existFunction(methodInvokeExpr.methodName)) continue;
                ArrayList<Object> pramList = new ArrayList<Object>(methodInvokeExpr.paramList.size());
                int len = methodInvokeExpr.paramList.size();
                if (methodInvokeExpr.methodName.startsWith(BOT)) {
                    funcProvider = new CachedFunctionProvider(funcProvider, BOT);
                    pramList.add(this.getBOSContext());
                    if (cacheId != null && cacheId instanceof String && methodInvokeExpr.methodName.equalsIgnoreCase("__BOTGetProperty")) {
                        pramList.add(cacheId);
                    }
                } else if (methodInvokeExpr.methodName.startsWith(DYNBOT)) {
                    funcProvider = new CachedFunctionProvider(funcProvider, DYNBOT);
                    pramList.add(this.getBOSContext());
                    pramList.add(context);
                    pramList.add(this.funcProviderList);
                }
                for (int i = 0; i < len; ++i) {
                    CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(i);
                    Object pramVal = this.evalExprInternal(pramExpr, context);
                    if (pramVal instanceof PrimitiveValue) {
                        pramVal = ((PrimitiveValue)pramVal).getBoxValue();
                    }
                    pramList.add(pramVal);
                }
                try {
                    Object obj = funcProvider.evalFunction(methodInvokeExpr.methodName, pramList);
                    log.debug((Object)("[evalFunction] MethodName:" + methodInvokeExpr.methodName + COST + (System.currentTimeMillis() - t)));
                    return obj;
                }
                catch (Throwable e) {
                    throw (InterpreterException)new InterpreterException("eval function provider error. " + methodInvokeExpr.toString(), methodInvokeExpr, e).setInfoId("EXEC_PROVIDER_ERROR").addArg(funcProvider.getClass()).addArg(methodInvokeExpr.methodName).addArg(e.getMessage()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            }
            if (this._defaultObject != null) {
                MethodInvokeExpr defaultMethodInvokeExpr = new MethodInvokeExpr(methodInvokeExpr.position);
                defaultMethodInvokeExpr.methodName = methodInvokeExpr.methodName;
                defaultMethodInvokeExpr.paramList = new ArrayList(methodInvokeExpr.paramList);
                defaultMethodInvokeExpr.owner = new IdentifierExpr(methodInvokeExpr.position.nullStart(), DEFAULT_OBJECT);
                context.put(DEFAULT_OBJECT, this._defaultObject);
                Object rtnValue = this.evalMethodInvokeExpr(defaultMethodInvokeExpr, context);
                context.remove(DEFAULT_OBJECT);
                log.debug((Object)("[evalFunction] MethodName:" + methodInvokeExpr.methodName + COST + (System.currentTimeMillis() - t)));
                return rtnValue;
            }
            String msg = "MethodInvokeExpr's owner is null. method name is : '" + methodInvokeExpr.methodName + "'";
            InterpreterException ex = (InterpreterException)new InterpreterException(msg, methodInvokeExpr).setErrorLineCode(this.getSource());
            if (this.isProperyExprOwnerNullIgore()) {
                log.error((Object)(msg + " ,but the option(properyExprOwnerNullIgore) set ignore current error. "), (Throwable)ex);
                return null;
            }
            throw ex;
        }
        Object[] pramValueArray = new Object[methodInvokeExpr.paramList.size()];
        Class[] pramClassArray = new Class[pramValueArray.length];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal((CodeExpr)methodInvokeExpr.paramList.get(i), context);
            if (pramValueArray[i] instanceof PrimitiveValue) {
                pramClassArray[i] = ((PrimitiveValue)pramValueArray[i]).getUnBoxType();
                pramValueArray[i] = ((PrimitiveValue)pramValueArray[i]).getBoxValue();
                continue;
            }
            if (pramValueArray[i] == null) continue;
            pramClassArray[i] = pramValueArray[i].getClass();
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        Method method = this.findMethod(type, methodInvokeExpr.methodName, pramClassArray);
        if (method == null) {
            throw (InterpreterException)new InterpreterException("method not found. method name is: " + methodInvokeExpr.methodName, methodInvokeExpr).setInfoId("EXEC_METHOD_NotFound").addArg(type).addArg(methodInvokeExpr.methodName).addArg(pramClassArray).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        Object rtnVal = this.invokMethod(method, ownerValue, pramValueArray);
        log.debug((Object)("[evalFunction] MethodName:" + methodInvokeExpr.methodName + COST + (System.currentTimeMillis() - t)));
        return rtnVal;
    }

    private static Method findMethod(String methodName, List methodList, Class[] pramClassArray) throws InterpreterException {
        Method method;
        int i;
        ArrayList<Method> resultList = new ArrayList<Method>();
        for (i = 0; i < methodList.size(); ++i) {
            method = (Method)methodList.get(i);
            boolean flag = true;
            for (int j = 0; j < pramClassArray.length; ++j) {
                Class<?> methodPramType = method.getParameterTypes()[j];
                if (pramClassArray[j] == null || methodPramType.isAssignableFrom(pramClassArray[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            resultList.add(method);
        }
        if (resultList.size() == 1) {
            return (Method)resultList.get(0);
        }
        if (resultList.size() == 0) {
            if (pramClassArray.length == 1) {
                for (i = 0; i < methodList.size(); ++i) {
                    method = (Method)methodList.get(i);
                    if (!method.getParameterTypes()[0].equals(String.class)) continue;
                    return method;
                }
            }
            throw (InterpreterException)new InterpreterException("method not found. method is : " + methodName).setInfoId("EXEC_METHOD_NotFound").addArg(methodName).addArg("...").addArg(pramClassArray).addArg("...");
        }
        ArrayList<Method> fList = new ArrayList<Method>();
        block3: for (int mi = 0; mi < resultList.size(); ++mi) {
            Class tCls;
            Method m = (Method)resultList.get(mi);
            for (int pi = 0; pi < pramClassArray.length && (tCls = pramClassArray[pi]) != null; ++pi) {
                if (tCls != m.getParameterTypes()[pi]) continue;
                fList.add(m);
                continue block3;
            }
        }
        if (fList.size() == 1) {
            return (Method)fList.get(0);
        }
        if (fList.size() == 0) {
            fList = resultList;
        }
        for (int pi = 0; pi < pramClassArray.length; ++pi) {
            boolean breakMethod = false;
            Method method2 = null;
            for (int mio = 0; mio < fList.size() - 1; ++mio) {
                Class<?> cls = ((Method)fList.get(mio)).getParameterTypes()[pi];
                method2 = (Method)fList.get(mio);
                for (int mi = mio + 1; mi < fList.size(); ++mi) {
                    Class<?> aCls = ((Method)fList.get(mi)).getParameterTypes()[pi];
                    if (cls == aCls) continue;
                    if (cls.isAssignableFrom(aCls)) {
                        cls = aCls;
                        method2 = (Method)fList.get(mi);
                        continue;
                    }
                    if (aCls.isAssignableFrom(cls)) continue;
                    breakMethod = true;
                    method2 = null;
                    break;
                }
                if (breakMethod) break;
            }
            if (method2 == null) continue;
            return method2;
        }
        throw (InterpreterException)new InterpreterException("multi method found. method is : " + methodName).setInfoId("EXEC_METHOD_FoundMulti").addArg("...").addArg(methodName).addArg(pramClassArray).addArg("...");
    }

    private Object invokMethod(Method method, Object ownerObj, Object[] pramValueArray) throws InterpreterException {
        Class<?>[] pramClassArray = method.getParameterTypes();
        Object[] objArray = new Object[pramClassArray.length];
        for (int i = 0; i < pramClassArray.length; ++i) {
            objArray[i] = i >= pramValueArray.length || pramValueArray[i] == null ? null : (pramClassArray[i].isInstance(pramValueArray[i]) ? pramValueArray[i] : TypeUtils.castObject(pramClassArray[i], pramValueArray[i]));
        }
        return this.invokeMethod(ownerObj, method, objArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(Object ownerObj, Method method, Object[] params) throws InterpreterException {
        Object rtnObj;
        block12: {
            rtnObj = null;
            try {
                if (Modifier.isStatic(method.getModifiers())) {
                    rtnObj = KScriptUtil.evalJavaMethod(null, method, params);
                    break block12;
                }
                if (method.getName().equals("notify") || method.getName().equals("notifyAll") || method.getName().equals("wait")) {
                    Object object = ownerObj;
                    synchronized (object) {
                        rtnObj = KScriptUtil.evalJavaMethod(ownerObj, method, params);
                        break block12;
                    }
                }
                if (this.synchronizedCallMethod) {
                    Object object = ownerObj;
                    synchronized (object) {
                        rtnObj = KScriptUtil.evalJavaMethod(ownerObj, method, params);
                    }
                } else {
                    rtnObj = KScriptUtil.evalJavaMethod(ownerObj, method, params);
                }
                this.lazyLoadFileValue(rtnObj);
            }
            catch (Exception e) {
                this.doWitdInvokeException(e, ownerObj, method.getName(), params, null);
            }
        }
        return rtnObj;
    }

    private Object evalPropExpr(PropertyExpr propExpr, Map context) throws InterpreterException {
        if (this.isForBot() && context.containsKey(propExpr.toString())) {
            return context.get(propExpr.toString());
        }
        String ownerExprStr = propExpr.owner.toString();
        Object ownerValue = TypeUtils.classForName(this.namespaces, this.classMap, ownerExprStr);
        if (ownerValue == null) {
            ownerValue = this.evalExprInternal(propExpr.owner, context);
        }
        if (ownerValue == null) {
            if (!this.properyExprOwnerNullIgore) {
                log.error((Object)("properExpr's owner is null. expr is : " + propExpr.toString()));
                throw (InterpreterException)new InterpreterException("properExpr's owner is null. expr is : " + propExpr.toString(), propExpr).setInfoId("EVAL_PROP_OWNER_NULL").addArg(ownerExprStr).addArg(propExpr).setErrorLineCode(this.getSource());
            }
            return null;
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        if (type.isArray() && propExpr.propName.equals("length")) {
            return new PrimitiveInt(Array.getLength(ownerValue));
        }
        this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
        Field field = null;
        String key = type.getName() + METHOD_GET + propExpr.propName;
        Method method = (Method)this.methodCache.get(key);
        if (method != null) {
            return this.invokeMethod(ownerValue, method, null);
        }
        method = KScriptUtil.findGetMethod(type, propExpr.propName);
        this.methodCache.put(key, method);
        if (method != null) {
            return this.invokeMethod(ownerValue, method, null);
        }
        if (this.isObjectValue(ownerValue)) {
            if (this.isObjectValueContainPropName(ownerValue, propExpr.propName)) {
                return this.getObjectValuePropValueByName(ownerValue, propExpr.propName);
            }
            return this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
        }
        if (this.isObjectCollection(ownerValue)) {
            if (this.getObjectCollectionSize(ownerValue) <= 0) {
                return null;
            }
            if ((ownerValue = this.getObjectCollectionChildByIndex(ownerValue, 0)) == null) {
                throw new NullPointerException("properExpr's owner is null.");
            }
            type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
            this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
            key = type.getName() + METHOD_GET + propExpr.propName;
            method = (Method)this.methodCache.get(key);
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            method = KScriptUtil.findGetMethod(type, propExpr.propName);
            this.methodCache.put(key, method);
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            if (this.isObjectValue(ownerValue)) {
                PropertyExpr itemPropExpr = new PropertyExpr(propExpr.position);
                itemPropExpr.owner = new IdentifierExpr(propExpr.position.nullStart(), "item");
                itemPropExpr.propName = propExpr.propName;
                HashMap<String, Object> itemCtx = new HashMap<String, Object>();
                itemCtx.put("item", ownerValue);
                return this.evalPropExpr(itemPropExpr, itemCtx);
            }
            field = TypeUtils.findField(type, propExpr.propName);
            if (field != null) {
                try {
                    return field.get(ownerValue);
                }
                catch (Exception e) {
                    this.doWitdInvokeException(e, ownerValue, propExpr.propName, null, context);
                }
            }
            throw (InterpreterException)new InterpreterException("eval properExpr error. not such field or getMethod.", propExpr).setInfoId("EVAL_PROP_NO_PROP").addArg(ownerValue).addArg(ownerValue.getClass()).addArg(propExpr).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        field = TypeUtils.findField(type, propExpr.propName);
        if (field != null) {
            try {
                field.setAccessible(true);
                return field.get(ownerValue);
            }
            catch (Exception e) {
                this.doWitdInvokeException(e, ownerValue, propExpr.propName, null, context);
            }
        }
        throw (InterpreterException)new InterpreterException("expr is : " + propExpr.toString(), propExpr, null).setErrorLineCode(this.getSource());
    }

    private Object getProperty(Object ownerValue, String property) throws InterpreterException {
        if (ownerValue == null) {
            return null;
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        if (type.isArray() && property.equals("length")) {
            return new PrimitiveInt(Array.getLength(ownerValue));
        }
        this.lazyLoadGetProperty(ownerValue, property, null);
        Field field = TypeUtils.findField(type, property);
        Throwable ex = null;
        if (field == null) {
            String key = type.getName() + METHOD_GET + property;
            Method method = (Method)this.methodCache.get(key);
            if (method == null) {
                method = KScriptUtil.findGetMethod(type, property);
                this.methodCache.put(key, method);
            }
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            if (this.isObjectValue(ownerValue)) {
                if (this.isObjectValueContainPropName(ownerValue, property)) {
                    return this.getObjectValuePropValueByName(ownerValue, property);
                }
                return this.lazyLoadGetProperty(ownerValue, property, null);
            }
            if (this.isObjectCollection(ownerValue)) {
                if (this.getObjectCollectionSize(ownerValue) <= 0) {
                    return null;
                }
                if ((ownerValue = this.getObjectCollectionChildByIndex(ownerValue, 0)) == null) {
                    throw new NullPointerException("properExpr's owner is null.");
                }
                type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
                this.lazyLoadGetProperty(ownerValue, property, null);
                field = TypeUtils.findField(type, property);
                if (field == null) {
                    key = type.getName() + METHOD_GET + property;
                    method = (Method)this.methodCache.get(key);
                    if (method == null) {
                        method = KScriptUtil.findGetMethod(type, property);
                        this.methodCache.put(key, method);
                    }
                    if (method != null) {
                        return this.invokeMethod(ownerValue, method, null);
                    }
                    if (this.isObjectValue(ownerValue)) {
                        PropertyExpr itemPropExpr = new PropertyExpr(null);
                        itemPropExpr.owner = new IdentifierExpr(null, "item");
                        itemPropExpr.propName = property;
                        HashMap<String, Object> itemCtx = new HashMap<String, Object>();
                        itemCtx.put("item", ownerValue);
                        return this.evalPropExpr(itemPropExpr, itemCtx);
                    }
                    throw (InterpreterException)new InterpreterException("eval properExpr error. not such field or getMethod.").setErrorLineCode(this.getSource());
                }
                try {
                    return field.get(ownerValue);
                }
                catch (Exception e) {
                    throw (InterpreterException)new InterpreterException("get property " + property + " error", e).setErrorLineCode(this.getSource());
                }
            }
            throw (InterpreterException)new InterpreterException("expr is : " + property, ex).setErrorLineCode(this.getSource());
        }
        try {
            field.setAccessible(true);
            return field.get(ownerValue);
        }
        catch (Exception e) {
            throw (InterpreterException)new InterpreterException("get property " + property + " error", e).setErrorLineCode(this.getSource());
        }
    }

    private void doEvalOPError(Throwable ex, int op, BinaryOpExpr expr) throws InterpreterException {
        String infoId = null;
        infoId = op == 3 || op == 4 || op == 36 || op == 5 || op == 37 || op == 6 || op == 38 ? "bitwise_OP_ERROR" : (op == 7 || op == 8 ? "BOOL_OP_ERROR" : (op == 19 || op == 34 || op == 17 || op == 33 ? "SHIFT_OP_ERROR" : "EXEC_OP_ERROR"));
        InterpreterException ne = (InterpreterException)new InterpreterException("invoke operator error", expr, ex).setInfoId(infoId).addArg(BinaryOpType.getName(expr.operator)).addArg(expr.left.toString()).addArg(expr.left.typename()).addArg(expr.right.toString()).addArg(expr.right.typename()).setErrorLineCode(this.getSource());
        throw ne;
    }

    private void doWitdInvokeException(Throwable ex, Object ownerObj, String methodName, Object objArray, Map context) throws InterpreterException {
        Throwable ex1 = ex;
        if (ex instanceof InvocationTargetException) {
            ex1 = ((InvocationTargetException)ex).getTargetException();
        }
        if (ex1 instanceof DebugStopException) {
            throw (DebugStopException)ex1;
        }
        if (ex1 instanceof InterpreterException) {
            throw (InterpreterException)ex1;
        }
        String infoId = null;
        if (ex instanceof IllegalArgumentException) {
            infoId = "EXEC_METHOD_IllegalArgument";
        } else if (ex instanceof IllegalAccessException) {
            infoId = "EXEC_METHOD_IllegalAccess";
        } else if (ex instanceof InvocationTargetException) {
            infoId = "EXEC_METHOD_InvocationTarget";
        }
        InterpreterException ne = (InterpreterException)new InterpreterException("invoke method error", ex).setInfoId(infoId).addArg(ownerObj).addArg(methodName).addArg(objArray).addArg(this.getContext(context)).addArg(ex.getMessage()).setErrorLineCode(this.getSource());
        if (ex instanceof InvocationTargetException && ne.getOrigException() == null) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            ne.setOrigException(ite.getCause());
        }
        throw ne;
    }

    private Object evalConditionExpr(ConditionExpr expr, Map context) throws InterpreterException {
        Object rtnValue = this.evalExprInternal(expr.testExpr, context);
        if (rtnValue instanceof Boolean) {
            if (rtnValue.equals(Boolean.TRUE)) {
                return this.evalExprInternal(expr.trueExpr, context);
            }
            return this.evalExprInternal(expr.falseExpr, context);
        }
        if (rtnValue instanceof PrimitiveBoolean) {
            if (rtnValue.equals(PrimitiveBoolean.TRUE)) {
                return this.evalExprInternal(expr.trueExpr, context);
            }
            return this.evalExprInternal(expr.falseExpr, context);
        }
        throw (InterpreterException)new InterpreterException("expr result is not boolean, it's :" + expr != null ? expr.getClass().getName() : "null", expr).setErrorLineCode(this.getSource());
    }

    private Object evalIndentExpr(IdentifierExpr expr, Map context) throws InterpreterException {
        Object rtnValue = null;
        String ident = expr.value;
        if (context.containsKey(ident)) {
            rtnValue = context.get(expr.value);
        } else {
            rtnValue = TypeUtils.classForName(this.namespaces, this.classMap, ident);
            if (rtnValue == null && this._defaultObject != null) {
                PropertyExpr propExpr = new PropertyExpr(expr.position);
                propExpr.propName = expr.value;
                propExpr.owner = new IdentifierExpr(expr.position.nullStart(), DEFAULT_OBJECT);
                HashMap<String, Object> tempContext = new HashMap<String, Object>(1);
                tempContext.put(DEFAULT_OBJECT, this._defaultObject);
                rtnValue = this.evalPropExpr(propExpr, tempContext);
            }
        }
        return rtnValue;
    }

    private Object evalBinaryOpExpr(BinaryOpExpr expr, Map context) throws InterpreterException {
        Object rtnVal;
        if (expr.operator == 2) {
            return this.assign(expr.left, expr.right, context);
        }
        if (expr.operator == 28) {
            BinaryOpExpr addExpr = new BinaryOpExpr(expr.position);
            addExpr.left = expr.left;
            addExpr.operator = 0;
            addExpr.right = expr.right;
            return this.assign(expr.left, addExpr, context);
        }
        if (expr.operator == 29) {
            BinaryOpExpr subExpr = new BinaryOpExpr(expr.position);
            subExpr.left = expr.left;
            subExpr.operator = 26;
            subExpr.right = expr.right;
            return this.assign(expr.left, subExpr, context);
        }
        if (expr.operator == 30) {
            BinaryOpExpr mulExpr = new BinaryOpExpr(expr.position);
            mulExpr.left = expr.left;
            mulExpr.operator = 22;
            mulExpr.right = expr.right;
            return this.assign(expr.left, mulExpr, context);
        }
        if (expr.operator == 31) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 9;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        if (expr.operator == 32) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 21;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        if (expr.operator == 33) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 17;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        if (expr.operator == 34) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 19;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        if (expr.operator == 35) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 27;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        if (expr.operator == 36) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 3;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        if (expr.operator == 37) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 5;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        if (expr.operator == 38) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 6;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, context);
        }
        Object leftValue = this.evalExprInternal(expr.left, context);
        if (expr.operator == 7) {
            if (leftValue instanceof Boolean && !((Boolean)leftValue).booleanValue()) {
                return PrimitiveBoolean.FALSE;
            }
            if (leftValue instanceof PrimitiveBoolean && !((PrimitiveBoolean)leftValue).getValue()) {
                return PrimitiveBoolean.FALSE;
            }
        } else if (expr.operator == 8) {
            if (leftValue instanceof Boolean && ((Boolean)leftValue).booleanValue()) {
                return PrimitiveBoolean.TRUE;
            }
            if (leftValue instanceof PrimitiveBoolean && ((PrimitiveBoolean)leftValue).getValue()) {
                return PrimitiveBoolean.TRUE;
            }
        }
        Object rightValue = this.evalExprInternal(expr.right, context);
        switch (expr.operator) {
            case 0: {
                rtnVal = TypeUtils.add(leftValue, rightValue);
                break;
            }
            case 9: {
                rtnVal = TypeUtils.div(leftValue, rightValue);
                break;
            }
            case 11: {
                boolean boolVal = TypeUtils.greaterThan(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 12: {
                boolean boolVal = TypeUtils.greaterThanOrEqual(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 14: {
                boolean boolVal = TypeUtils.lessThan(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 15: {
                boolean boolVal = TypeUtils.lessThanOrEqual(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 10: {
                boolean boolVal = TypeUtils.equal(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 23: {
                boolean boolVal = TypeUtils.equal(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(!boolVal);
                break;
            }
            case 22: {
                rtnVal = TypeUtils.multi(leftValue, rightValue);
                break;
            }
            case 26: {
                rtnVal = TypeUtils.sub(leftValue, rightValue);
                break;
            }
            case 13: {
                rtnVal = TypeUtils.evalInstanceOf(leftValue, rightValue);
                break;
            }
            case 3: {
                rtnVal = TypeUtils.bitwiseAnd(leftValue, rightValue);
                break;
            }
            case 5: {
                rtnVal = TypeUtils.bitwiseOr(leftValue, rightValue);
                break;
            }
            case 6: {
                rtnVal = TypeUtils.bitwiseXor(leftValue, rightValue);
                break;
            }
            case 17: {
                rtnVal = TypeUtils.leftShift(leftValue, rightValue);
                break;
            }
            case 19: {
                rtnVal = TypeUtils.rightShift(leftValue, rightValue);
                break;
            }
            case 27: {
                rtnVal = TypeUtils.rightUnsignShift(leftValue, rightValue);
                break;
            }
            case 21: {
                rtnVal = TypeUtils.mod(leftValue, rightValue);
                break;
            }
            case 7: {
                rtnVal = TypeUtils.booleanAnd(leftValue, rightValue);
                break;
            }
            case 8: {
                rtnVal = TypeUtils.booleanOr(leftValue, rightValue);
                break;
            }
            case 18: {
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(TypeUtils.Like(leftValue, rightValue));
                break;
            }
            case 39: {
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(!TypeUtils.Like(leftValue, rightValue));
                break;
            }
            default: {
                throw (InterpreterException)new InterpreterException("no suport. operator is : " + expr.operator, expr).setErrorLineCode(this.getSource());
            }
        }
        return rtnVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object assign(CodeExpr left, CodeExpr right, Map context) throws InterpreterException {
        Object rightValue = this.evalExprInternal(right, context);
        if (left instanceof IdentifierExpr) {
            IdentifierExpr identExpr = (IdentifierExpr)left;
            String ident = identExpr.value;
            context.put(ident, rightValue);
            return rightValue;
        } else if (left instanceof ArrayIndexerExpr) {
            ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)left;
            Object targetObj = this.evalExprInternal(arrayIndexerExpr.targetObjExpr, context);
            Object indexerObj = this.evalExprInternal(arrayIndexerExpr.indexExpr, context);
            int index = ((Number)indexerObj).intValue();
            Object value = rightValue instanceof PrimitiveValue ? ((PrimitiveValue)rightValue).getBoxValue() : rightValue;
            if (targetObj.getClass().isArray()) {
                Array.set(targetObj, index, value);
                return rightValue;
            } else {
                if (!(targetObj instanceof List)) throw (InterpreterException)new InterpreterException("assign to array error. target object is not an array or a list", left).setInfoId("ASSIGN_ARRAY_TO_NO_ARRAY").addArg(left.toString()).addArg(right.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                ((List)targetObj).set(index, value);
            }
            return rightValue;
        } else {
            if (!(left instanceof PropertyExpr)) return rightValue;
            PropertyExpr propExpr = (PropertyExpr)left;
            Object ownerValue = this.evalExprInternal(propExpr.owner, context);
            Throwable ex = null;
            Class<?> type = ownerValue.getClass();
            Field field = TypeUtils.findField(type, propExpr.propName);
            if (rightValue instanceof PrimitiveValue) {
                rightValue = ((PrimitiveValue)rightValue).getBoxValue();
            }
            if (field != null) {
                try {
                    field.set(ownerValue, rightValue);
                    return rightValue;
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)ILLEGAL, (Throwable)e);
                    throw (InterpreterException)new InterpreterException(ILLEGAL, propExpr, e).setErrorLineCode(this.getSource());
                }
                catch (IllegalAccessException e) {
                    log.error((Object)ILLEGAL, (Throwable)e);
                    throw (InterpreterException)new InterpreterException("IllegalAccessException", propExpr, e).setErrorLineCode(this.getSource());
                }
            } else {
                Method method = KScriptUtil.findSetMethod(type, propExpr.propName);
                if (method != null) {
                    this.invokeMethod(ownerValue, method, new Object[]{rightValue});
                    return rightValue;
                } else if (this.isObjectValue(ownerValue)) {
                    this.setObjectValuePropValue(ownerValue, propExpr.propName, rightValue);
                    return rightValue;
                } else {
                    if (ex == null) throw (InterpreterException)new InterpreterException("assign error.", left).setErrorLineCode(this.getSource());
                    log.error((Object)"An error occur.", ex);
                    throw (InterpreterException)new InterpreterException("An error occur." + ex.getMessage(), left, ex).setErrorLineCode(this.getSource());
                }
            }
        }
    }

    private Method findMethod(Class c, String methodName, Class[] pramClassArray) throws InterpreterException {
        Method[] methodArray = c.getMethods();
        ArrayList<Method> list_byName = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(methodName)) continue;
            list_byName.add(methodArray[i]);
        }
        if (list_byName.size() == 0) {
            return null;
        }
        if (list_byName.size() == 1) {
            return (Method)list_byName.get(0);
        }
        ArrayList<Method> list_byLength = new ArrayList<Method>(list_byName.size());
        for (int i = 0; i < list_byName.size(); ++i) {
            Method method = (Method)list_byName.get(i);
            Class<?>[] pramTypeArray = method.getParameterTypes();
            if (pramTypeArray.length != pramClassArray.length) continue;
            list_byLength.add(method);
        }
        if (list_byLength.size() == 0) {
            return null;
        }
        if (list_byLength.size() == 1) {
            return (Method)list_byLength.get(0);
        }
        Method rtnValue = ReflectionUtils.getMethod(c, methodName, pramClassArray);
        if (rtnValue != null) {
            return rtnValue;
        }
        return Interpreter.findMethod(methodName, list_byLength, pramClassArray);
    }

    public static Triple convertType(Object left, Object right) {
        Triple rtnValue = new Triple();
        return rtnValue;
    }

    public boolean isForBot() {
        return this.forBot;
    }

    public void setForBot(boolean forBot) {
        this.forBot = forBot;
    }

    public boolean isProperyExprOwnerNullIgore() {
        return this.properyExprOwnerNullIgore;
    }

    public void setProperyExprOwnerNullIgore(boolean properyExprOwnerNullIgore) {
        this.properyExprOwnerNullIgore = properyExprOwnerNullIgore;
    }

    public boolean isSynchronizedCallMethod() {
        return this.synchronizedCallMethod;
    }

    public void setSynchronizedCallMethod(boolean synchronizedCallMethod) {
        this.synchronizedCallMethod = synchronizedCallMethod;
    }

    private Object evalIMFirst(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.fetchAllElements(methodInvokeExpr, context, criteria, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private Object evalIMLast(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.fetchAllElements(methodInvokeExpr, context, criteria, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private List evalIMAll(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        return this.fetchAllElements(methodInvokeExpr, context, criteria, 0);
    }

    private List evalIMUniqueAll(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return list;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Object value = list.remove(i);
            if (!list.contains(value)) {
                list.add(i, value);
                continue;
            }
            --i;
        }
        return list;
    }

    private Object evalIMGetByIndex(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        CodeExpr expr = (CodeExpr)methodInvokeExpr.paramList.remove(methodInvokeExpr.paramList.size() - 1);
        Object value = this.evalExpr(expr, context);
        int index = 0;
        if (value instanceof Integer) {
            index = (Integer)value;
        } else if (value != null) {
            index = Integer.parseInt(value.toString());
        } else {
            throw new InterpreterException("param[expr(" + expr + ") is null ] is error!");
        }
        List list = this.fetchAllElements(methodInvokeExpr, context, criteria, index + 1);
        if (list.size() <= index) {
            return null;
        }
        return list.get(index);
    }

    private Object evalIMMin(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object minVal = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!TypeUtils.lessThan(list.get(i), minVal)) continue;
            minVal = list.get(i);
        }
        return minVal;
    }

    private Object evalIMMax(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object maxValue = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!TypeUtils.greaterThan(list.get(i), maxValue)) continue;
            maxValue = list.get(i);
        }
        return maxValue;
    }

    private Object evalIMCount(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        return list.size();
    }

    private Object evalIMAvg(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object sumValue = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            sumValue = TypeUtils.add(list.get(i), sumValue);
        }
        Object avgValue = TypeUtils.div(sumValue, list.size());
        return avgValue == null ? Integer.valueOf(0) : avgValue;
    }

    private void lazyLoadFileValue(Object value) throws InterpreterException {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.lazyLoadFillValue(value);
        }
    }

    private boolean isObjectValue(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectValue(value);
        }
        return false;
    }

    private boolean isObjectCollection(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectCollection(value);
        }
        return false;
    }

    private Object lazyLoadGetProperty(Object objValue, String propName, PropertyExpr propExpr) throws InterpreterException {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.lazyLoadGetProperty(objValue, propName, propExpr);
        }
        return null;
    }

    private boolean isObjectValueContainPropName(Object value, String propName) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectValueContainPropName(value, propName);
        }
        return false;
    }

    private Object getObjectValuePropValueByName(Object value, String propName) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectValuePropValueByName(value, propName);
        }
        return null;
    }

    private Object getObjectCollectionChildByIndex(Object value, int index) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectCollectionChildByIndex(value, index);
        }
        return null;
    }

    private int getObjectCollectionSize(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectCollectionSize(value);
        }
        return -1;
    }

    private void setObjectValuePropValue(Object value, String propName, Object val) {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.setObjectValuePropValue(value, propName, val);
        }
    }

    static {
        internalFunctionList.add("abs");
        internalFunctionList.add("avg");
        internalFunctionList.add("count");
        internalFunctionList.add("eval");
        internalFunctionList.add("len");
        internalFunctionList.add("max");
        internalFunctionList.add("min");
        internalFunctionList.add("newid");
        internalFunctionList.add("parseInt");
        internalFunctionList.add("parseFloat");
        internalFunctionList.add("print");
        internalFunctionList.add("println");
        internalFunctionList.add("Set");
        internalFunctionList.add("List");
        internalFunctionList.add("sum");
        internalFunctionList.add("first");
        internalFunctionList.add("last");
        internalFunctionList.add("uniqueAll");
        internalFunctionList.add("all");
        internalFunctionList.add("getByIndex");
        internalFunctionList.add(CONDITIONAL_SUM);
        internalFunctionList.add("conditional_avg");
        internalFunctionList.add("conditional_max");
        internalFunctionList.add("conditional_min");
        internalFunctionList.add("conditional_count");
        try {
            IFunctionProvider defaultFuncProvider = (IFunctionProvider)Class.forName("kd.bos.service.formula.api.BaseFormulaFunctions").newInstance();
            publicFuncProviderList.add(defaultFuncProvider);
        }
        catch (InstantiationException e) {
            log.debug((Object)"cannot registe defaultFuncProvider[kd.bos.service.formula.api.BaseFormulaFunctions]. Because : InstantiationException");
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"cannot registe defaultFuncProvider[kd.bos.service.formula.api.BaseFormulaFunctions]. Because : IllegalAccessException");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"cannot registe defaultFuncProvider[kd.bos.service.formula.api.BaseFormulaFunctions]. Because : ClassNotFoundException");
        }
    }

    private static class NoneReturnValue {
        private String name;
        static NoneReturnValue NoneReturn = new NoneReturnValue("NoneReturn");
        static NoneReturnValue Continue = new NoneReturnValue("Continue");
        static NoneReturnValue Break = new NoneReturnValue("Break");

        private NoneReturnValue(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

