/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.client.config.utils.SnapShotSwitch;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.nacos.NacosConfigClient;
import kd.bos.nacos.NacosConfigService;
import kd.bos.nacos.NacosNamingClient;
import kd.bos.nacos.NacosNamingMaintainClient;
import kd.bos.nacos.NacosNamingService;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import org.apache.log4j.Logger;

public class NacosFactory {
    private static final Logger LOGGER = Logger.getLogger(NacosFactory.class);
    private static final String NAMESPACE_STR = "namespace";
    private static final String USER_STR = "user";
    private static final String PASSWORD_STR = "password";
    private static final String Nacos_TRACE_NAME = "NacosFactory";
    private static final ConcurrentHashMap<String, NacosConfigService> SERVERADDR_CONFIGSERVICE_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, NacosNamingService> SERVERADDR_NAMINGSERVICE_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, NacosNamingMaintainClient> SERVERADDR_NAMINGMAINTAINSERVICE_MAP = new ConcurrentHashMap();

    public static ConcurrentHashMap<String, NacosConfigService> getConfigserviceMap() {
        return SERVERADDR_CONFIGSERVICE_MAP;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static NacosConfigService getNacosConfigClient(String url) {
        Properties properties;
        String serverAddr;
        TraceSpan span;
        block21: {
            NacosConfigService nacosConfigService;
            block20: {
                boolean mcIsStarted = Boolean.getBoolean("mc.isstarted");
                span = null;
                if (mcIsStarted) {
                    span = Tracer.create((String)Nacos_TRACE_NAME, (String)"getNacosConfigClient", (boolean)true);
                    TopologyTagInject.setCompentTag((InnerSpan)span.getInnerSpan(), (String)url, (String)"Nacos", (String)"Nacos");
                }
                if ((nacosConfigService = SERVERADDR_CONFIGSERVICE_MAP.get(serverAddr = (properties = NacosFactory.getNacosProperties(url)).getProperty("serverAddr"))) == null) break block20;
                NacosConfigService nacosConfigService2 = nacosConfigService;
                if (span == null) return nacosConfigService2;
                try {
                    span.close();
                    return nacosConfigService2;
                }
                catch (Throwable e) {
                    LOGGER.error((Object)e.getMessage(), e);
                }
                return nacosConfigService2;
            }
            Class<NacosFactory> clazz = NacosFactory.class;
            // MONITORENTER : kd.bos.nacos.NacosFactory.class
            nacosConfigService = SERVERADDR_CONFIGSERVICE_MAP.get(serverAddr);
            if (nacosConfigService == null) break block21;
            NacosConfigService e = nacosConfigService;
            // MONITOREXIT : clazz
            if (span == null) return e;
            try {
                span.close();
                return e;
            }
            catch (Throwable e2) {
                LOGGER.error((Object)e2.getMessage(), e2);
            }
            return e;
        }
        ConfigService configService = com.alibaba.nacos.api.NacosFactory.createConfigService((Properties)properties);
        NacosConfigClient nacosConfigClient = new NacosConfigClient(serverAddr, configService);
        SERVERADDR_CONFIGSERVICE_MAP.put(serverAddr, nacosConfigClient);
        NacosConfigClient nacosConfigClient2 = nacosConfigClient;
        // MONITOREXIT : clazz
        if (span == null) return nacosConfigClient2;
        try {
            span.close();
            return nacosConfigClient2;
        }
        catch (Throwable e) {
            LOGGER.error((Object)e.getMessage(), e);
        }
        return nacosConfigClient2;
        catch (NacosException e) {
            try {
                try {
                    LOGGER.error((Object)("createConfigService error,url=" + url), (Throwable)e);
                    throw new KDException(BosErrorCode.nacosConfiguration, new Object[]{"createConfigService error,url=" + url});
                }
                catch (Exception e3) {
                    LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new KDException((Throwable)e3, BosErrorCode.nacosConfiguration, new Object[]{e3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                if (span == null) throw throwable;
                try {
                    span.close();
                    throw throwable;
                }
                catch (Throwable e4) {
                    LOGGER.error((Object)e4.getMessage(), e4);
                }
                throw throwable;
            }
        }
    }

    public static NacosNamingService getNacosNamingService(String url) {
        Properties properties = NacosFactory.getNacosProperties(url);
        String serverAddr = properties.getProperty("serverAddr");
        NacosNamingService nacosNamingService = SERVERADDR_NAMINGSERVICE_MAP.get(serverAddr);
        if (nacosNamingService != null) {
            return nacosNamingService;
        }
        Class<NacosFactory> clazz = NacosFactory.class;
        synchronized (NacosFactory.class) {
            nacosNamingService = SERVERADDR_NAMINGSERVICE_MAP.get(serverAddr);
            if (nacosNamingService != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return nacosNamingService;
            }
            try {
                NamingService namingService = com.alibaba.nacos.api.NacosFactory.createNamingService((Properties)properties);
                NacosNamingClient nacosNamingClient = new NacosNamingClient(serverAddr, namingService);
                SERVERADDR_NAMINGSERVICE_MAP.put(serverAddr, nacosNamingClient);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return nacosNamingClient;
            }
            catch (NacosException e) {
                LOGGER.error((Object)("createNamingService error,url=" + url), (Throwable)e);
                throw new KDException(BosErrorCode.nacosConfiguration, new Object[]{"createNamingService error,url=" + url});
            }
        }
    }

    public static NacosNamingMaintainClient getNacosNamingMaintainService(String url) {
        Properties properties = NacosFactory.getNacosProperties(url);
        String serverAddr = properties.getProperty("serverAddr");
        NacosNamingMaintainClient nacosNamingMaintainService = SERVERADDR_NAMINGMAINTAINSERVICE_MAP.get(serverAddr);
        if (nacosNamingMaintainService != null) {
            return nacosNamingMaintainService;
        }
        Class<NacosFactory> clazz = NacosFactory.class;
        synchronized (NacosFactory.class) {
            nacosNamingMaintainService = SERVERADDR_NAMINGMAINTAINSERVICE_MAP.get(serverAddr);
            if (nacosNamingMaintainService != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return nacosNamingMaintainService;
            }
            try {
                NamingMaintainService maintainService = com.alibaba.nacos.api.NacosFactory.createMaintainService((Properties)properties);
                NacosNamingMaintainClient nacosNamingMaintainClient = new NacosNamingMaintainClient(serverAddr, maintainService);
                SERVERADDR_NAMINGMAINTAINSERVICE_MAP.put(serverAddr, nacosNamingMaintainClient);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return nacosNamingMaintainClient;
            }
            catch (NacosException e) {
                LOGGER.error((Object)("createamingMaintainService error,url=" + url), (Throwable)e);
                throw new KDException(BosErrorCode.nacosConfiguration, new Object[]{"createamingMaintainService error,url=" + url});
            }
        }
    }

    static void removeConfigService(String serverAddress) {
        SERVERADDR_CONFIGSERVICE_MAP.remove(serverAddress);
    }

    static void removeNamingService(String serverAddress) {
        SERVERADDR_NAMINGSERVICE_MAP.remove(serverAddress);
    }

    static void removeNamingMaintainService(String serverAddress) {
        SERVERADDR_NAMINGMAINTAINSERVICE_MAP.remove(serverAddress);
    }

    public static Properties getNacosProperties(String url) {
        Properties properties = new Properties();
        String serverAddr = url.split("/")[0];
        if (serverAddr.indexOf("?") > 0) {
            throw new KDException("url is unavailable,url=" + url);
        }
        properties.put("serverAddr", serverAddr);
        int propIndex = url.indexOf(63);
        if (propIndex > 0) {
            String[] sl = url.split("\\?");
            String strUrlParams = sl[1];
            Properties prop = new Properties();
            String[] params = strUrlParams.contains("&") ? strUrlParams.split("&") : new String[]{strUrlParams};
            for (String p : params) {
                if (p.startsWith(PASSWORD_STR)) {
                    String password = p.substring(PASSWORD_STR.length() + 1);
                    prop.put(PASSWORD_STR, password);
                    continue;
                }
                if (!p.contains("=")) continue;
                String[] param = p.split("=");
                if (param.length == 1) {
                    prop.put(param[0], "");
                    continue;
                }
                String key = param[0];
                String value = param[1];
                prop.put(key, value);
            }
            properties.put("username", prop.getProperty(USER_STR));
            String pass = prop.getProperty(PASSWORD_STR);
            if (pass != null) {
                pass = Encrypters.decode((String)pass);
                properties.put(PASSWORD_STR, pass);
            }
        }
        properties.put(NAMESPACE_STR, NacosFactory.getNacosNamespace(url));
        return properties;
    }

    public static String getNacosNamespace(String url) {
        int index = url.indexOf(47);
        if (index > 0) {
            String result = "";
            int endIndex = url.indexOf(63);
            result = endIndex > 0 ? url.substring(index + 1, endIndex) : url.substring(index + 1);
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        return "public";
    }

    static {
        SnapShotSwitch.setIsSnapShot((Boolean)false);
    }
}

