/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.circuitbreaker.armor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import kd.bos.armor.core.ArmorException;
import kd.bos.armor.core.Entry;
import kd.bos.armor.core.EntryType;
import kd.bos.armor.core.SphU;
import kd.bos.armor.core.Tracer;
import kd.bos.armor.core.context.ContextUtil;
import kd.bos.armor.core.slots.block.AbstractRule;
import kd.bos.armor.core.slots.block.BlockException;
import kd.bos.armor.core.slots.block.degrade.DegradeException;
import kd.bos.armor.core.slots.block.flow.FlowException;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.extension.ExtensionFactory;
import kd.bos.govern.eventdata.EventData;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.CircuitBreakerEvent;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.sdk.KDCounter;
import kd.bos.mservice.circuitbreaker.armor.ExceptionStatics;
import kd.bos.mservice.spi.circuitbreaker.Circuitbreaker;
import kd.bos.mservice.util.ArmorResManager;
import kd.bos.util.JSONUtils;

public class ArmorCircuitbreaker
implements Circuitbreaker {
    private static final Log log = LogFactory.getLog(ArmorCircuitbreaker.class);
    private static ExtensionFactory<ExceptionStatics> lookupFactory = ExtensionFactory.getExtensionFacotry(ExceptionStatics.class);
    public static final KDCounter counter = KDCounter.build((String)"armor_circuit_breaker", (String)"Armor Circuit Breaker");
    private Entry entry = null;
    private String name = null;
    private Object[] params = null;

    public Circuitbreaker withName(String name) {
        this.name = name;
        return this;
    }

    public Circuitbreaker withParams(Object ... params) {
        this.params = params;
        return this;
    }

    public void setContent(String content) {
        ContextUtil.enter((String)content);
    }

    public void setContent(String content, String appId) {
        ContextUtil.enter((String)content, (String)"default", (String)appId);
    }

    public void setContent(String content, String tenantId, String appId) {
        if (StringUtil.isEmpty((String)tenantId)) {
            tenantId = "default";
        }
        ContextUtil.enter((String)content, (String)tenantId, (String)appId);
    }

    public Circuitbreaker begin() {
        try {
            this.entry = this.params == null ? SphU.entry((String)this.name, (EntryType)EntryType.IN, (int)1) : SphU.entry((String)this.name, (EntryType)EntryType.IN, (int)1, (Object[])this.params);
        }
        catch (BlockException e1) {
            e1.getRule().setResource(this.name);
            if (e1 instanceof FlowException) {
                FlowException flowException = (FlowException)e1;
                String flowRule = null;
                try {
                    flowRule = JSONUtils.toString((Object)flowException.getRule());
                }
                catch (IOException e) {
                    log.warn("ArmorCircuitbreaker flowRule to json exception:", (Throwable)e);
                }
                String endMsg = ArmorResManager.parseRule((AbstractRule)e1.getRule());
                EventDataReporter.report((EventData)new EventData((EventType)LimitEvent.ApiLimitEvent.getInstance(), endMsg));
                counter.inc();
                throw new ArmorException("[ArmorStart:FlowException,Rule::" + flowRule + ":ArmorEnd]", (AbstractRule)flowException.getRule());
            }
            if (e1 instanceof DegradeException) {
                DegradeException degradeException = (DegradeException)e1;
                String degradeRule = null;
                try {
                    degradeRule = JSONUtils.toString((Object)degradeException.getRule());
                }
                catch (IOException e) {
                    log.warn("ArmorCircuitbreaker degradeRule to json exception:", (Throwable)e);
                }
                String endMsg = ArmorResManager.parseRule((AbstractRule)e1.getRule());
                EventDataReporter.report((EventData)new EventData((EventType)CircuitBreakerEvent.ApiCircuitBreakerEvent.getInstance(), endMsg));
                counter.inc();
                throw new ArmorException("[[ArmorStart:DegradeException,Rule::" + degradeRule + ":ArmorEnd]", (AbstractRule)degradeException.getRule());
            }
            throw new ArmorException("[system busy] too many request, try again later please");
        }
        return this;
    }

    public void end() {
        if (this.entry != null) {
            if (this.params != null && this.params.length > 0) {
                this.entry.exit(this.params.length, this.params);
            } else {
                this.entry.exit();
            }
            this.entry = null;
        }
    }

    public <T> T call(Callable<T> callable) {
        try {
            T object = callable.call();
            try {
                if (lookupFactory.existsExtension("dubbo")) {
                    ((ExceptionStatics)lookupFactory.getExtension("dubbo")).execution(object);
                }
            }
            catch (Exception e) {
                return object;
            }
            return object;
        }
        catch (Throwable e) {
            Tracer.trace((Throwable)e);
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new RuntimeException(e);
        }
    }
}

