/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.cage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kd.bos.cage.funswitch.CageSwitch;
import kd.bos.cage.tenant.impl.CageTenantService;
import kd.bos.dlock.DLock;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public abstract class AbstractCageHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(AbstractCageHandler.class);
    private static final String CAGE_ZK_LINUX_FILE_SEPARATOR = "/";
    private static final String CAGE_ZK_ROOT_PATH = "/runtime/monitor/cage";
    protected Map<String, Object> returnMap = new HashMap<String, Object>(2);
    private CuratorFramework client;
    private String nodeZKPath;
    private String nodeName;

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    protected void createZKListener() {
        CompletableFuture.runAsync(() -> {
            try {
                StringBuilder quotaZKPath = new StringBuilder(50);
                this.nodeZKPath = quotaZKPath.append(AbstractCageHandler.getCageZKRoot()).append(CAGE_ZK_LINUX_FILE_SEPARATOR).append(this.nodeName).toString();
                this.client = ZKFactory.getZKClient((String)System.getProperty("configUrl"));
                this.createZKNode(this.nodeZKPath, this.client);
                NodeCache nodeCache = new NodeCache(this.client, this.nodeZKPath, false);
                nodeCache.getListenable().addListener(() -> {
                    try {
                        ChildData childData = nodeCache.getCurrentData();
                        JSONArray zkData = JSONArray.parseArray((String)new String(childData.getData(), StandardCharsets.UTF_8));
                        HashMap dataMap = new HashMap();
                        if (this.nodeName.equals("switch")) {
                            zkData.forEach(jsonObj -> {
                                JSONObject object = (JSONObject)jsonObj;
                                dataMap.put(object.getString("key"), object.getString("status"));
                            });
                            CageSwitch.updatedSwitch(dataMap);
                        } else if (this.nodeName.equals("quota")) {
                            zkData.forEach(jsonObj -> {
                                JSONObject object = (JSONObject)jsonObj;
                                dataMap.put(object.getString("tid"), object.getString("quota"));
                            });
                            CageTenantService.getInstance().updateTenantsQuota(dataMap);
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                });
                nodeCache.start();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        });
    }

    protected void handle0(HttpExchange exchange) throws IOException {
    }

    protected boolean checkStorageDBCfg(HttpExchange exchange, ApiResponse<Object> response) {
        boolean result = true;
        try {
            if (!DBHelper.dbIsConfigured()) {
                this.responseStorageNotCfg(exchange, response);
                result = false;
            } else {
                this.returnMap.put("dbConfigYet", true);
            }
        }
        catch (Exception e) {
            try {
                this.responseStorageNotCfg(exchange, response);
            }
            catch (IOException ioException) {
                log.error((Throwable)ioException);
            }
            result = false;
            log.error((Throwable)e);
        }
        return result;
    }

    abstract JSONArray getConfigData();

    protected void synCfgInfoToZK() {
        CompletableFuture.runAsync(() -> {
            DLock dLock = null;
            try {
                if (!"true".equals(System.getProperty("isDBConfigured"))) {
                    return;
                }
                JSONArray configInDB = this.getConfigData();
                byte[] obj = (byte[])this.client.getData().forPath(this.nodeZKPath);
                JSONArray zkData = JSONArray.parseArray((String)new String(obj, StandardCharsets.UTF_8));
                boolean dataChanged = AbstractCageHandler.dataChanged(zkData, configInDB);
                if (dataChanged) {
                    dLock = DLock.create((String)"/dlock/monitor/cage/tenantQuotaHandler/initQuotaConfigInfo");
                    byte[] dataBytes = this.getConfigData().toJSONString().getBytes(StandardCharsets.UTF_8);
                    this.client.setData().forPath(this.nodeZKPath, dataBytes);
                }
            }
            catch (Exception e) {
                log.error("config synchronize data from db to zk exception path={},error={}", (Object)this.nodeZKPath, (Object)e.getMessage());
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZKNode(String nodeZKPath, CuratorFramework zkClient) {
        Stat exists = null;
        try {
            exists = (Stat)zkClient.checkExists().forPath(nodeZKPath);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (exists == null) {
            DLock dLock = null;
            try {
                if (this.nodeName.equals("switch")) {
                    dLock = DLock.create((String)"/dlock/monitor/cage/switchInit");
                } else if (this.nodeName.equals("quota")) {
                    dLock = DLock.create((String)"/dlock/monitor/cage/tenantQuotaHandler/initQuotaConfigInfo");
                }
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(nodeZKPath, new JSONArray().toJSONString().getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
    }

    private void responseStorageNotCfg(HttpExchange exchange, ApiResponse<Object> response) throws IOException {
        response.setCode(Integer.valueOf(0));
        this.returnMap.put("dbConfigYet", false);
        response.setData(this.returnMap);
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private static String getCageZKRoot() {
        String hosts = System.getProperty("configUrl");
        StringBuilder rootPath = new StringBuilder(50);
        return rootPath.append(ZKFactory.getZkRootPath((String)hosts)).append(Instance.getClusterName()).append(CAGE_ZK_ROOT_PATH).toString();
    }

    private static boolean dataChanged(JSONArray zkData, JSONArray dbData) {
        if (zkData == null || dbData == null) {
            return false;
        }
        if (zkData.size() != dbData.size()) {
            return true;
        }
        JSONArray zkClone = (JSONArray)zkData.clone();
        JSONArray dbClone = (JSONArray)dbData.clone();
        zkClone.removeAll((Collection)dbClone);
        dbClone.removeAll((Collection)zkData);
        return !zkClone.isEmpty() || !dbClone.isEmpty();
    }
}

