/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.cage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.cage.commons.CageException;
import kd.bos.cage.commons.QueryDataLargeException;
import kd.bos.cage.container.ContainerType;
import kd.bos.cage.metrics.AbstractMetricsQueryCondition;
import kd.bos.cage.metrics.CageMetricDaoFactory;
import kd.bos.cage.metrics.FatMetric;
import kd.bos.cage.metrics.ICageMetricDao;
import kd.bos.cage.metrics.MetricItem;
import kd.bos.cage.metrics.MetricsTenantCondition;
import kd.bos.cage.tenant.ICageTenantService;
import kd.bos.cage.tenant.impl.CageTenantService;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class TenantMonitorHandler
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private final SimpleDateFormat DATE_FORMAT_ES = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String QUERY_TENANTS = "queryTenants";
    private static final String TENANTS = "tenants";
    private static final String QUERY_AUTOQUERY = "autoQuery";
    private static final String HOSTS = "hosts";
    private static final String APPS = "apps";
    private static final String QUERY_PARA_LAST_TIME = "lastTime";
    private static final String QUERY_PARA_INTERVAL = "interval";
    private static final String QUERY_PARA_AUTO_QUERY_TIMES = "autoQueryTimes";
    private static final String QUERY_PARA_TENANT_LIST = "tenantList";
    private static final String QUERY_PARA_LAST_XAXIS_TIME = "lastXAxisTime";
    private static final String TIME_ZONE_GMT_SUB = "GMT-8:00";
    private static final String QUERY_RESPONSE_KEY_TIME = "time";
    private static final String METRICS_LEGEND = "legend";
    private static final String METRICS_XDATA = "xData";
    private static final String METRICS_AVGYDATA = "avgYData";
    private static final String RESPONSE_MSG = "msg";
    private static final String RESPONSE_OK = "ok";
    private static final String RESPONSE_ERROR = "error";
    private static final String RESPONSE_DATA_LARGE = "dataLarge";
    private static final String RESPONSE_DATA_TENANT_ID = "tenantId";
    private static final String RESPONSE_DATA_USAGE = "usage";
    private static final String RESPONSE_DATA_BYTES = "bytes";
    private static Log log = LogFactory.getLog(TenantMonitorHandler.class);

    public static TenantMonitorHandler getInstance() {
        return SingletonHolder.instance;
    }

    public String[] getPaths() {
        return new String[]{"/eye/cage/metrics", "/eye/cage/metrics/"};
    }

    public HttpHandler getHandler() {
        return TenantMonitorHandler.getInstance();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handle0(HttpExchange exchange) throws IOException {
        JSONObject retData = new JSONObject();
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<String> calendarStrList = new ArrayList<String>(100);
        try {
            void var15_25;
            void var14_20;
            Map params = (Map)ExchangeVueUtils.parseJsonFromPost((HttpExchange)exchange, Map.class);
            boolean queryTenants = (Boolean)params.get(QUERY_TENANTS);
            if (queryTenants) {
                this.queryFilterCondition(retData, 0, (ApiResponse<Object>)apiResponse, exchange);
                return;
            }
            ArrayList queryTenantList = (ArrayList)params.get(QUERY_PARA_TENANT_LIST);
            if (queryTenantList.isEmpty()) {
                throw new CageException("tenant is empty");
            }
            ArrayList queryFilterAppList = (ArrayList)params.get(APPS);
            ArrayList queryFilterIPList = (ArrayList)params.get(HOSTS);
            boolean autoQuery = (Boolean)params.get(QUERY_AUTOQUERY);
            ArrayList times = new ArrayList(50);
            JSONArray tenantLegend = this.buildTenantLegend(queryTenantList);
            ArrayList arrayList = new ArrayList(50);
            ArrayList arrayList2 = new ArrayList(100);
            if (autoQuery) {
                int lastTime = Integer.parseInt(params.get(QUERY_PARA_LAST_TIME).toString());
                int interval = Integer.parseInt(params.get(QUERY_PARA_INTERVAL).toString());
                int queryTimes = Integer.parseInt(params.get(QUERY_PARA_AUTO_QUERY_TIMES).toString());
                if (queryTimes != 1) {
                    this.queryNextTimeData(params, tenantLegend, retData, queryFilterIPList, queryFilterAppList, (ApiResponse<Object>)apiResponse, exchange);
                    return;
                }
                List<Calendar> list = this.buildTimeSeriesForAutoRefresh(interval, lastTime, calendarStrList);
                List<FatMetric> list2 = this.queryForAutoRefresh(lastTime, queryFilterIPList, queryFilterAppList);
            } else {
                ArrayList arrayList3 = new ArrayList();
                ArrayList arrayList4 = new ArrayList();
                if (params.get(QUERY_RESPONSE_KEY_TIME) != null) {
                    times = (ArrayList)params.get(QUERY_RESPONSE_KEY_TIME);
                    String startStr = (String)times.get(0);
                    String endStr = (String)times.get(1);
                    List<FatMetric> list = this.queryForTimePhase(startStr, endStr, queryFilterIPList, queryFilterAppList);
                    List<Calendar> list3 = this.buildTimeSeriesForTimePhase(startStr, endStr, calendarStrList);
                }
            }
            JSONArray tenantsAvgYSeries = this.buildAllTenantYSeries((List<Calendar>)var14_20, (List<FatMetric>)var15_25, tenantLegend.toJavaList(String.class));
            retData.put(METRICS_LEGEND, (Object)tenantLegend);
            Collections.reverse(calendarStrList);
            retData.put(METRICS_XDATA, calendarStrList);
            retData.put(METRICS_AVGYDATA, (Object)tenantsAvgYSeries);
            retData.put(RESPONSE_MSG, (Object)RESPONSE_OK);
        }
        catch (QueryDataLargeException dataTooLargeException) {
            apiResponse.setMsg(RESPONSE_ERROR);
            retData.put(RESPONSE_MSG, (Object)RESPONSE_DATA_LARGE);
        }
        catch (CageException cageException) {
            apiResponse.setMsg(RESPONSE_ERROR);
            retData.put(RESPONSE_MSG, (Object)cageException.getMessage());
        }
        catch (Exception e) {
            log.error("cage query error!", (Object)e.getMessage());
            retData.put(RESPONSE_MSG, (Object)RESPONSE_ERROR);
        }
        apiResponse.setData((Object)retData);
        apiResponse.setCode(Integer.valueOf(0));
        this.writeJson(JSONUtils.toString((Object)apiResponse), exchange);
    }

    private void queryFilterCondition(JSONObject retData, int responseCode, ApiResponse<Object> apiResponse, HttpExchange exchange) {
        ICageTenantService service = CageTenantService.getInstance();
        retData.put(TENANTS, (Object)service.listAllTenantID());
        List serviceList = ServiceInfoFactory.get().getServiceList();
        ArrayList appList = new ArrayList(20);
        ArrayList hostIpList = new ArrayList(20);
        serviceList.forEach(serviceInfo -> {
            if (!appList.contains(serviceInfo.getAppName())) {
                appList.add(serviceInfo.getAppName());
            }
            if (!hostIpList.contains(serviceInfo.getHostIp())) {
                hostIpList.add(serviceInfo.getHostIp());
            }
        });
        retData.put(APPS, appList);
        retData.put(HOSTS, hostIpList);
        apiResponse.setData((Object)retData);
        apiResponse.setCode(Integer.valueOf(responseCode));
        String jsonStr = "{}";
        try {
            jsonStr = JSONUtils.toString(apiResponse);
            this.writeJson(jsonStr, exchange);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void queryNextTimeData(Map<String, Object> params, JSONArray tenantLegend, JSONObject retData, List<String> filterIPList, List<String> filterAppList, ApiResponse<Object> apiResponse, HttpExchange exchange) throws ParseException {
        String lastXAxisTime = params.get(QUERY_PARA_LAST_XAXIS_TIME).toString();
        int interval = Integer.parseInt(params.get(QUERY_PARA_INTERVAL).toString());
        JSONArray tenantTimeArrayCPU = new JSONArray();
        JSONArray tenantTimeArrayMem = new JSONArray();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = dateFormat.format(new Date());
        StringBuilder dataTimeStrBuf = new StringBuilder(dateStr).append(" ").append(lastXAxisTime);
        Date start = dateTimeFormat.parse(dataTimeStrBuf.toString());
        Calendar startCalendar = Calendar.getInstance(TimeZone.getTimeZone(TIME_ZONE_GMT_SUB));
        startCalendar.setTime(start);
        String startDateTimeStr = this.DATE_FORMAT_ES.format(startCalendar.getTime());
        Calendar endCalendar = Calendar.getInstance(TimeZone.getTimeZone(TIME_ZONE_GMT_SUB));
        endCalendar.setTime(start);
        endCalendar.add(13, interval);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String endTimeStr = sdf.format(endCalendar.getTime());
        String endDateTimeStr = this.DATE_FORMAT_ES.format(endCalendar.getTime());
        List<FatMetric> metrics = this.queryForTimePhase(startDateTimeStr, endDateTimeStr, filterIPList, filterAppList);
        HashMap<String, Double> tenantCpuTotal = new HashMap<String, Double>();
        HashMap<String, Long> tenantMemTotal = new HashMap<String, Long>();
        for (FatMetric fatMetric : metrics) {
            this.addToTotal(tenantCpuTotal, tenantMemTotal, fatMetric, tenantLegend.toJavaList(String.class));
        }
        List tenantList = tenantLegend.toJavaList(String.class);
        this.buildYSeriesAvgTimePhase(tenantList, startCalendar, endCalendar, metrics, tenantCpuTotal, tenantMemTotal);
        for (String tenantId : tenantLegend.toJavaList(String.class)) {
            if (tenantCpuTotal.containsKey(tenantId)) {
                tenantTimeArrayCPU.add(tenantCpuTotal.get(tenantId));
            }
            if (!tenantMemTotal.containsKey(tenantId)) continue;
            tenantTimeArrayMem.add(tenantMemTotal.get(tenantId));
        }
        retData.put(QUERY_RESPONSE_KEY_TIME, (Object)endTimeStr);
        retData.put(ContainerType.cpu.toString(), (Object)tenantTimeArrayCPU);
        retData.put(ContainerType.mem.toString(), (Object)tenantTimeArrayMem);
        apiResponse.setData((Object)retData);
        apiResponse.setCode(Integer.valueOf(0));
        try {
            this.writeJson(JSONUtils.toString(apiResponse), exchange);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    private JSONArray buildAllTenantYSeries(List<Calendar> calendarLis, List<FatMetric> fatMetrics, List<String> tenantIds) {
        JSONArray ySeries = new JSONArray();
        ArrayList<HashMap<String, Double>> cpuSet = new ArrayList<HashMap<String, Double>>(20);
        ArrayList<HashMap<String, Long>> memSet = new ArrayList<HashMap<String, Long>>(20);
        for (int i = 0; i < calendarLis.size() - 1; ++i) {
            Calendar lastCalendar = calendarLis.get(i);
            Calendar preCalendar = calendarLis.get(i + 1);
            HashMap<String, Double> tenantCpuTotal = new HashMap<String, Double>(20);
            HashMap<String, Long> tenantMemTotal = new HashMap<String, Long>(20);
            this.buildYSeriesAvgTimePhase(tenantIds, preCalendar, lastCalendar, fatMetrics, tenantCpuTotal, tenantMemTotal);
            cpuSet.add(tenantCpuTotal);
            memSet.add(tenantMemTotal);
        }
        tenantIds.forEach(tenantId -> {
            ArrayList<Double> cpuSeries = new ArrayList<Double>(20);
            ArrayList<Long> memSeries = new ArrayList<Long>(20);
            for (int i = 0; i < cpuSet.size(); ++i) {
                double cpuUsage = (Double)((Map)cpuSet.get(i)).get(tenantId);
                cpuSeries.add(cpuUsage);
                long memUsage = (Long)((Map)memSet.get(i)).get(tenantId);
                memSeries.add(memUsage);
            }
            JSONObject obj = new JSONObject();
            obj.put(RESPONSE_DATA_TENANT_ID, tenantId);
            Collections.reverse(cpuSeries);
            obj.put(ContainerType.cpu.toString(), cpuSeries);
            Collections.reverse(memSeries);
            obj.put(ContainerType.mem.toString(), memSeries);
            ySeries.add((Object)obj);
        });
        return ySeries;
    }

    private void buildYSeriesAvgTimePhase(List<String> tenants, Calendar start, Calendar end, List<FatMetric> fatMetrics, Map<String, Double> tenantCpuTotal, Map<String, Long> tenantMemTotal) {
        FatMetric fatMetric;
        long metricTime;
        tenants.forEach(tenantId -> {
            tenantCpuTotal.put((String)tenantId, 0.0);
            tenantMemTotal.put((String)tenantId, 0L);
        });
        if (fatMetrics.isEmpty()) {
            return;
        }
        int traverseNum = 0;
        for (int i = fatMetrics.size() - 1; i >= 0 && (metricTime = (fatMetric = fatMetrics.get(i)).getTimeStamp()) >= start.getTime().getTime(); --i) {
            if (metricTime > start.getTime().getTime() && metricTime <= end.getTime().getTime()) {
                this.addToTotal(tenantCpuTotal, tenantMemTotal, fatMetric, tenants);
                ++traverseNum;
            }
            fatMetrics.remove(fatMetric);
        }
        if (1 < traverseNum) {
            for (Map.Entry<String, Double> entry : tenantCpuTotal.entrySet()) {
                double avg = entry.getValue() / (double)traverseNum;
                entry.setValue(this.formatDataForDecimal(avg, 2));
            }
            for (Map.Entry<String, Number> entry : tenantMemTotal.entrySet()) {
                long avg = new Double((Long)entry.getValue() / (long)traverseNum).longValue();
                entry.setValue(avg);
            }
        }
    }

    private void addToTotal(Map<String, Double> tenantCpuTotal, Map<String, Long> tenantMemTotal, FatMetric fatMetric, List<String> tenants) {
        Map<String, Map> data = this.getTenantsUsageFromRecord(fatMetric);
        Map cpu = data.get(ContainerType.cpu.toString());
        for (Map.Entry cpuEntry : cpu.entrySet()) {
            String tenantId = (String)cpuEntry.getKey();
            if (!tenants.contains(tenantId)) continue;
            double cpuUsage = (Double)cpuEntry.getValue();
            if (tenantCpuTotal.containsKey(tenantId)) {
                double totalUsage = tenantCpuTotal.get(tenantId);
                tenantCpuTotal.put(tenantId, totalUsage += cpuUsage);
                continue;
            }
            tenantCpuTotal.put(tenantId, cpuUsage);
        }
        Map mem = data.get(ContainerType.mem.toString());
        for (Map.Entry cpuEntry : mem.entrySet()) {
            String tenantId = (String)cpuEntry.getKey();
            if (!tenants.contains(tenantId)) continue;
            long memUsage = (Long)cpuEntry.getValue();
            if (tenantMemTotal.containsKey(tenantId)) {
                long totalUsage = tenantMemTotal.get(tenantId);
                tenantMemTotal.put(tenantId, totalUsage += memUsage);
                continue;
            }
            tenantMemTotal.put(tenantId, memUsage);
        }
    }

    private Map<String, Map> getTenantsUsageFromRecord(FatMetric fatMetric) {
        HashMap<String, Map> resultData = new HashMap<String, Map>(100);
        List cageMetricsList = fatMetric.getCageMetricsList();
        HashMap allTenantCpuUsage = new HashMap(100);
        HashMap allTenantMemUsage = new HashMap(100);
        cageMetricsList.forEach(cageMetric -> {
            String tenantId = cageMetric.getCageTid();
            for (Map.Entry entry : cageMetric.getClassify().entrySet()) {
                if (((String)entry.getKey()).equals(ContainerType.cpu.toString())) {
                    Object cpu = ((MetricItem)entry.getValue()).metric.get(RESPONSE_DATA_USAGE);
                    double cpuUsage = Double.parseDouble(cpu.toString());
                    allTenantCpuUsage.put(tenantId, cpuUsage);
                    continue;
                }
                if (!((String)entry.getKey()).equals(ContainerType.mem.toString())) continue;
                Object bytes = ((MetricItem)entry.getValue()).metric.get(RESPONSE_DATA_BYTES);
                long memUsage = Long.parseLong(bytes.toString());
                allTenantMemUsage.put(tenantId, memUsage);
            }
        });
        resultData.put(ContainerType.cpu.toString(), allTenantCpuUsage);
        resultData.put(ContainerType.mem.toString(), allTenantMemUsage);
        return resultData;
    }

    private JSONArray buildTenantLegend(List<String> queryTenantList) {
        JSONArray jsonArray = new JSONArray();
        queryTenantList.forEach(arg_0 -> ((JSONArray)jsonArray).add(arg_0));
        return jsonArray;
    }

    private List<Calendar> buildTimeSeriesForAutoRefresh(int interval, int lastTime, List<String> calendarStrList) {
        Date now = new Date();
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(now);
        startCalendar.add(12, -lastTime);
        startCalendar.add(13, -interval);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(now);
        return this.generateTimeSeriesDesc(startCalendar, endCalendar, interval, calendarStrList);
    }

    private List<Calendar> buildTimeSeriesForTimePhase(String startStr, String endStr, List<String> calendarStrList) {
        Date startDate = this.stringToDate(startStr);
        Calendar startCalendar = Calendar.getInstance();
        Date endDate = this.stringToDate(endStr);
        long timeLong = endDate.getTime() - startDate.getTime();
        int timeInterval = (int)timeLong / 60000;
        if (timeInterval < 15) {
            timeInterval = 15;
        }
        startCalendar.setTime(startDate);
        startCalendar.add(13, -timeInterval);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        return this.generateTimeSeriesDesc(startCalendar, endCalendar, timeInterval, calendarStrList);
    }

    private List<Calendar> generateTimeSeriesDesc(Calendar start, Calendar end, int timeInterval, List<String> calendarStrList) {
        ArrayList<Calendar> calendarList = new ArrayList<Calendar>();
        while (true) {
            Calendar newCalendar = Calendar.getInstance();
            newCalendar.setTime(end.getTime());
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            calendarStrList.add(sdf.format(newCalendar.getTime()));
            calendarList.add(newCalendar);
            if (!end.getTime().after(start.getTime())) break;
            end.add(13, -timeInterval);
        }
        calendarList.add(start);
        return calendarList;
    }

    private List<FatMetric> queryForAutoRefresh(int lastTime, List<String> filterIpList, List<String> filterAppList) {
        ICageMetricDao dao = CageMetricDaoFactory.buildDao();
        MetricsTenantCondition cageQueryCondition = new MetricsTenantCondition();
        cageQueryCondition.setPageSize(100);
        Calendar start = Calendar.getInstance(TimeZone.getTimeZone(TIME_ZONE_GMT_SUB));
        start.add(12, -lastTime);
        start.add(13, -2);
        Calendar endCal = Calendar.getInstance(TimeZone.getTimeZone(TIME_ZONE_GMT_SUB));
        cageQueryCondition.setStart(start.getTime());
        cageQueryCondition.setEnd(endCal.getTime());
        cageQueryCondition.setFilterHosts(filterIpList);
        cageQueryCondition.setFilterApps(filterAppList);
        return dao.queryData((AbstractMetricsQueryCondition)cageQueryCondition);
    }

    private List<FatMetric> queryForTimePhase(String startStr, String endStr, List<String> filterIpList, List<String> filterAppList) {
        ICageMetricDao dao = CageMetricDaoFactory.buildDao();
        MetricsTenantCondition cageQueryCondition = new MetricsTenantCondition();
        cageQueryCondition.setPageSize(100);
        Date start = this.stringToDate(startStr);
        Date end = this.stringToDate(endStr);
        cageQueryCondition.setStart(start);
        cageQueryCondition.setEnd(end);
        cageQueryCondition.setFilterHosts(filterIpList);
        cageQueryCondition.setFilterApps(filterAppList);
        return dao.queryData((AbstractMetricsQueryCondition)cageQueryCondition);
    }

    private double formatDataForDecimal(double data, int decimalBitNum) {
        BigDecimal bd = BigDecimal.valueOf(data);
        return bd.setScale(decimalBitNum, 4).doubleValue();
    }

    private Date stringToDate(String date) {
        if (StringUtils.isEmpty((String)date)) {
            throw new CageException("Cage: date is empty!");
        }
        try {
            this.DATE_FORMAT_ES.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            return this.DATE_FORMAT_ES.parse(date);
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            throw new CageException("Cage: parser date error,".concat(e.getMessage()), (Throwable)e);
        }
    }

    private static class SingletonHolder {
        private static final TenantMonitorHandler instance = new TenantMonitorHandler();

        private SingletonHolder() {
        }
    }
}

