/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.cage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import kd.bos.cage.commons.CageException;
import kd.bos.cage.funswitch.CageSwitch;
import kd.bos.cage.metrics.CageMetricSupplier;
import kd.bos.cage.tenant.ICageTenantService;
import kd.bos.cage.tenant.impl.CageTenantService;
import kd.bos.eye.api.cage.AbstractCageHandler;
import kd.bos.eye.api.cage.vo.CageQuotaInfo;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.Gauger;
import kd.bos.metric.MetricSystem;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class TenantQuotaHandler
extends AbstractCageHandler {
    private static final Log log = LogFactory.getLog(TenantQuotaHandler.class);
    private static final String DUPLICATE_TENANT_EXCEPTION_KEY_WORD = "Duplicate";
    private String nodeName = "quota";

    private TenantQuotaHandler() {
        super.setNodeName(this.nodeName);
        this.createZKListener();
        this.synCfgInfoToZK();
        if (CageSwitch.cgroupRuntimeEnvIsOn()) {
            MetricSystem.gauge((String)"kd.metrics.cage.usage", () -> {
                Gauger metricsObj = new Gauger();
                metricsObj.setValueSupplier((Supplier)new CageMetricSupplier());
                return metricsObj;
            });
        }
    }

    public static TenantQuotaHandler getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        boolean checkDB = super.checkStorageDBCfg(exchange, (ApiResponse<Object>)response);
        if (!checkDB) {
            return;
        }
        try {
            String requestType;
            CageQuotaInfo paramInfo = (CageQuotaInfo)ExchangeVueUtils.parseJsonFromPost((HttpExchange)exchange, CageQuotaInfo.class);
            switch (requestType = paramInfo.getRequestType()) {
                case "updateTenantQuota": {
                    this.updateTenantQuota(paramInfo, false);
                    break;
                }
                case "updateDefaultQuota": {
                    this.updateTenantQuota(paramInfo, true);
                    break;
                }
                case "delTenantQuota": {
                    this.deleteTenantQuota(paramInfo);
                    break;
                }
                case "addTenantQuota": {
                    this.addTenantCustomizedQuota(paramInfo);
                    break;
                }
            }
            this.query(paramInfo);
            response.setCode(Integer.valueOf(0));
            response.setData((Object)this.returnMap);
            response.setMsg("success");
        }
        catch (Exception e) {
            response.setCode(Integer.valueOf(0));
            if (e.getMessage().contains(DUPLICATE_TENANT_EXCEPTION_KEY_WORD)) {
                response.setMsg("tenantDuplicate");
            }
            response.setMsg("failure");
        }
        this.writeJson(JSONUtils.toString((Object)response), exchange);
    }

    @Override
    protected JSONArray getConfigData() {
        JSONArray jsonArray = new JSONArray();
        DBRequest dbRequest = new DBRequest();
        ArrayList queryList = new ArrayList(1);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest("select ftenantid, fquota from t_monitor_cage_quota", queryList));
        List rows = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        for (Result row : rows) {
            JSONObject jsonObject = new JSONObject();
            String ftenantid = row.getString("ftenantid");
            String fquota = row.getString("fquota");
            jsonObject.put("tid", (Object)ftenantid);
            jsonObject.put("quota", (Object)fquota);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    private void query(CageQuotaInfo paramInfo) {
        String querySql;
        String tenantId = paramInfo.getTenantId();
        DBRequest dbRequest = new DBRequest();
        ArrayList queryList = new ArrayList(3);
        String resourceType = paramInfo.getType();
        if (!StringUtils.isEmpty((String)tenantId)) {
            querySql = "select  fid,ftenantid, fquota from t_monitor_cage_quota ar where ftype=? and ftenantid like ? or fid= ?  ORDER BY ar.fupdatetime desc";
            Collections.addAll(queryList, resourceType, "%".concat(tenantId).concat("%"), -1);
        } else {
            querySql = "select  fid,ftenantid, fquota from t_monitor_cage_quota ar where ftype=?  or fid= ? ORDER BY ar.fupdatetime desc";
            Collections.addAll(queryList, resourceType, -1);
        }
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List returnList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<CageQuotaInfo> resultList = new ArrayList<CageQuotaInfo>(returnList.size());
        for (Result row : returnList) {
            CageQuotaInfo cageQuotaInfo = new CageQuotaInfo();
            String tenantIdNew = row.getString("ftenantid");
            String quota = row.getString("fquota");
            Date date = row.getDate("fupdatetime");
            cageQuotaInfo.setTenantId(tenantIdNew);
            String fidStr = row.getString("fid");
            long fid = Long.parseLong(fidStr);
            if (fid > 0L) {
                cageQuotaInfo.setFid(fidStr);
                cageQuotaInfo.setCpuQuota(StringUtils.isNotEmpty((String)quota) ? quota : "80");
                cageQuotaInfo.setUpdateTime(date);
                resultList.add(cageQuotaInfo);
                continue;
            }
            this.returnMap.put("defaultQuota", row.getString("fquota"));
        }
        this.returnMap.put("quotaConfigList", resultList);
        ICageTenantService service = CageTenantService.getInstance();
        this.returnMap.put("tenants", service.listAllTenantID());
    }

    private void deleteTenantQuota(CageQuotaInfo paramInfo) {
        DBRequest dbRequest = new DBRequest();
        long fid = Long.parseLong(paramInfo.getFid());
        ArrayList<Long> paras = new ArrayList<Long>();
        paras.add(fid);
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest("delete from t_monitor_cage_quota  where fid=?", paras));
        try {
            MetadataFactory.getStatement().executeDelete((Request)dbRequest);
            this.synCfgInfoToZK();
        }
        catch (Exception e) {
            log.error("delete special tenant quota to db error={}", (Object)e.getMessage());
            throw new CageException("failure", (Throwable)e);
        }
    }

    private void updateTenantQuota(CageQuotaInfo cageQuotaInfo, boolean updateDefaultQuota) {
        DBRequest dbRequest = new DBRequest();
        String fid = updateDefaultQuota ? String.valueOf(-1) : cageQuotaInfo.getFid();
        ArrayList updateList = new ArrayList(3);
        Collections.addAll(updateList, cageQuotaInfo.getCpuQuota(), LocalDateTime.now(), fid);
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest("update t_monitor_cage_quota set fquota=?,fupdatetime = ? where  fid= ?", updateList));
        try {
            MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            this.synCfgInfoToZK();
        }
        catch (Exception e) {
            log.error("Update quota to db error={}", (Object)e.getMessage());
            throw new CageException("failure", (Throwable)e);
        }
    }

    private void addTenantCustomizedQuota(CageQuotaInfo cageQuotaInfo) {
        DBRequest dbRequest = new DBRequest();
        long fid = ID.genLongId();
        String tenant = cageQuotaInfo.getTenantId();
        String quota = cageQuotaInfo.getCpuQuota();
        ArrayList insertList = new ArrayList(5);
        Collections.addAll(insertList, fid, tenant, quota, LocalDateTime.now(), "CPU");
        dbRequest.setInsertRequest(new DBRequest.InsertRequest("insert into  t_monitor_cage_quota values (?,?,?,?,?)", insertList));
        try {
            MetadataFactory.getStatement().executeInsert((Request)dbRequest);
            this.synCfgInfoToZK();
        }
        catch (Exception e) {
            log.error("add special tenant={}, quota to db error={}", (Object)tenant, (Object)e.getMessage());
            if (e.getMessage().contains(DUPLICATE_TENANT_EXCEPTION_KEY_WORD)) {
                throw new CageException("tenantDuplicate", (Throwable)e);
            }
            throw new CageException("failure", (Throwable)e);
        }
    }

    private static class SingletonHolder {
        private static final TenantQuotaHandler instance = new TenantQuotaHandler();

        private SingletonHolder() {
        }
    }
}

