/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.clustercheck;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.clustercheck.ClusterChecker;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.ServiceInfoManger;
import kd.bos.util.StringUtils;

public class ClusterCheckHandler
implements HttpHandler,
EyeExtendedHandlerHolder {
    private static DistributeSessionlessCache cache;
    private static final String VALUE_STORE_KEY;
    private static final String LOCK_KEY;
    private static final ClusterCheckHandler instance;

    public String[] getPaths() {
        return new String[]{"/healthcheck/v2"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        JSONObject response;
        block21: {
            if (cache == null) {
                cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            }
            JSONObject params = (JSONObject)ExchangeVueUtils.parseJsonFromPost((HttpExchange)httpExchange, JSONObject.class);
            long start = System.currentTimeMillis();
            JSONObject queryParams = params.getJSONObject("params");
            long timestamp = queryParams.getLongValue("timestamp");
            long httpCost = this.cost(timestamp);
            try {
                if (this.auth(params)) {
                    boolean needCheck = this.needCheck();
                    if (!needCheck) {
                        Map storeValue = cache.getAll(VALUE_STORE_KEY);
                        this.writeJson((String)storeValue.get("value"), httpExchange);
                        return;
                    }
                    try (CheckLock lock = new CheckLock();){
                        if (lock.lock()) {
                            List<ServiceInfo> instances = this.getInstances(params);
                            if (instances.isEmpty()) {
                                response = this.ofResponse(-1, "query appNames not in service list", this.cost(start), httpCost);
                            } else {
                                JSONObject checkResults = ClusterChecker.execute(instances, this.getRemoterUrl(httpExchange), params);
                                response = this.ofResponse(0, "success", this.cost(start), httpCost);
                                response.put("detail", (Object)checkResults);
                            }
                            String value = response.toJSONString();
                            HashMap<String, String> hashMap = new HashMap<String, String>(2);
                            hashMap.put("value", value);
                            hashMap.put("time", String.valueOf(System.currentTimeMillis()));
                            cache.put(VALUE_STORE_KEY, hashMap, 60);
                        } else {
                            response = this.ofResponse(-1, "[ERROR] too many request, system busy", this.cost(start), httpCost);
                        }
                        break block21;
                    }
                }
                response = this.ofResponse(-1, "[ERROR] access denied,user and password doesn't match,please check monitor configuration ", this.cost(start), httpCost);
            }
            catch (Exception e) {
                response = this.ofResponse(-1, ExceptionHandler.getExceptionStackTrace((Throwable)e), this.cost(start), httpCost);
            }
        }
        this.writeJson(response.toJSONString(), httpExchange);
    }

    protected void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    protected JSONObject ofResponse(int status, String msg, long cost, long httpCost) {
        JSONObject json = new JSONObject();
        json.put("status", (Object)status);
        json.put("msg", (Object)msg);
        json.put("cost", (Object)cost);
        json.put("httpcost", (Object)httpCost);
        return json;
    }

    private String getRemoterUrl(HttpExchange httpExchange) {
        String rawPath = httpExchange.getRequestURI().getRawPath();
        int index = rawPath.indexOf("healthcheck");
        rawPath = index > 0 ? rawPath.substring(1, index) + "healthcheck/v2/service" : "healthcheck/v2/service";
        return rawPath;
    }

    protected boolean auth(JSONObject params) {
        JSONObject auth = params.getJSONObject("auth");
        String userName = auth.getString("userName");
        String passwd = auth.getString("password");
        if (auth == null || StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)passwd)) {
            throw new IllegalArgumentException("auth message is null, access denied");
        }
        return HealthCheckConfig.checkAuth((String)userName, (String)Encrypters.decode((String)passwd));
    }

    private boolean needCheck() {
        Map map = cache.getAll(VALUE_STORE_KEY);
        if (map != null && !map.isEmpty()) {
            String time = (String)map.get("time");
            long checkTime = Long.parseLong(time);
            return this.cost(checkTime) > 60000L;
        }
        return true;
    }

    protected long cost(long start) {
        return System.currentTimeMillis() - start;
    }

    private List<ServiceInfo> getInstances(JSONObject params) {
        List serviceList = ServiceInfoManger.getInstance().getServiceList();
        ArrayList<ServiceInfo> objects = new ArrayList<ServiceInfo>(serviceList.size());
        JSONObject queryParam = params.getJSONObject("params");
        String appNames = queryParam.getString("appNames");
        if (StringUtils.isNotEmpty((String)appNames)) {
            String[] appNameArray = appNames.split(",");
            for (ServiceInfo serviceInfo : serviceList) {
                for (String appName : appNameArray) {
                    if (!serviceInfo.getAppName().equals(appName)) continue;
                    objects.add(serviceInfo);
                }
            }
        } else {
            objects.addAll(serviceList);
        }
        return objects;
    }

    static {
        VALUE_STORE_KEY = Instance.getClusterName() + "-monitor-cluster-check-store-value";
        LOCK_KEY = Instance.getClusterName() + "-monitor-cluster-check-lock-key";
        instance = new ClusterCheckHandler();
    }

    private static class CheckLock
    implements Closeable {
        private CheckLock() {
        }

        private boolean lock() {
            long inc = cache.inc(LOCK_KEY, 5);
            return inc <= 1L;
        }

        private void unLock() {
            cache.remove(LOCK_KEY);
        }

        @Override
        public void close() {
            this.unLock();
        }
    }
}

