/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.clustercheck;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.eye.api.armor.Grocery;
import kd.bos.eye.api.clustercheck.ClusterCheckResult;
import kd.bos.eye.api.speedtest.KDConnectionSpeedTest;
import kd.bos.eye.api.speedtest.RedisSpeedTest;
import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.eye.api.speedtest.configservice.ZKSpeedTest;
import kd.bos.eye.api.speedtest.mq.MqTesterCreator;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.MserviceStatusManger;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.bos.zk.ZKFactory;

public class ClusterChecker {
    private static final int threads = Integer.getInteger("monitor.cluster.check.threads", 1);
    private static final int threads_components = Integer.getInteger("monitor.cluster.check.component.threads", 3);
    private static final String TO_BE_TEST = "to be tested";
    private static final ForkJoinPool forkJoinPool = new ForkJoinPool(Math.min(threads, 3));
    private static final ThreadPool componentCheckPool = ThreadPools.newFixedThreadPool((String)"monitor.healthcheck", (int)Math.min(threads_components, 5));
    private static Class redisFactory;
    private static Class kdDriverUtil;
    private static Map<String, Object> redisPoolMap;
    private static Map<String, Object> kdConnectionPool;
    private static final MqTesterCreator mqTesterCreator;

    public static JSONObject execute(List<ServiceInfo> serviceList, String url, JSONObject params) {
        JSONObject response = new JSONObject();
        JSONObject queryParam = params.getJSONObject("params");
        if (queryParam != null) {
            String appIds = queryParam.getString("appIds");
            response.put("rpc", (Object)ClusterChecker.testRpc(appIds));
        }
        List<JSONObject> invoke = forkJoinPool.invoke(new ServiceCheckTask(serviceList, serviceList.get(0).getAppName(), url, params));
        response.put("common", invoke);
        return response;
    }

    public static List<JSONObject> getCheckResult() {
        JSONObject result = new JSONObject();
        long start = System.currentTimeMillis();
        ConcurrentHashMap<String, ClusterCheckResult> resultMap = new ConcurrentHashMap<String, ClusterCheckResult>(32);
        result.put("appName", (Object)Instance.getAppName());
        result.put("instanceId", (Object)Instance.getInstanceId());
        try {
            ArrayList<SpeedTest> components = new ArrayList<SpeedTest>(32);
            ZKFactory.poolMap.forEach((k, v) -> {
                ZKSpeedTest zkSpeedTest = new ZKSpeedTest((String)k);
                String url = zkSpeedTest.getUrl();
                components.add(zkSpeedTest);
                resultMap.put(url, ClusterCheckResult.ofResult(url, zkSpeedTest.getName(), TO_BE_TEST, 1));
            });
            redisPoolMap.forEach((k, v) -> {
                RedisSpeedTest redisSpeedTest = new RedisSpeedTest((String)k);
                components.add(redisSpeedTest);
                String url = redisSpeedTest.getUrl();
                resultMap.put(url, ClusterCheckResult.ofResult(url, redisSpeedTest.getName(), TO_BE_TEST, 1));
            });
            kdConnectionPool.forEach((k, v) -> {
                String[] urlls = k.split("#");
                KDConnectionSpeedTest connectionSpeedTest = new KDConnectionSpeedTest(urlls[0], urlls[1]);
                String url = connectionSpeedTest.getUrl();
                components.add(connectionSpeedTest);
                resultMap.put(url, ClusterCheckResult.ofResult(k, connectionSpeedTest.getName(), TO_BE_TEST, 1));
            });
            List<SpeedTest> testers = mqTesterCreator.getTesters();
            for (SpeedTest speedTest : testers) {
                String string = speedTest.getUrl();
                resultMap.put(string, ClusterCheckResult.ofResult(string, speedTest.getName(), TO_BE_TEST, 1));
                components.add(speedTest);
            }
            CountDownLatch latch = new CountDownLatch(components.size());
            for (SpeedTest speedTest : components) {
                componentCheckPool.execute(() -> {
                    long timeMillis = System.currentTimeMillis();
                    try {
                        String name = speedTest.getName();
                        String message = speedTest.getDes();
                        long test = speedTest.test();
                        int status = "DbConnection".equals(name) ? ClusterChecker.getStatus(test, "monitor.cluster_check.health_range.db", "0,1000,5000") : ("Redis".equals(name) ? ClusterChecker.getStatus(test, "monitor.cluster_check.health_range.redis", "0,50,100") : ClusterChecker.getStatus(test, "monitor.cluster_check.health_range.common", "0,200,500"));
                        if (status != 0) {
                            message = "the cost time more than configuration, cause by:  " + message;
                        }
                        ((ClusterCheckResult)resultMap.get(speedTest.getUrl())).buildStatus(status).buildMsg(message).buildCost(test);
                    }
                    catch (Exception e) {
                        ((ClusterCheckResult)resultMap.get(speedTest.getUrl())).buildStatus(-1).buildMsg(ExceptionHandler.getExceptionStackTrace((Throwable)e)).buildCost(System.currentTimeMillis() - timeMillis);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            if (Instance.isPausedServiceByMonitor()) {
                result.put("status", (Object)1);
                result.put("msg", (Object)"service is paused by monitor,but pod not need to restart");
            } else {
                boolean bl = MserviceStatusManger.canResponse();
                result.put("status", (Object)(bl ? 0 : -1));
                result.put("msg", (Object)(bl ? "canResponse" : "service can not response"));
            }
            boolean bl = latch.await(5L, TimeUnit.SECONDS);
            if (bl) {
                result.put("msg", (Object)(result.getString("msg") + "  instance check more than 5 seconds"));
            }
            ArrayList arrayList = new ArrayList(resultMap.values());
            result.put("components", arrayList);
            result.put("cost", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            result.put("status", (Object)-1);
            result.put("msg", (Object)ExceptionHandler.getExceptionStackTrace((Throwable)e));
            result.put("cost", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.singletonList(result);
    }

    private static JSONObject ofResult(int status, long cost, String message, String appName, String instance, String ip, String hostName) {
        JSONObject object = new JSONObject();
        object.put("status", (Object)status);
        object.put("cost", (Object)cost);
        object.put("msg", (Object)message);
        object.put("appName", (Object)appName);
        object.put("instanceId", (Object)instance);
        object.put("ip", (Object)ip);
        object.put("hostName", (Object)hostName);
        return object;
    }

    private static int getStatus(long costTime, String key, String defaultValue) {
        long end;
        long middle;
        long begin;
        String component_statusRange = System.getProperty(key, defaultValue);
        String[] split = component_statusRange.split(",");
        if (split.length != 3) {
            begin = 0L;
            middle = 200L;
            end = 500L;
        } else {
            try {
                begin = Long.parseLong(split[0]);
                middle = Long.parseLong(split[1]);
                end = Long.parseLong(split[2]);
            }
            catch (Exception e) {
                begin = 0L;
                middle = 200L;
                end = 500L;
            }
        }
        if (begin <= costTime && costTime <= middle) {
            return 0;
        }
        if (middle < costTime && costTime <= end) {
            return 1;
        }
        return -1;
    }

    public static JSONArray testRpc(String registerAppIds) {
        JSONArray array = new JSONArray();
        if (registerAppIds != null) {
            if (Instance.isAppSplit()) {
                String[] appIds;
                for (String appId : appIds = registerAppIds.split(",")) {
                    if (!StringUtils.isNotEmpty((String)appId)) continue;
                    array.add((Object)ClusterChecker.getAppStatus(appId, System.currentTimeMillis()));
                }
            } else {
                JSONObject bos = ClusterChecker.getAppStatus("bos", System.currentTimeMillis());
                bos.put("appSplit", (Object)false);
                array.add((Object)bos);
            }
        }
        return array;
    }

    public static JSONObject getAppStatus(String appId, long start) {
        JSONObject item = new JSONObject();
        item.put("consumer", (Object)Instance.getInstanceId());
        item.put("appId", (Object)appId);
        try {
            RequestContext rc = RequestContext.getOrCreate();
            if (rc.getTraceId() == null) {
                rc.setTraceId(TraceIdUtil.createTraceIdString());
            }
            item.put("traceId", (Object)rc.getTraceId());
            DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)appId);
            String instanceId = (String)service.invoke("kd.bos.ha.http.service.healthcheck.appcheck.AppCheckService", "AppCheckService", "getAppId", new Object[0]);
            item.put("provider", (Object)instanceId);
            item.put("cost", (Object)(System.currentTimeMillis() - start));
            item.put("status", (Object)0);
            item.put("msg", (Object)"success");
        }
        catch (Exception e) {
            item.put("cost", (Object)(System.currentTimeMillis() - start));
            item.put("msg", (Object)ExceptionHandler.getExceptionStackTrace((Throwable)e));
            item.put("status", (Object)-1);
        }
        return item;
    }

    static {
        redisPoolMap = new HashMap<String, Object>(8);
        kdConnectionPool = new HashMap<String, Object>(32);
        mqTesterCreator = new MqTesterCreator();
        try {
            redisFactory = Class.forName("kd.bos.redis.RedisFactory");
            Field filed = redisFactory.getDeclaredField("poolMap");
            filed.setAccessible(true);
            redisPoolMap = (Map)filed.get(redisFactory);
            kdDriverUtil = Class.forName("kd.bos.ksql.shell.KDDriverUtil");
            Field conCreatorMap = kdDriverUtil.getDeclaredField("conCreatorMap");
            conCreatorMap.setAccessible(true);
            kdConnectionPool = (Map)conCreatorMap.get(kdDriverUtil);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ServiceCheckTask
    extends RecursiveTask<List<JSONObject>> {
        private List<ServiceInfo> serviceList;
        private final String appName;
        private final String api;
        private final JSONObject originParams;

        public ServiceCheckTask(List<ServiceInfo> serviceList, String appName, String api, JSONObject params) {
            this.serviceList = serviceList;
            this.appName = appName;
            this.api = api;
            this.originParams = params;
        }

        @Override
        protected List<JSONObject> compute() {
            ArrayList<ServiceInfo> taskList = new ArrayList<ServiceInfo>(8);
            Iterator<ServiceInfo> iterator = this.serviceList.iterator();
            while (iterator.hasNext()) {
                ServiceInfo serviceInfo = iterator.next();
                if (!serviceInfo.getAppName().equals(this.appName)) continue;
                taskList.add(serviceInfo);
                iterator.remove();
            }
            if (this.serviceList.size() > 0) {
                ServiceCheckTask serviceCheckTask1 = new ServiceCheckTask(taskList, this.appName, this.api, this.originParams);
                serviceCheckTask1.fork();
                ServiceCheckTask serviceCheckTask2 = new ServiceCheckTask(this.serviceList, this.serviceList.get(0).getAppName(), this.api, this.originParams);
                serviceCheckTask2.fork();
                List join = (List)serviceCheckTask1.join();
                join.addAll((Collection)serviceCheckTask2.join());
                return join;
            }
            ArrayList<JSONObject> results = new ArrayList<JSONObject>(taskList.size());
            long totalStart = System.currentTimeMillis();
            for (ServiceInfo serviceInfo : taskList) {
                long start = System.currentTimeMillis();
                try {
                    if (serviceInfo.getInstanceId().equals(Instance.getInstanceId())) {
                        List<JSONObject> checkResult = ClusterChecker.getCheckResult();
                        this.addField(checkResult, serviceInfo);
                        results.addAll(checkResult);
                        continue;
                    }
                    String result = Grocery.httpPost((String)serviceInfo.getIp(), (int)Integer.parseInt(serviceInfo.getMonitorPort()), (String)this.originParams.toJSONString(), (String)this.api, (int)2000, (int)6000);
                    JSONObject parseObject = JSONObject.parseObject((String)result);
                    int status = parseObject.getIntValue("status");
                    if (status == 0) {
                        List checkResult = (List)parseObject.getObject("result", List.class);
                        this.addField(checkResult, serviceInfo);
                        results.addAll(checkResult);
                        continue;
                    }
                    JSONObject ofResult = ClusterChecker.ofResult(status, System.currentTimeMillis() - start, parseObject.getString("msg"), serviceInfo.getAppName(), serviceInfo.getInstanceId(), serviceInfo.getIp(), serviceInfo.getHostName());
                    ofResult.put("httpcost", (Object)parseObject.getLongValue("httpcost"));
                    results.add(ofResult);
                }
                catch (Exception e) {
                    results.add(ClusterChecker.ofResult(-1, System.currentTimeMillis() - start, ExceptionHandler.getExceptionStackTrace((Throwable)e), serviceInfo.getAppName(), serviceInfo.getInstanceId(), serviceInfo.getIp(), serviceInfo.getHostName()));
                }
            }
            return this.formatResult(results, System.currentTimeMillis() - totalStart);
        }

        private void addField(List<JSONObject> list, ServiceInfo serviceInfo) {
            for (JSONObject jsonObject : list) {
                jsonObject.put("ip", (Object)serviceInfo.getIp());
                jsonObject.put("hostName", (Object)serviceInfo.getHostName());
            }
        }

        private List<JSONObject> formatResult(List<JSONObject> results, long cost) {
            ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
            JSONObject formatObj = new JSONObject();
            objects.add(formatObj);
            formatObj.put("instances", results);
            formatObj.put("cost", (Object)cost);
            formatObj.put("appName", (Object)this.appName);
            try {
                boolean isError;
                String available_inst_ratio = System.getProperty("monitor.cluster_check.available_inst_ratio", "50");
                int errorNum = 0;
                int size = results.size();
                for (JSONObject result : results) {
                    if (result.getIntValue("status") != -1) continue;
                    ++errorNum;
                }
                float abnormalRate = (float)errorNum / (float)size * 100.0f;
                boolean bl = isError = abnormalRate >= Float.parseFloat(available_inst_ratio);
                formatObj.put("status", (Object)(isError ? -1 : (errorNum > 0 ? 1 : 0)));
                formatObj.put("msg", (Object)(isError ? "the abnormal rate of " + this.appName + " reached " + abnormalRate + "% ,more than " + available_inst_ratio + "%" : (errorNum > 0 ? "has error" : "success")));
            }
            catch (Exception e) {
                formatObj.put("status", (Object)-1);
                formatObj.put("msg", (Object)ExceptionHandler.getExceptionStackTrace((Throwable)e));
            }
            return objects;
        }
    }
}

