/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dts.handle;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dts.check.address.DestinationChecker;
import kd.bos.dts.check.address.DestinationCheckerFactory;
import kd.bos.dts.init.AddressStatus;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.dts.vo.DtsConfigVO;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.JSONUtils;

public class DtsConfigHandel
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final Log LOGGER = LogFactory.getLog(DtsConfigHandel.class);
    private static final DtsConfigHandel instance = new DtsConfigHandel();

    public String[] getPaths() {
        return new String[]{"/goldeye/dtsConfig/", "/goldeye/dtsConfig"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(2);
        try {
            List<DtsConfigVO> dtsConfigVOS = this.getDtsConfig();
            response.put("code", 0);
            response.put("data", dtsConfigVOS);
        }
        catch (Exception e) {
            LOGGER.error("query dts config error: ", (Throwable)e);
            response.put("code", -1);
            response.put("errorMsg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private List<DtsConfigVO> getDtsConfig() {
        ArrayList dtsConfigVOS = new ArrayList(10);
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        HashSet allSet = new HashSet(10);
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            try {
                if (DtsAccountPower.isAccountDtsEnable()) {
                    List ls = DtsSnapConfigDao.instance.getDestinationInfo();
                    ls.forEach(address -> {
                        if (allSet.add(address)) {
                            this.addConfig(dtsConfigVOS, (AddressStatus)address);
                        }
                    });
                }
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
        List result = dtsConfigVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DtsConfigVO>(Comparator.comparing(o -> o.getAddress() + o.getDestype() + o.getStatus()))), ArrayList::new));
        return result;
    }

    private void addConfig(List<DtsConfigVO> dtsConfigVOS, AddressStatus address) {
        String destype = address.getDestinationtype();
        String region = address.getRegion();
        DtsConfigVO dtsConfigVO = new DtsConfigVO();
        dtsConfigVO.setDestype(destype);
        try {
            DestinationChecker checker = DestinationCheckerFactory.getChecker((String)destype, (String)region);
            dtsConfigVO.setAddress(checker.getAddrString());
            if (checker.isAvailable()) {
                dtsConfigVO.setStatus(1);
            } else {
                dtsConfigVO.setStatus(0);
                dtsConfigVO.setErrormsg(checker.getLastCheckInfo());
            }
        }
        catch (Exception e) {
            LOGGER.error("check dts config error: ", (Throwable)e);
            dtsConfigVO.setStatus(0);
            dtsConfigVO.setErrormsg(e.getMessage());
        }
        dtsConfigVOS.add(dtsConfigVO);
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

