/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dts.master;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.trace.util.TraceIdUtil;

public class ElectorMaster {
    private static final Log LOGGER = LogFactory.getLog(ElectorMaster.class);

    public static String getMasterByAppId(String appid) {
        RequestContext rc = RequestContext.getOrCreate();
        if (rc.getTraceId() == null) {
            rc.setTraceId(TraceIdUtil.createTraceIdString());
        }
        appid = ServiceLookup.getServiceAppId((String)appid);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)appid);
        try {
            String instanceId = (String)service.invoke("kd.bos.eye.api.dts.master.MasterFindService", "MasterFindService", "getMasterByAppId", new Object[]{appid});
            LOGGER.info("ElectorMaster getMasterByAppId appid: " + appid + ",instanceId:" + instanceId);
            return instanceId;
        }
        catch (Exception e) {
            LOGGER.error("ElectorMaster getMasterByAppId error: ", (Throwable)e);
            return null;
        }
    }
}

