/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import kd.bos.extension.ExtensionFactory;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.mq.MqMgr;
import kd.bos.eye.api.mq.support.vo.MqConsumerVO;
import kd.bos.eye.api.mq.support.vo.MqEyeMeta;
import kd.bos.eye.api.mq.support.vo.MqFieldVO;
import kd.bos.eye.api.mq.support.vo.MqListVO;
import kd.bos.eye.api.mq.support.vo.MqStatusVO;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class MqMgrHandler
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static Log logger = LogFactory.getLog(MqMgrHandler.class);
    private static ExtensionFactory<MqMgr> mqMgrExtensionFactory = ExtensionFactory.getExtensionFacotry(MqMgr.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String V_HOST = "vhost";
    private static final String MQ_TYPE_KEY = "type";
    private static final MqMgrHandler instance = new MqMgrHandler();

    public String[] getPaths() {
        return new String[]{"/eye/mqList"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        String mqType = "";
        Properties prop = new Properties();
        try {
            String action;
            String property = System.getProperty("mq.server");
            StringReader reader = new StringReader(property);
            prop.load(reader);
            String vhost = prop.getProperty(V_HOST);
            mqType = QueueManager.getMQType((String)"NotExistRegion##@@!!");
            MqMgr mqMgr = (MqMgr)mqMgrExtensionFactory.getExtension(mqType);
            if (mqMgr == null) {
                response.setMsg("MQ monitor not support:" + mqType);
                response.setCode(Integer.valueOf(-1));
                String str = JSONUtils.toString((Object)response);
                this.writeJson(str, exchange);
                return;
            }
            Map params = EyeUriQuery.toMap((String)exchange.getRequestURI().getQuery());
            params.put(V_HOST, vhost);
            switch (action = (String)params.get("action")) {
                case "metas": {
                    MqEyeMeta mqMeta = mqMgr.getMqMeta();
                    response.setData((Object)mqMeta);
                    break;
                }
                case "queues": {
                    if (mqType != null && (mqType.equals("rocketmq") || mqType.equals("kafka"))) {
                        MqListVO mqListVO = mqMgr.queueList(params);
                        mqListVO.setVhost(vhost);
                        response.setData((Object)mqListVO);
                        break;
                    }
                    JSONObject data = mqMgr.process(params);
                    data.put(V_HOST, (Object)vhost);
                    response.setData((Object)data);
                    break;
                }
                case "status": {
                    MqStatusVO mqStatusVO = mqMgr.status((String)params.get("name"));
                    response.setData((Object)mqStatusVO);
                    break;
                }
                case "consumers": {
                    if (mqType != null && (mqType.equals("rocketmq") || mqType.equals("kafka"))) {
                        MqConsumerVO mqConsumerVO = mqMgr.consumers((String)params.get("name"));
                        response.setData((Object)mqConsumerVO);
                        break;
                    }
                    params.put("action", "queueDetail");
                    params.put("queue", params.get("name"));
                    JSONObject data = mqMgr.process(params);
                    data.put(V_HOST, (Object)vhost);
                    String resourceIdPrefix = "RabbitmqMgrHandler_";
                    ArrayList<MqFieldVO> consumersFields = new ArrayList<MqFieldVO>();
                    consumersFields.add(new MqFieldVO("channel", LangRes.get(resourceIdPrefix + "8", "Channel", new Object[0])));
                    consumersFields.add(new MqFieldVO("channel_info", LangRes.get(resourceIdPrefix + "9", "Channel Details", new Object[0])));
                    consumersFields.add(new MqFieldVO("consumer_tag", LangRes.get(resourceIdPrefix + "10", "Consumer Tags", new Object[0])));
                    consumersFields.add(new MqFieldVO("prefetch_count", LangRes.get(resourceIdPrefix + "11", "Concurrency", new Object[0])));
                    consumersFields.add(new MqFieldVO("arguments", LangRes.get(resourceIdPrefix + "12", "Arguments", new Object[0])));
                    data.put("consumersFields", consumersFields);
                    response.setData((Object)data);
                    break;
                }
                default: {
                    JSONObject data = mqMgr.process(params);
                    data.put(V_HOST, (Object)vhost);
                    response.setData((Object)data);
                }
            }
            response.setCode(Integer.valueOf(0));
            this.opLogger(exchange, params);
        }
        catch (Exception e) {
            logger.error("MqMgrHandler:", (Throwable)e);
            if (!mqMgrExtensionFactory.existsExtension(mqType)) {
                response.setMsg("MQ monitor not support:" + mqType);
            } else {
                response.setMsg("MQ monitor Exception:" + e.getMessage());
            }
            response.setCode(Integer.valueOf(-1));
        }
        String str = JSONUtils.toString((Object)response);
        this.writeJson(str, exchange);
    }

    private void opLogger(HttpExchange exchange, Map<String, String> params) {
        String name;
        String action = params.get("action");
        String queue = params.get("queue");
        if (action.equals("queues") && StringUtils.isNotEmpty((String)(name = params.get("name")))) {
            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get("MqMgrHandler_0", "MQ Monitoring", new Object[0]), LangRes.get("MqMgrHandler_1", "Query Queue with Name {0}", name));
        }
        if (action.equals("queueDetail")) {
            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get("MqMgrHandler_0", "MQ Monitoring", new Object[0]), LangRes.get("MqMgrHandler_3", "Queried Data in Queue: {0}", queue));
        }
    }
}

