/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.jms;

import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.mq.jms.ActionProcessor;
import kd.bos.mq.support.monitor.vo.QueueInfo;
import kd.bos.mq.support.monitor.vo.QueuePanel;

public abstract class AbstractActionProcessor
implements ActionProcessor {
    @Override
    public JSONObject buildResult(Map<String, String> params) throws Exception {
        QueuePanel queuePanel = this.doQuery(params);
        if (queuePanel == null) {
            return new JSONObject();
        }
        int pageNum = Integer.parseInt(params.get("page") != null ? params.get("page") : "1");
        int pageSize = Integer.parseInt(params.get("page_size") != null ? params.get("page_size") : "100");
        int count = queuePanel.getTotalCount() / pageSize;
        queuePanel.setPageCount(queuePanel.getTotalCount() % pageSize == 0 ? count : count + 1);
        queuePanel.setPageSize(pageSize);
        String orderField = params.get("sort");
        boolean isDesc = "des".equals(params.get("asc"));
        this.sort(orderField, isDesc, queuePanel.getQueueInfos());
        this.splitPage(pageNum, pageSize, queuePanel.getQueueInfos());
        return this.doBuildResult(queuePanel);
    }

    private void sort(String orderField, boolean isDesc, List<QueueInfo> queueInfoList) {
        if ("messages".equals(orderField)) {
            queueInfoList.sort((o1, o2) -> {
                if (isDesc) {
                    return (int)(o2.getTotal() - o1.getTotal());
                }
                return (int)(o1.getTotal() - o2.getTotal());
            });
        } else if ("messages_ready".equals(orderField)) {
            queueInfoList.sort((o1, o2) -> {
                if (isDesc) {
                    return (int)(o2.getReady() - o1.getReady());
                }
                return (int)(o1.getReady() - o2.getReady());
            });
        } else if ("messages_unacknowledged".equals(orderField)) {
            queueInfoList.sort((o1, o2) -> {
                if (isDesc) {
                    return (int)(o2.getUnacknowledged() - o1.getUnacknowledged());
                }
                return (int)(o1.getUnacknowledged() - o2.getUnacknowledged());
            });
        }
    }

    private void splitPage(int pageNum, int pageSize, List<QueueInfo> queueInfoList) {
        int startNum = (pageNum - 1) * pageSize;
        int endNum = startNum + (pageSize - 1);
        Iterator<QueueInfo> it = queueInfoList.iterator();
        int i = 0;
        while (it.hasNext()) {
            it.next();
            if (i < startNum || i > endNum) {
                it.remove();
            }
            ++i;
        }
    }

    protected abstract QueuePanel doQuery(Map<String, String> var1) throws Exception;

    protected abstract JSONObject doBuildResult(QueuePanel var1);
}

