/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.kafka.handler;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.mq.MqMgr;
import kd.bos.eye.api.mq.kafka.vo.KafkaConsumerDataVO;
import kd.bos.eye.api.mq.kafka.vo.KafkaListDataVO;
import kd.bos.eye.api.mq.kafka.vo.KafkaStatusDataVO;
import kd.bos.eye.api.mq.rabbit.ConfigPicker;
import kd.bos.eye.api.mq.support.vo.MqConsumerDataVO;
import kd.bos.eye.api.mq.support.vo.MqConsumerVO;
import kd.bos.eye.api.mq.support.vo.MqEyeMeta;
import kd.bos.eye.api.mq.support.vo.MqFieldVO;
import kd.bos.eye.api.mq.support.vo.MqListDataVO;
import kd.bos.eye.api.mq.support.vo.MqListVO;
import kd.bos.eye.api.mq.support.vo.MqStatusDataVO;
import kd.bos.eye.api.mq.support.vo.MqStatusVO;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.kafka.KafkaConfig;
import kd.bos.mq.kafka.KafkaMQTopicUtil;
import kd.bos.util.StringUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;

public class KafkaMgrHandler
implements MqMgr {
    private static final Log LOGGER = LogFactory.getLog(KafkaMgrHandler.class);
    private static final String SYSTEM_GROUPID = "kafka-eye-system-group";
    private AdminClient ADMIN_CLIENT;
    private Map<String, String> TOPIC_GROUPID_MAP = new HashMap<String, String>();
    private Map<String, Integer> TOPIC_PARTITIONS_MAP = new HashMap<String, Integer>();

    @Override
    public MqEyeMeta getMqMeta() {
        MqEyeMeta mqEyeMeta = new MqEyeMeta();
        mqEyeMeta.setMqType("kafka");
        mqEyeMeta.setApiNewVersion(true);
        mqEyeMeta.setApiPage(false);
        mqEyeMeta.setQueueFields(Collections.singletonList(new MqFieldVO("topic", LangRes.get("KafkaMgrHandler_3", "Topic", new Object[0]))));
        mqEyeMeta.setOperations(Arrays.asList(new MqFieldVO("status", LangRes.get("KafkaMgrHandler_1", "Status", new Object[0])), new MqFieldVO("consumers", LangRes.get("KafkaMgrHandler_2", "Consumer", new Object[0]))));
        return mqEyeMeta;
    }

    private AdminClient getMQAdmin() {
        try {
            if (this.ADMIN_CLIENT != null) {
                return this.ADMIN_CLIENT;
            }
            Field adminClientField = KafkaMQTopicUtil.class.getDeclaredField("ADMIN_CLIENT");
            adminClientField.setAccessible(true);
            this.ADMIN_CLIENT = (AdminClient)adminClientField.get(null);
            return this.ADMIN_CLIENT;
        }
        catch (Exception e) {
            LOGGER.error("error when KafkaMgrHandler getMQAdmin:", (Throwable)e);
            throw new KDException(BosErrorCode.kafkaException, "error when KafkaMgrHandler getMQAdmin", (Throwable)e);
        }
    }

    @Override
    public MqListVO queueList(Map<String, String> params) {
        MqListVO mqListVO = new MqListVO();
        AdminClient mqAdmin = this.getMQAdmin();
        if (mqAdmin == null) {
            return mqListVO;
        }
        try {
            String name = params.get("name");
            ListTopicsResult listTopicsResult = this.ADMIN_CLIENT.listTopics();
            Collection topicListingCollection = (Collection)listTopicsResult.listings().get();
            ArrayList<MqListDataVO> mqListDataVOList = new ArrayList<MqListDataVO>(topicListingCollection.size());
            mqListVO.setItems(mqListDataVOList);
            ConfigPicker cp = new ConfigPicker();
            if (StringUtils.isNotEmpty((String)name)) {
                for (TopicListing tempTopic : topicListingCollection) {
                    if (!tempTopic.name().startsWith(cp.getVhost()) || !tempTopic.name().contains(name)) continue;
                    mqListDataVOList.add(new KafkaListDataVO(tempTopic.name()));
                }
            } else {
                for (TopicListing tempTopic : topicListingCollection) {
                    if (!tempTopic.name().startsWith(cp.getVhost())) continue;
                    mqListDataVOList.add(new KafkaListDataVO(tempTopic.name()));
                }
            }
            mqListVO.setTotal_count(topicListingCollection.size());
            int filteredCount = mqListDataVOList.size();
            mqListVO.setFiltered_count(filteredCount);
            int pageSize = Integer.parseInt(params.get("page_size"));
            mqListVO.setPage_size(pageSize);
            int pageCount = filteredCount / pageSize + (filteredCount % pageSize == 0 ? 0 : 1);
            mqListVO.setPage_count(pageCount);
            int itemCount = filteredCount;
            mqListVO.setItem_count(itemCount);
        }
        catch (Exception e) {
            LOGGER.error("error when KafkaMgrHandler queueList:", (Throwable)e);
            throw new KDException(BosErrorCode.kafkaException, "error when KafkaMgrHandler queueList", (Throwable)e);
        }
        return mqListVO;
    }

    @Override
    public MqStatusVO status(String topic) {
        MqStatusVO mqStatusVO = new MqStatusVO(topic);
        ArrayList<MqFieldVO> statusFields = new ArrayList<MqFieldVO>();
        statusFields.add(new MqFieldVO("topic", LangRes.get("KafkaMgrHandler_3", "Topic", new Object[0])));
        statusFields.add(new MqFieldVO("partition", LangRes.get("KafkaMgrHandler_4", "Queue", new Object[0])));
        statusFields.add(new MqFieldVO("logSize", LangRes.get("KafkaMgrHandler_5", "Message Total", new Object[0])));
        mqStatusVO.setStatusFields(statusFields);
        AdminClient mqAdmin = this.getMQAdmin();
        if (mqAdmin == null) {
            return mqStatusVO;
        }
        try (KafkaConsumer<String, byte[]> kafkaConsumer = null;){
            DescribeTopicsResult describeTopicsResult = this.ADMIN_CLIENT.describeTopics(Collections.singletonList(topic));
            Map topic2futureMap = describeTopicsResult.values();
            ArrayList<MqStatusDataVO> statusDataVOList = new ArrayList<MqStatusDataVO>();
            mqStatusVO.setItems(statusDataVOList);
            kafkaConsumer = this.getKafkaConsumer();
            for (Map.Entry tempEntry : topic2futureMap.entrySet()) {
                TopicDescription topicDescription = (TopicDescription)((KafkaFuture)tempEntry.getValue()).get();
                List partitionInfoList = topicDescription.partitions();
                this.TOPIC_PARTITIONS_MAP.putIfAbsent(topic, partitionInfoList.size());
                for (TopicPartitionInfo tempPartition : partitionInfoList) {
                    KafkaStatusDataVO kafkaStatusDataVO = new KafkaStatusDataVO();
                    kafkaStatusDataVO.setTopic(topic);
                    int partition = tempPartition.partition();
                    kafkaStatusDataVO.setPartition(partition);
                    TopicPartition tp = new TopicPartition(topic, partition);
                    kafkaConsumer.assign(Collections.singleton(tp));
                    Map endLogSize = kafkaConsumer.endOffsets(Collections.singleton(tp), Duration.ofMillis(3000L));
                    long realLogSize = (Long)endLogSize.get(tp);
                    kafkaStatusDataVO.setLogSize(realLogSize);
                    statusDataVOList.add(kafkaStatusDataVO);
                }
            }
        }
        return mqStatusVO;
    }

    @Override
    public MqConsumerVO consumers(String topic) {
        MqConsumerVO mqConsumerVO = new MqConsumerVO(topic);
        ArrayList<MqFieldVO> consumersFields = new ArrayList<MqFieldVO>();
        consumersFields.add(new MqFieldVO("subscriptionGroup", LangRes.get("KafkaMgrHandler_6", "Consumer Group", new Object[0])));
        consumersFields.add(new MqFieldVO("partition", LangRes.get("KafkaMgrHandler_4", "Partition", new Object[0])));
        consumersFields.add(new MqFieldVO("brokerOffset", LangRes.get("KafkaMgrHandler_7", "Broker Offset", new Object[0])));
        consumersFields.add(new MqFieldVO("consumerOffset", LangRes.get("KafkaMgrHandler_8", "Consumer Offset", new Object[0])));
        consumersFields.add(new MqFieldVO("diffTotal", LangRes.get("KafkaMgrHandler_9", "Difference", new Object[0])));
        consumersFields.add(new MqFieldVO("groupActiveThreads", LangRes.get("KafkaMgrHandler_10", "Group Active Threads", new Object[0])));
        mqConsumerVO.setConsumersFields(consumersFields);
        AdminClient mqAdmin = this.getMQAdmin();
        if (mqAdmin == null) {
            return mqConsumerVO;
        }
        try (KafkaConsumer<String, byte[]> kafkaConsumer = null;){
            ArrayList<MqConsumerDataVO> consumerDataVOList = new ArrayList<MqConsumerDataVO>(5);
            mqConsumerVO.setItems(consumerDataVOList);
            String group = this.getGroupIdByTopic(topic);
            DescribeConsumerGroupsResult descConsumerGroup = this.ADMIN_CLIENT.describeConsumerGroups(Collections.singletonList(group));
            Collection consumerMetaInfoColl = ((ConsumerGroupDescription)((KafkaFuture)descConsumerGroup.describedGroups().get(group)).get()).members();
            kafkaConsumer = this.getKafkaConsumer();
            Map partitionOffsetAndMetadataMap = (Map)this.ADMIN_CLIENT.listConsumerGroupOffsets(group).partitionsToOffsetAndMetadata().get();
            HashMap<Integer, KafkaConsumerDataVO> partition2ConsumerDataVO_map = new HashMap<Integer, KafkaConsumerDataVO>(partitionOffsetAndMetadataMap.size());
            for (Map.Entry tempEntry : partitionOffsetAndMetadataMap.entrySet()) {
                TopicPartition topicPartition = (TopicPartition)tempEntry.getKey();
                if (!topicPartition.topic().equals(topic)) continue;
                OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tempEntry.getValue();
                KafkaConsumerDataVO kafkaConsumerDataVO = new KafkaConsumerDataVO();
                kafkaConsumerDataVO.setSubscriptionGroup(group);
                kafkaConsumerDataVO.setPartition(topicPartition.partition());
                TopicPartition tp = new TopicPartition(topic, topicPartition.partition());
                kafkaConsumer.assign(Collections.singleton(tp));
                Map endLogSize = kafkaConsumer.endOffsets(Collections.singleton(tp), Duration.ofMillis(3000L));
                long realLogSize = (Long)endLogSize.get(tp);
                kafkaConsumerDataVO.setBrokerOffset(realLogSize);
                kafkaConsumerDataVO.setConsumerOffset(offsetAndMetadata.offset());
                long diffTotal = realLogSize - offsetAndMetadata.offset();
                kafkaConsumerDataVO.setDiffTotal(diffTotal);
                kafkaConsumerDataVO.setGroupActiveThreads(consumerMetaInfoColl.size());
                partition2ConsumerDataVO_map.put(topicPartition.partition(), kafkaConsumerDataVO);
            }
            int partitions = this.getPartitionsByTopic(topic);
            for (int i = 0; i < partitions; ++i) {
                KafkaConsumerDataVO kafkaConsumerDataVO = (KafkaConsumerDataVO)partition2ConsumerDataVO_map.get(i);
                if (kafkaConsumerDataVO == null) {
                    kafkaConsumerDataVO = new KafkaConsumerDataVO();
                    kafkaConsumerDataVO.setSubscriptionGroup(group);
                    kafkaConsumerDataVO.setPartition(i);
                    TopicPartition tp = new TopicPartition(topic, i);
                    kafkaConsumer.assign(Collections.singleton(tp));
                    Map endLogSize = kafkaConsumer.endOffsets(Collections.singleton(tp), Duration.ofMillis(3000L));
                    long realLogSize = (Long)endLogSize.get(tp);
                    kafkaConsumerDataVO.setBrokerOffset(realLogSize);
                    kafkaConsumerDataVO.setConsumerOffset(0L);
                    kafkaConsumerDataVO.setDiffTotal(realLogSize);
                    kafkaConsumerDataVO.setGroupActiveThreads(consumerMetaInfoColl.size());
                }
                consumerDataVOList.add(kafkaConsumerDataVO);
            }
        }
        return mqConsumerVO;
    }

    private KafkaConsumer<String, byte[]> getKafkaConsumer() {
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)"mq.server");
        Properties consumerConfig = KafkaConfig.getConsumerConfig((KafkaInfo)kafkaInfo);
        consumerConfig.put("group.id", SYSTEM_GROUPID);
        return new KafkaConsumer(consumerConfig);
    }

    private String getGroupIdByTopic(String topic) {
        if (this.TOPIC_GROUPID_MAP.containsKey(topic)) {
            return this.TOPIC_GROUPID_MAP.get(topic);
        }
        String groupId = "";
        boolean isFind = false;
        try {
            Collection groupListingCollection = (Collection)this.ADMIN_CLIENT.listConsumerGroups().all().get();
            for (ConsumerGroupListing tempConsumerGroupListing : groupListingCollection) {
                String tempGroupId = tempConsumerGroupListing.groupId();
                DescribeConsumerGroupsResult descConsumerGroup = this.ADMIN_CLIENT.describeConsumerGroups(Collections.singletonList(tempGroupId));
                Collection consumerMetaInfoColl = ((ConsumerGroupDescription)((KafkaFuture)descConsumerGroup.describedGroups().get(tempGroupId)).get()).members();
                for (MemberDescription tempMemberDescription : consumerMetaInfoColl) {
                    Set topicPartitionSet = tempMemberDescription.assignment().topicPartitions();
                    for (TopicPartition tempTopicPartition : topicPartitionSet) {
                        if (!tempTopicPartition.topic().equals(topic)) continue;
                        groupId = tempGroupId;
                        isFind = true;
                        this.TOPIC_GROUPID_MAP.put(topic, groupId);
                        break;
                    }
                    if (!isFind) continue;
                    break;
                }
                if (!isFind) continue;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("error when KafkaMgrHandler getGroupIdByTopic:", (Throwable)e);
            throw new KDException(BosErrorCode.kafkaException, "error when KafkaMgrHandler getGroupIdByTopic", (Throwable)e);
        }
        return groupId;
    }

    private int getPartitionsByTopic(String topic) {
        if (this.TOPIC_PARTITIONS_MAP.containsKey(topic)) {
            return this.TOPIC_PARTITIONS_MAP.get(topic);
        }
        int partitions = 0;
        try {
            DescribeTopicsResult describeTopicsResult = this.ADMIN_CLIENT.describeTopics(Collections.singletonList(topic));
            Map topic2futureMap = describeTopicsResult.values();
            for (Map.Entry tempEntry : topic2futureMap.entrySet()) {
                TopicDescription topicDescription = (TopicDescription)((KafkaFuture)tempEntry.getValue()).get();
                List partitionInfoList = topicDescription.partitions();
                this.TOPIC_PARTITIONS_MAP.putIfAbsent(topic, partitionInfoList.size());
                partitions = partitionInfoList.size();
            }
        }
        catch (Exception e) {
            LOGGER.error("error when KafkaMgrHandler getPartitionsByTopic:", (Throwable)e);
            throw new KDException(BosErrorCode.kafkaException, "error when KafkaMgrHandler getPartitionsByTopic", (Throwable)e);
        }
        return partitions;
    }
}

