/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.manage;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.mq.manage.MqConsumerManagerInfo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;

public class MqConsumerApiHandler
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final MqConsumerApiHandler instance = new MqConsumerApiHandler();
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    public String[] getPaths() {
        return new String[]{"/goldeye/mqconsumermanage/", "/goldeye/mqconsumermanage"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    public void handle0(HttpExchange exchange) throws IOException {
        Map params = EyeUriQuery.toMap((String)exchange.getRequestURI().getRawQuery());
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        String restartmqkey = (String)params.get("restartmqkey");
        if (restartmqkey != null) {
            QueueManager.resetConsumer((String)restartmqkey);
            String ip = NetAddressUtils.getLocalIpAddress();
            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get("MqConsumerApiHandler_1", "MQ Consumer Monitoring", new Object[0]), LangRes.get("MqConsumerApiHandler_2", "Reset MQ Consumer Queue of Node [{0}]: {1}", ip, restartmqkey));
        }
        String mqNamekeyFilter = (String)params.get("mqNamekey");
        List<MqConsumerManagerInfo> data = this.getMqConsumers(mqNamekeyFilter);
        this.sortData(data, params);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("code", 0);
        response.put("data", data);
        response.put("msg", "success");
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private List<MqConsumerManagerInfo> getMqConsumers(String mqNamekeyFilter) {
        ArrayList<MqConsumerManagerInfo> infos = new ArrayList<MqConsumerManagerInfo>(8);
        SimpleDateFormat dff = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        QueueManager.getConsumers().forEach((mqkey, v) -> {
            if (v instanceof Consumer) {
                Consumer consumer = (Consumer)v;
                MqConsumerManagerInfo info = new MqConsumerManagerInfo();
                info.setMqName((String)mqkey);
                info.setStarted(consumer.isStarted());
                Date startDate = consumer.getStartAt();
                if (startDate != null) {
                    info.setLastStartTime(dff.format(startDate));
                }
                if (mqNamekeyFilter == null || mqkey.toLowerCase().contains(mqNamekeyFilter.toLowerCase())) {
                    infos.add(info);
                }
            }
        });
        return infos;
    }

    private void sortData(List<MqConsumerManagerInfo> data, Map<String, String> params) {
        String orderField = params.get("orderField");
        String orderType = params.get("orderType");
        boolean isDesc = "descending".equals(orderType);
        if ("mqName".equals(orderField)) {
            data.sort((o1, o2) -> {
                if (o1 == null || o2 == null || o1.getMqName() == null || o2.getMqName() == null) {
                    return -1;
                }
                if (isDesc) {
                    return o2.getMqName().compareTo(o1.getMqName());
                }
                return o1.getMqName().compareTo(o2.getMqName());
            });
        } else if ("lastStartTime".equals(orderField)) {
            data.sort((o1, o2) -> {
                if (isDesc) {
                    if (o1 == null || o1.getLastStartTime() == null) {
                        return 1;
                    }
                    if (o2 == null || o2.getLastStartTime() == null) {
                        return -1;
                    }
                    return o2.getLastStartTime().compareTo(o1.getLastStartTime());
                }
                if (o1 == null || o1.getLastStartTime() == null) {
                    return -1;
                }
                if (o2 == null || o2.getLastStartTime() == null) {
                    return 1;
                }
                return o1.getLastStartTime().compareTo(o2.getLastStartTime());
            });
        } else if ("started".equals(orderField)) {
            data.sort((o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (isDesc) {
                    return Boolean.compare(o2.isStarted(), o1.isStarted());
                }
                return Boolean.compare(o1.isStarted(), o2.isStarted());
            });
        }
    }
}

