/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.pigeon;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.mq.pigeon.AbstractPigeonHandler;
import kd.bos.eye.api.mq.pigeon.vo.PigeonElectorNodeVO;
import kd.bos.eye.api.mq.pigeon.vo.PigeonSchQueueVO;
import kd.bos.eye.api.mq.pigeon.vo.PigeonServiceInfoVO;
import kd.bos.eye.api.mq.pigeon.vo.PigeonSimpleAccountVO;
import kd.bos.eye.api.mq.pigeon.vo.PigeonSimpleAccountVOWrapper;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.pigeon.PigeonQueueManager;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.pigeon.core.sch.PigeonSch;
import kd.bos.pigeon.core.sch.PigeonSchService;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.dispatch.mservice.DispatchServiceFactory;
import kd.bos.pigeon.elect.ElectorManager;
import kd.bos.pigeon.elect.ElectorNode;
import kd.bos.pigeon.elect.ElectorRole;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;

public class PigeonClusterHandler
extends AbstractPigeonHandler {
    private static final Log LOGGER = LogFactory.getLog(PigeonClusterHandler.class);
    private static final String resourceIdPrefix = "PigeonClusterHandler_";
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);
    private static final String PLACEHOLDER = "/cluster/";

    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        response.setCode(Integer.valueOf(-1));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        response.setData(map);
        try {
            String endPoint;
            Map params = EyeUriQuery.toMap((String)exchange.getRequestURI().getRawQuery());
            URI uri = exchange.getRequestURI();
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(PLACEHOLDER);
            switch (endPoint = reqPath.substring(pos + PLACEHOLDER.length())) {
                case "node/candidate": {
                    String instanceId = this.getPigeonCandidateInstanceId();
                    List serviceInfoList = ServiceInfoFactory.get().getServiceList();
                    for (ServiceInfo tempServiceInfo : serviceInfoList) {
                        if (!tempServiceInfo.getInstanceId().equals(instanceId)) continue;
                        PigeonServiceInfoVO pigeonServiceInfoVO = new PigeonServiceInfoVO();
                        pigeonServiceInfoVO.setIp(tempServiceInfo.getIp());
                        pigeonServiceInfoVO.setMonitorPort(tempServiceInfo.getMonitorPort());
                        pigeonServiceInfoVO.setInstanceId(tempServiceInfo.getInstanceId());
                        map.put("candidate", pigeonServiceInfoVO);
                        break;
                    }
                    response.setCode(Integer.valueOf(0));
                    break;
                }
                case "proxy/node/masterSlave": {
                    ArrayList<PigeonElectorNodeVO> masterSlaveElectorNodeVOList = new ArrayList<PigeonElectorNodeVO>(10);
                    ElectorNode masterNode = ElectorManager.getMasterNode();
                    if (FailoverConfig.MQ_FAILOVER_ENABLE && masterNode == null) {
                        map.put("masterSlaveList", masterSlaveElectorNodeVOList);
                        response.setCode(Integer.valueOf(0));
                        break;
                    }
                    PigeonElectorNodeVO masterElectorNodeVO = this.convertMonitorElectorNodeVO(masterNode);
                    masterElectorNodeVO.setType(ElectorRole.MASTER.getDesc());
                    masterSlaveElectorNodeVOList.add(masterElectorNodeVO);
                    Set slaveNodeSet = ElectorManager.getCopySlaveNodeSet();
                    if (CollectionUtils.isNotEmpty((Collection)slaveNodeSet)) {
                        for (ElectorNode tempElectorNode : slaveNodeSet) {
                            PigeonElectorNodeVO tempElectorNodeVO = this.convertMonitorElectorNodeVO(tempElectorNode);
                            tempElectorNodeVO.setType(ElectorRole.SLAVE.getDesc());
                            masterSlaveElectorNodeVOList.add(tempElectorNodeVO);
                        }
                    }
                    map.put("masterSlaveList", masterSlaveElectorNodeVOList);
                    response.setCode(Integer.valueOf(0));
                    break;
                }
                case "proxy/schedule/schTask": {
                    Collection allBiztypePigeonSchService = PigeonSchService.getAllPigeonSchService();
                    ArrayList<PigeonSchQueueVO> queueVOList = new ArrayList<PigeonSchQueueVO>(allBiztypePigeonSchService.size());
                    for (PigeonSchService tempPigeonSchService : allBiztypePigeonSchService) {
                        String bizType = tempPigeonSchService.getBizType();
                        PigeonSchQueueVO queueVO = new PigeonSchQueueVO(bizType);
                        queueVOList.add(queueVO);
                        PigeonSch.Item[] itemArray = tempPigeonSchService.getPigeonSch().getQueue();
                        ArrayList<PigeonSchQueueVO.PigeonSchItemVO> itemVOList = new ArrayList<PigeonSchQueueVO.PigeonSchItemVO>(itemArray.length);
                        queueVO.setItemVOList(itemVOList);
                        for (PigeonSch.Item tempItem : itemArray) {
                            PigeonSchQueueVO.PigeonSchItemVO tempItemVO = new PigeonSchQueueVO.PigeonSchItemVO();
                            Account tempAccount = AccountUtils.getAccountById((String)tempItem.getRequestContext().getAccountId());
                            tempItemVO.setTenantId(tempAccount.getTenantId());
                            tempItemVO.setAccountId(tempAccount.getAccountId());
                            tempItemVO.setAccountName(tempAccount.getAccountName());
                            tempItemVO.setAccountNumber(tempAccount.getAccountNumber());
                            tempItemVO.setTaskName(tempItem.getTask().getName());
                            tempItemVO.setTaskInterval(tempItem.getTask().getInterval());
                            tempItemVO.setTaskNextRunTime(DateUtils.formatDate((Date)new Date(tempItem.getScheduledTime()), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
                            itemVOList.add(tempItemVO);
                        }
                    }
                    map.put("taskList", queueVOList);
                    response.setCode(Integer.valueOf(0));
                    break;
                }
                case "proxy/execution/count": {
                    int totalTaskQueueCount = 0;
                    int totalActiveThreadCount = 0;
                    for (IStoreDbConfig tempStoreDbConfig : ServiceLoader.load(IStoreDbConfig.class)) {
                        String bizType = tempStoreDbConfig.bizType();
                        int taskQueueSize = DispatchServiceFactory.getTaskQueueSize((String)bizType);
                        totalTaskQueueCount += taskQueueSize;
                        int activeThreadCount = DispatchServiceFactory.getActiveThreadCount((String)bizType);
                        totalActiveThreadCount += activeThreadCount;
                    }
                    map.put("totalTaskQueueCount", totalTaskQueueCount);
                    map.put("totalActiveThreadCount", totalActiveThreadCount);
                    response.setCode(Integer.valueOf(0));
                    break;
                }
                case "queue/status": {
                    Set noRouteQueueNameSet = PigeonQueueManager.getNoRouteQueueNameSet();
                    map.put("noRouteQueueList", noRouteQueueNameSet);
                    response.setCode(Integer.valueOf(0));
                    break;
                }
            }
        }
        catch (Exception e) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("PigeonClusterHandler exception, message: " + e.getMessage());
            LOGGER.error("PigeonClusterHandler exception, message: " + e);
        }
        String str = JSONUtils.toString((Object)response);
        this.writeJson(str, exchange);
    }

    private PigeonElectorNodeVO convertMonitorElectorNodeVO(ElectorNode electorNode) {
        PigeonElectorNodeVO electorNodeVO = new PigeonElectorNodeVO();
        PigeonServiceInfoVO serviceInfoVO = new PigeonServiceInfoVO();
        serviceInfoVO.setInstanceId(electorNode.getServiceInfo().getInstanceId());
        serviceInfoVO.setIp(electorNode.getServiceInfo().getIp());
        serviceInfoVO.setMonitorPort(electorNode.getServiceInfo().getMonitorPort());
        electorNodeVO.setServiceInfo(serviceInfoVO);
        ArrayList<PigeonSimpleAccountVOWrapper> simpleAccountWrapperList = new ArrayList<PigeonSimpleAccountVOWrapper>(electorNode.getTenantId2accountListMap().size());
        for (Map.Entry entry : electorNode.getTenantId2accountListMap().entrySet()) {
            String tenantId = (String)entry.getKey();
            List accountList = (List)entry.getValue();
            ArrayList<PigeonSimpleAccountVO> simpleAccountList = new ArrayList<PigeonSimpleAccountVO>(accountList.size());
            for (Account tempAccount : accountList) {
                PigeonSimpleAccountVO simpleAccountVO = new PigeonSimpleAccountVO();
                simpleAccountVO.setAccountId(tempAccount.getAccountId());
                simpleAccountVO.setAccountName(tempAccount.getAccountName());
                simpleAccountVO.setAccountNumber(tempAccount.getAccountNumber());
                simpleAccountVO.setTenantId(tempAccount.getTenantId());
                simpleAccountList.add(simpleAccountVO);
            }
            simpleAccountWrapperList.add(new PigeonSimpleAccountVOWrapper(tenantId, simpleAccountList));
        }
        electorNodeVO.setAccountInfo(simpleAccountWrapperList);
        return electorNodeVO;
    }

    private String getPigeonCandidateInstanceId() {
        String pigeonAppId = "pigeon";
        RequestContext rc = RequestContext.getOrCreate();
        if (rc.getTraceId() == null) {
            rc.setTraceId(TraceIdUtil.createTraceIdString());
        }
        pigeonAppId = ServiceLookup.getServiceAppId((String)pigeonAppId);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)pigeonAppId);
        String instanceId = (String)service.invoke("kd.bos.ha.http.service.healthcheck.appcheck.AppCheckService", "AppCheckService", "getAppId", new Object[0]);
        return instanceId;
    }
}

