/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.rabbit;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public class ConfigPicker {
    private Properties prop = new Properties();

    public ConfigPicker() {
        String serverInfo = System.getProperty("mq.server");
        StringReader reader = new StringReader(serverInfo);
        try {
            this.prop.load(reader);
        }
        catch (IOException e) {
            reader.close();
        }
    }

    public String getHost() {
        return this.prop.getProperty("host");
    }

    public int getPort() {
        return Integer.parseInt(this.prop.getProperty("port"));
    }

    public String getUser() {
        return this.prop.getProperty("user");
    }

    public String getPassword() {
        return this.prop.getProperty("password");
    }

    public String getWebPort() {
        String port = this.prop.getProperty("webport");
        if (port == null) {
            port = "15672";
        }
        return port;
    }

    public boolean isWebSSLenable() {
        String enable = this.prop.getProperty("web.ssl.enable", "false");
        return Boolean.parseBoolean(enable);
    }

    public boolean isWebCertificateEnable() {
        String certificate = this.prop.getProperty("web.certificate.enable", "false");
        return Boolean.parseBoolean(certificate);
    }

    public String getClientPath() {
        return this.prop.getProperty("ssl.certificate.clientPath");
    }

    public String getTrustPath() {
        return this.prop.getProperty("ssl.certificate.trustPath");
    }

    public String getSSLClientPassword() {
        return this.prop.getProperty("ssl.certificate.keyPassword");
    }

    public String getSSLTrustStorePassword() {
        return this.prop.getProperty("ssl.certificate.trustPassword");
    }

    public String getVhost() {
        return this.prop.getProperty("vhost");
    }
}

