/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.ksql.shell.KDDriverUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.testspeed.DetailSpeedItem;

public class KDDriverConnectionSpeedTest
implements SpeedTest {
    private static final Log logger = LogFactory.getLog(KDDriverConnectionSpeedTest.class);
    private String url;
    private String user;
    private String lastDetailTestInfo = "";
    Properties p = new Properties();
    private int slow = 50;
    private int supperSlow = 100;
    private boolean isOracle = false;
    private long testTime;

    public KDDriverConnectionSpeedTest(String url, String user) {
        this.url = url;
        this.user = user;
        String name = url.substring(url.indexOf(":jdbc:") + 6);
        if (name.startsWith("oracle")) {
            this.slow = 100;
            this.supperSlow = 150;
            this.isOracle = true;
        }
    }

    @Override
    public void doTest() {
        try {
            this.p.setProperty("user", this.user);
            ArrayList<DetailSpeedItem> ls = new ArrayList<DetailSpeedItem>(2);
            StringBuilder builder = new StringBuilder(LangRes.get("DBSpeedTest_0", "Test Statement: select 1", new Object[0]));
            builder.append("\n");
            long totalTime = 0L;
            long spend = 0L;
            long l = System.currentTimeMillis();
            try (Connection con = KDDriverUtil.connect((String)this.url, (Properties)this.p);){
                spend = System.currentTimeMillis() - l;
                totalTime += spend;
                ls.add(new DetailSpeedItem("getConnection", spend));
                l = System.currentTimeMillis();
                try (PreparedStatement st = con.prepareStatement("select 1");){
                    spend = System.currentTimeMillis() - l;
                    totalTime += spend;
                    ls.add(new DetailSpeedItem("prepareStatement", spend));
                    l = System.currentTimeMillis();
                    try (ResultSet rs = st.executeQuery();){
                        if (rs.next()) {
                            rs.getString(1);
                        }
                        spend = System.currentTimeMillis() - l;
                        totalTime += spend;
                        ls.add(new DetailSpeedItem("executeQuery", spend));
                        l = System.currentTimeMillis();
                    }
                }
            }
            spend = System.currentTimeMillis() - l;
            this.testTime = totalTime += spend;
            ls.add(new DetailSpeedItem("closeConnection", spend));
            ls.forEach(i -> builder.append(i.toString()).append("\n"));
            this.lastDetailTestInfo = builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "DbConnection";
    }

    @Override
    public String getUrl() {
        String name = this.url.substring(this.url.indexOf(":jdbc:") + 6);
        if (name.startsWith("oracle")) {
            return name.split("\\?")[0] + "$" + this.user;
        }
        return name.split("\\?")[0];
    }

    @Override
    public String getDes() {
        return LangRes.get("DBSpeedTest_2", "Test Type: Non-Connection Pool", new Object[0]) + "\n";
    }

    @Override
    public String getLastDetailTestInfo() {
        return this.lastDetailTestInfo;
    }

    public void setPassword(String password) {
        this.p.setProperty("password", password);
    }

    @Override
    public void getTestResult(TestResultInfo info) {
        try {
            long timestamp = this.test();
            info.setDes(this.getDes() + " " + this.getLastDetailTestInfo());
            if (timestamp >= 0L && timestamp <= (long)this.slow) {
                info.setStatus(1);
            } else if (timestamp > (long)this.slow && timestamp <= (long)this.supperSlow) {
                info.setStatus(2);
            } else if (timestamp > (long)this.supperSlow) {
                info.setStatus(3);
            }
            info.setTimestap(timestamp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            info.setTimestap(-1L);
            info.setDes(this.getDes() + ",exception:" + e.getMessage());
        }
    }

    @Override
    public String getStatusDes() {
        return this.isOracle ? LangRes.get("SpeedTestStatusDes_0", "Normal: {0}, Slow: {1}, Very Slow: {2}", "<=100ms", ">100ms&<=150ms", ">150ms") : LangRes.get("SpeedTestStatusDes_0", "Normal: {0}, Slow: {1}, Very Slow: {2}", "<=50ms", ">50ms&<=100ms", ">100ms");
    }

    @Override
    public long test() {
        this.doTest();
        return this.testTime;
    }
}

