/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest;

import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class RedisSpeedTest
implements SpeedTest {
    private static final Log logger = LogFactory.getLog(RedisSpeedTest.class);
    private String url;
    private String testMethod;
    private static final String MAGIC = "speedtest-k-" + Instance.getInstanceId();

    public RedisSpeedTest(String url, String testMethod) {
        this.url = url;
        this.testMethod = testMethod;
    }

    public RedisSpeedTest(String url) {
        this.url = url;
    }

    @Override
    public long test() {
        long testTime;
        if (this.testMethod == null) {
            long start = System.currentTimeMillis();
            this.doTest();
            return System.currentTimeMillis() - start;
        }
        try (JedisClient client = RedisFactory.getJedisClient((String)this.url);){
            String key = MAGIC + "-" + this.testMethod;
            client.set(key, MAGIC);
            long start = System.currentTimeMillis();
            if ("set".equals(this.testMethod)) {
                client.set(key, MAGIC);
            } else if ("get".equals(this.testMethod)) {
                client.get(key);
            } else {
                client.del(key);
            }
            testTime = System.currentTimeMillis() - start;
            client.del(key);
        }
        return testTime;
    }

    @Override
    public void doTest() {
        try (JedisClient client = RedisFactory.getJedisClient((String)this.url);){
            client.set(MAGIC, MAGIC);
            client.get(MAGIC);
            client.del(MAGIC);
        }
    }

    @Override
    public String getName() {
        return "Redis";
    }

    @Override
    public String getUrl() {
        int i = this.url.lastIndexOf(47);
        return i != -1 ? this.url.substring(0, i) : this.url;
    }

    @Override
    public String getDes() {
        return this.testMethod == null ? "set/get/del" : this.testMethod;
    }

    @Override
    public void getTestResult(TestResultInfo info) {
        try {
            long timestamp = this.test();
            info.setDes(this.getDes() + " " + this.getLastDetailTestInfo());
            if (timestamp >= 0L && timestamp <= 5L) {
                info.setStatus(1);
            } else if (timestamp > 5L && timestamp <= 20L) {
                info.setStatus(2);
            } else if (timestamp > 20L) {
                info.setStatus(3);
            }
            info.setTimestap(timestamp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            info.setTimestap(-1L);
            info.setDes(this.getDes() + ",exception:" + e.getMessage());
        }
    }

    @Override
    public String getStatusDes() {
        return LangRes.get("SpeedTestStatusDes_0", "Normal: {0}, Slow: {1}, Very Slow: {2}", "<=5ms", ">5ms&<=20ms", ">20ms");
    }
}

