/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest.configservice;

import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nacos.NacosConfigService;
import kd.bos.nacos.NacosFactory;

public class NacosSpeedTest
implements SpeedTest {
    private static final Log logger = LogFactory.getLog(NacosSpeedTest.class);
    private final String url;
    private String testMethod;

    public NacosSpeedTest(String url) {
        this.url = url;
    }

    public NacosSpeedTest(String url, String testMethod) {
        this.url = url;
        this.testMethod = testMethod;
    }

    @Override
    public long test() {
        long start = System.currentTimeMillis();
        this.doTest();
        return System.currentTimeMillis() - start;
    }

    @Override
    public void doTest() {
        try {
            NacosConfigService nacosConfigService = (NacosConfigService)NacosFactory.getConfigserviceMap().get(this.url);
            nacosConfigService.getConfig("test", "speed", 1000L);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "Nacos";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDes() {
        return this.testMethod == null ? "getConfig" : this.testMethod;
    }

    @Override
    public void getTestResult(TestResultInfo info) {
        try {
            long timestamp = this.test();
            info.setDes(this.getDes() + " " + this.getLastDetailTestInfo());
            if (timestamp >= 0L && timestamp <= 20L) {
                info.setStatus(1);
            } else if (timestamp > 20L && timestamp <= 40L) {
                info.setStatus(2);
            } else if (timestamp > 40L) {
                info.setStatus(3);
            }
            info.setTimestap(timestamp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            info.setTimestap(-1L);
            info.setDes(this.getDes() + ",exception:" + e.getMessage());
        }
    }

    @Override
    public String getStatusDes() {
        return LangRes.get("SpeedTestStatusDes_0", "Normal: {0}, Slow: {1}, Very Slow: {2}", "<=20ms", ">20ms&<=40ms", "40ms");
    }
}

